/*
 * Decompiled with CFR 0.152.
 */
package io.straas.android.sdk.messaging;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.v4.os.ParcelableCompat;
import android.support.v4.os.ParcelableCompatCreatorCallbacks;
import android.support.v4.util.SimpleArrayMap;
import android.text.TextUtils;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import io.straas.android.sdk.messaging.RawData;
import io.straas.android.sdk.messaging.User;
import io.straas.android.sdk.messaging.c;
import io.straas.android.sdk.messaging.http.MessagingEndpoint;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public final class Message
implements Parcelable,
CharSequence {
    private String a;
    private String b;
    private String c;
    private long d;
    private User e;
    private String f;
    private boolean g;
    public static final Parcelable.Creator<Message> CREATOR = ParcelableCompat.newCreator((ParcelableCompatCreatorCallbacks)new ParcelableCompatCreatorCallbacks<Message>(){

        public Message createFromParcel(Parcel in, ClassLoader loader) {
            return new Message(in, loader);
        }

        public Message[] newArray(int size) {
            return new Message[size];
        }
    });

    private Message(Builder builder) {
        this.a = builder.a;
        this.b = builder.b;
        this.c = builder.c;
        this.d = builder.d;
        this.e = builder.e;
        SimpleArrayMap simpleArrayMap = builder.f;
        if (simpleArrayMap != null && simpleArrayMap.containsKey((Object)this.c)) {
            this.g = true;
            this.f = (String)simpleArrayMap.get((Object)this.c);
        }
    }

    protected Message(Parcel in, ClassLoader loader) {
        this.a = in.readString();
        this.c = in.readString();
        this.d = in.readLong();
        this.e = (User)in.readParcelable(User.class.getClassLoader());
        this.f = in.readString();
        this.g = in.readByte() != 0;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.a);
        dest.writeString(this.c);
        dest.writeLong(this.d);
        dest.writeParcelable((Parcelable)this.e, flags);
        dest.writeString(this.f);
        dest.writeByte((byte)(this.g ? 1 : 0));
    }

    public String getId() {
        return this.a;
    }

    public long getCreatedDate() {
        return this.d;
    }

    public String getText() {
        return this.c;
    }

    public RawData getRawData() {
        return new RawData.Builder().a(this.c).build();
    }

    public User getCreator() {
        return this.e;
    }

    public boolean isSticker() {
        return this.g;
    }

    public String getStickerUrl() {
        return this.f;
    }

    static Message a(JSONObject jSONObject, SimpleArrayMap<String, String> simpleArrayMap) {
        Message message = null;
        Moshi moshi = new Moshi.Builder().build();
        JsonAdapter jsonAdapter = moshi.adapter(MessagingEndpoint.k.class);
        try {
            MessagingEndpoint.k k2 = (MessagingEndpoint.k)jsonAdapter.fromJson(jSONObject.toString());
            message = new Builder(k2, simpleArrayMap).build();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return message;
    }

    @Override
    public int length() {
        if (this.c == null) {
            return 0;
        }
        return this.c.length();
    }

    @Override
    public char charAt(int index) {
        if (this.c == null) {
            return '\u0000';
        }
        return this.c.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (this.c == null) {
            return "";
        }
        return this.c.subSequence(start, end);
    }

    public boolean equals(Object obj) {
        if (this.getId() == null || !(obj instanceof Message)) {
            return false;
        }
        return this.getId().equals(((Message)obj).getId());
    }

    public static class Builder {
        private String a;
        private String b;
        private String c = "";
        private long d;
        private User e;
        private SimpleArrayMap<String, String> f;

        public Builder(@NonNull String id) {
            this.a = id;
        }

        public Builder buildCreator(User creator) {
            this.e = creator;
            return this;
        }

        public Builder buildText(String text) {
            if (null != text) {
                this.c = text;
            }
            return this;
        }

        public Builder buildCreatedDate(long createdDate) {
            this.d = createdDate;
            return this;
        }

        public Message build() {
            return new Message(this);
        }

        Builder(MessagingEndpoint.k response, c.a dateParser) {
            long l2 = dateParser.a(response.createdDate);
            this.a = response.id;
            String string = null;
            if (response.text != null) {
                string = response.text;
            } else if (response.value instanceof Map) {
                string = new Moshi.Builder().build().adapter(Map.class).toJson((Object)((Map)response.value));
            } else if (response.value instanceof List) {
                string = new Moshi.Builder().build().adapter(List.class).toJson((Object)((List)response.value));
            }
            this.a(response.status).buildCreatedDate(l2).buildText(string).buildCreator(new User.a(response.creator).a());
        }

        Builder(MessagingEndpoint.k response) {
            this(response, io.straas.android.sdk.messaging.c.a());
        }

        Builder(MessagingEndpoint.k response, SimpleArrayMap<String, String> sticker) {
            this(response);
            this.a(sticker);
        }

        Builder a(SimpleArrayMap<String, String> simpleArrayMap) {
            this.f = simpleArrayMap;
            return this;
        }

        Builder a(String string) {
            if (TextUtils.isEmpty((CharSequence)string)) {
                this.b = "UNKNOWN";
                return this;
            }
            switch (string) {
                case "ACTIVE": 
                case "DELETED": {
                    this.b = string;
                }
            }
            this.b = "UNKNOWN";
            return this;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface MessageStatus {
    }
}

