/*
 * Decompiled with CFR 0.152.
 */
package io.straas.android.sdk.messaging;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.preference.PreferenceManager;
import android.support.annotation.NonNull;
import android.support.v4.util.SimpleArrayMap;
import android.text.TextUtils;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.ikala.android.httptask.CallManager;
import com.ikala.android.httptask.iKalaHttpUtils;
import io.straas.android.sdk.base.credential.Credential;
import io.straas.android.sdk.base.identity.Identity;
import io.straas.android.sdk.base.internal.Utils;
import io.straas.android.sdk.messaging.Message;
import io.straas.android.sdk.messaging.MessagingException;
import io.straas.android.sdk.messaging.c;
import io.straas.android.sdk.messaging.http.ArchivedMessagesEndpoint;
import io.straas.android.sdk.messaging.http.MessagingEndpoint;
import io.straas.android.sdk.messaging.http.a.a;
import io.straas.android.sdk.messaging.message.ArchivedMessagesMeta;
import java.io.IOException;
import java.util.regex.Pattern;
import okhttp3.Interceptor;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.moshi.MoshiConverterFactory;

public class ArchivedMessagesManager {
    private b a;
    private static final Pattern b = Pattern.compile("[A-Za-z0-9_-]+");

    public static Task<ArchivedMessagesManager> initialize(Identity identity) {
        return Credential.validate().continueWith((Continuation)new a(identity));
    }

    ArchivedMessagesManager(Identity identity, String restfulHost) {
        HandlerThread handlerThread = new HandlerThread("ArchivedMessagesManager");
        handlerThread.start();
        this.a = new b(handlerThread.getLooper(), identity, restfulHost);
    }

    public Task<ArchivedMessagesMeta> getArchivedMessagesMeta(String chatroomName, String archiveId) {
        if (TextUtils.isEmpty((CharSequence)chatroomName) || TextUtils.isEmpty((CharSequence)archiveId)) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalArgumentException("ChatroomName and archiveId shouldn't be null.")));
        }
        if (!b.matcher(archiveId).matches()) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalArgumentException("Wrong archiveId.")));
        }
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        android.os.Message message = this.a.obtainMessage();
        message.what = 0;
        message.obj = taskCompletionSource;
        Bundle bundle = new Bundle();
        bundle.putString("CHATROOM_NAME", chatroomName);
        bundle.putString("ARCHIVE_ID", archiveId);
        message.setData(bundle);
        this.a.sendMessage(message);
        return taskCompletionSource.getTask();
    }

    public Task<Message[]> getArchivedMessages(String chatroomName, String archiveId, long startTime, long endTime) {
        if (TextUtils.isEmpty((CharSequence)chatroomName) || TextUtils.isEmpty((CharSequence)archiveId)) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalArgumentException("ChatroomName and archiveId shouldn't be null.")));
        }
        if (!b.matcher(archiveId).matches()) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalArgumentException("Wrong archive id.")));
        }
        if (startTime > endTime || startTime == 0L ^ endTime == 0L) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalArgumentException("Wrong oldestDate and latestDate.")));
        }
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        android.os.Message message = this.a.obtainMessage();
        message.what = 1;
        message.obj = taskCompletionSource;
        Bundle bundle = new Bundle();
        bundle.putString("CHATROOM_NAME", chatroomName);
        bundle.putString("ARCHIVE_ID", archiveId);
        bundle.putLong("START_TIME", startTime);
        bundle.putLong("END_TIME", endTime);
        message.setData(bundle);
        this.a.sendMessage(message);
        return taskCompletionSource.getTask();
    }

    private static class a
    implements Continuation<Void, ArchivedMessagesManager> {
        private Identity a;

        private a(Identity identity) {
            this.a = identity;
        }

        public ArchivedMessagesManager a(@NonNull Task<Void> task) throws Exception {
            if (task.isSuccessful()) {
                return new ArchivedMessagesManager(this.a, "https://mgr.straas.net");
            }
            throw task.getException();
        }

        public /* synthetic */ Object then(@NonNull Task task) throws Exception {
            return this.a((Task<Void>)task);
        }
    }

    private static class b
    extends Handler {
        private MessagingEndpoint a;
        private String b;
        private SharedPreferences c;
        private final SimpleArrayMap<String, String> d = new SimpleArrayMap();
        private final SimpleArrayMap<String, ArchivedMessagesEndpoint> e = new SimpleArrayMap();
        private final SimpleArrayMap<String, SimpleArrayMap<String, ArchivedMessagesEndpoint.a>> f = new SimpleArrayMap();
        private a.a g = new a.a(){

            @Override
            public void a(String string) {
                b.this.b = string;
                if (b.this.c != null) {
                    b.this.c.edit().putString("KEY_API_TOKEN", string).apply();
                }
            }
        };

        private b(Looper looper, Identity identity, String string) {
            super(looper);
            this.c = PreferenceManager.getDefaultSharedPreferences((Context)Credential.getContext());
            this.a();
            this.a = this.a(identity, string);
        }

        public void handleMessage(android.os.Message msg) {
            super.handleMessage(msg);
            Bundle bundle = msg.getData();
            switch (msg.what) {
                case 0: {
                    this.a((TaskCompletionSource<ArchivedMessagesMeta>)((TaskCompletionSource)msg.obj), bundle.getString("CHATROOM_NAME"), bundle.getString("ARCHIVE_ID"));
                    break;
                }
                case 1: {
                    this.a((TaskCompletionSource<Message[]>)((TaskCompletionSource)msg.obj), bundle.getString("CHATROOM_NAME"), bundle.getString("ARCHIVE_ID"), bundle.getLong("START_TIME"), bundle.getLong("END_TIME"));
                }
            }
        }

        private void a(String string) {
            String string2 = (String)this.d.get((Object)string);
            if (TextUtils.isEmpty((CharSequence)string2)) {
                return;
            }
            Call<MessagingEndpoint.c> call = this.a.addUsersToChat(this.b, new MessagingEndpoint.b(string2, null, "Guest"));
            call.enqueue((Callback)new CallManager.Callback<MessagingEndpoint.c>(null, call, null){

                public void onResponse(Call<MessagingEndpoint.c> call, Response<MessagingEndpoint.c> response) {
                    super.onResponse(call, response);
                }

                public void onFailure(Call<MessagingEndpoint.c> call, Throwable t) {
                    super.onFailure(call, t);
                }
            });
        }

        private void a(TaskCompletionSource<ArchivedMessagesMeta> taskCompletionSource, String string, String string2) {
            try {
                ArchivedMessagesEndpoint.a a2 = this.a(string, string2);
                this.a(string);
                taskCompletionSource.setResult((Object)a2.toArchivedMessagesMeta());
            }
            catch (Exception exception) {
                taskCompletionSource.setException(exception);
            }
        }

        private ArchivedMessagesEndpoint.a a(String string, String string2) throws Exception {
            ArchivedMessagesEndpoint archivedMessagesEndpoint;
            if (this.f.containsKey((Object)string) && (archivedMessagesEndpoint = (SimpleArrayMap)this.f.get((Object)string)).containsKey(string2)) {
                return (ArchivedMessagesEndpoint.a)archivedMessagesEndpoint.get(string2);
            }
            archivedMessagesEndpoint = this.b(string);
            Call<ArchivedMessagesEndpoint.a> call = archivedMessagesEndpoint.getMeta(string2);
            try {
                Response response = call.execute();
                if (response.isSuccessful()) {
                    SimpleArrayMap simpleArrayMap;
                    if (this.f.containsKey((Object)string)) {
                        simpleArrayMap = (SimpleArrayMap)this.f.get((Object)string);
                    } else {
                        simpleArrayMap = new SimpleArrayMap();
                        this.f.put((Object)string, (Object)simpleArrayMap);
                    }
                    simpleArrayMap.put((Object)string2, response.body());
                    return (ArchivedMessagesEndpoint.a)response.body();
                }
                if (response.code() == 404) {
                    throw new MessagingException.NotFoundException();
                }
                throw io.straas.android.sdk.messaging.c.a(response);
            }
            catch (IOException iOException) {
                throw io.straas.android.sdk.messaging.c.a(call, iOException);
            }
        }

        private void a(final TaskCompletionSource<Message[]> taskCompletionSource, String string, String string2, final long l2, final long l3) {
            try {
                final boolean bl = l2 == 0L && l3 == 0L;
                String string3 = bl ? this.b(string, string2) : this.a(string, string2, l2);
                this.a(string);
                if (TextUtils.isEmpty((CharSequence)string3)) {
                    taskCompletionSource.setResult((Object)new Message[0]);
                    return;
                }
                this.a(string, string2, string3).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<Message[]>(){

                    public void a(Message[] messageArray) {
                        if (bl) {
                            taskCompletionSource.setResult((Object)messageArray);
                            return;
                        }
                        int n2 = b.this.a(messageArray, l2, false);
                        int n3 = b.this.a(messageArray, l3, true);
                        int n4 = n3 - n2 + 1;
                        if (n4 < 0) {
                            taskCompletionSource.setException((Exception)new MessagingException.InternalException());
                            return;
                        }
                        Message[] messageArray2 = new Message[n4];
                        System.arraycopy(messageArray, n2, messageArray2, 0, messageArray2.length);
                        taskCompletionSource.setResult((Object)messageArray2);
                    }

                    public /* synthetic */ void onSuccess(Object object) {
                        this.a((Message[])object);
                    }
                }).addOnFailureListener(new OnFailureListener(){

                    public void onFailure(@NonNull Exception e2) {
                        taskCompletionSource.setException(e2);
                    }
                });
            }
            catch (Exception exception) {
                taskCompletionSource.setException(exception);
            }
        }

        private String a(String string, String string2, long l2) throws Exception {
            ArchivedMessagesEndpoint.a a2 = this.a(string, string2);
            for (ArchivedMessagesEndpoint.a.a a3 : a2.files) {
                if (l2 > a3.end) continue;
                return a3.id;
            }
            return null;
        }

        private String b(String string, String string2) throws Exception {
            ArchivedMessagesEndpoint.a a2 = this.a(string, string2);
            if (a2.files.length > 0) {
                return a2.files[0].id;
            }
            return null;
        }

        private Task<Message[]> a(String string, String string2, String string3) {
            ArchivedMessagesEndpoint archivedMessagesEndpoint;
            final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
            try {
                archivedMessagesEndpoint = this.b(string);
            }
            catch (Exception exception) {
                return Tasks.forException((Exception)exception);
            }
            Call<MessagingEndpoint.k[]> call = archivedMessagesEndpoint.getMessages(string2, string3);
            call.enqueue((Callback)new CallManager.Callback<MessagingEndpoint.k[]>(null, call, null){

                public void onResponse(Call<MessagingEndpoint.k[]> call, Response<MessagingEndpoint.k[]> response) {
                    super.onResponse(call, response);
                    if (response.isSuccessful()) {
                        int n2 = ((MessagingEndpoint.k[])response.body()).length;
                        Message[] messageArray = new Message[n2];
                        for (int i2 = 0; i2 < n2; ++i2) {
                            Message message;
                            messageArray[i2] = message = new Message.Builder(((MessagingEndpoint.k[])response.body())[i2]).build();
                        }
                        taskCompletionSource.setResult((Object)messageArray);
                    } else {
                        taskCompletionSource.setException(io.straas.android.sdk.messaging.c.a(response));
                    }
                }

                public void onFailure(Call<MessagingEndpoint.k[]> call, Throwable t) {
                    super.onFailure(call, t);
                    taskCompletionSource.setException(io.straas.android.sdk.messaging.c.a(call, t));
                }
            });
            return taskCompletionSource.getTask();
        }

        private int a(Message[] messageArray, long l2, boolean bl) {
            int n2;
            int n3;
            int n4 = 0;
            int n5 = messageArray.length - 1;
            while (n5 - n4 > 1) {
                n3 = this.a(messageArray, n4, n5, l2, bl);
                if (n3 != -1) {
                    return n3;
                }
                n2 = (n4 + n5) / 2;
                if (l2 < messageArray[n2].getCreatedDate()) {
                    n5 = n2;
                    continue;
                }
                n4 = n2;
            }
            int n6 = n2 = bl ? n5 : n4;
            while (bl ? n2 >= n4 : n2 <= n5) {
                n3 = this.a(messageArray, n2, n2, l2, bl);
                if (n3 != -1) {
                    return n3;
                }
                n2 += bl ? -1 : 1;
            }
            return -1;
        }

        private int a(Message[] messageArray, int n2, int n3, long l2, boolean bl) {
            if (bl) {
                if (messageArray[n3].getCreatedDate() <= l2) {
                    return n3;
                }
            } else if (l2 <= messageArray[n2].getCreatedDate()) {
                return n2;
            }
            return -1;
        }

        private ArchivedMessagesEndpoint b(String string) throws Exception {
            if (this.e.containsKey((Object)string)) {
                return (ArchivedMessagesEndpoint)this.e.get((Object)string);
            }
            Call<MessagingEndpoint.h> call = this.a.getChatProfileByChannel(this.b, string, Credential.getAccountId());
            try {
                Response response = call.execute();
                if (response.isSuccessful()) {
                    ArchivedMessagesEndpoint archivedMessagesEndpoint = this.c(((MessagingEndpoint.h)response.body()).arcMsgURL);
                    this.d.put((Object)string, (Object)((MessagingEndpoint.h)response.body()).id);
                    this.e.put((Object)string, (Object)archivedMessagesEndpoint);
                    return archivedMessagesEndpoint;
                }
                throw io.straas.android.sdk.messaging.c.a(response);
            }
            catch (IOException iOException) {
                throw io.straas.android.sdk.messaging.c.a(call, iOException);
            }
        }

        private MessagingEndpoint a(Identity identity, String string) {
            return (MessagingEndpoint)Utils.createMemberRetrofit((String)string, (Identity)identity, (Interceptor[])new Interceptor[]{new io.straas.android.sdk.messaging.http.a.a(string, this.g)}).create(MessagingEndpoint.class);
        }

        private ArchivedMessagesEndpoint c(String string) {
            if (!string.endsWith("/")) {
                string = string + "/";
            }
            return (ArchivedMessagesEndpoint)new Retrofit.Builder().baseUrl(string).addConverterFactory((Converter.Factory)MoshiConverterFactory.create()).client(iKalaHttpUtils.getOkHttpClient()).build().create(ArchivedMessagesEndpoint.class);
        }

        private void a() {
            if (!TextUtils.isEmpty((CharSequence)this.b)) {
                return;
            }
            String string = null;
            if (this.c != null) {
                string = this.c.getString("KEY_API_TOKEN", null);
            }
            this.b = !TextUtils.isEmpty(string) ? string : "unknownApiToken";
        }
    }
}

