/*
 * Decompiled with CFR 0.152.
 */
package io.straas.android.sdk.messaging;

import java.io.IOException;
import java.security.GeneralSecurityException;

public interface MessagingException {

    public static class NotFoundException
    extends Exception {
        public NotFoundException() {
        }

        public NotFoundException(String message) {
            super(message);
        }
    }

    public static class UserNotFoundException
    extends NotFoundException {
        public UserNotFoundException() {
        }

        public UserNotFoundException(String message) {
            super(message);
        }
    }

    public static class RequestRejectedException
    extends Exception {
        public RequestRejectedException(Throwable cause) {
            super(cause);
        }

        public RequestRejectedException(String message) {
            super(message);
        }
    }

    public static class ServerException
    extends Exception {
        private int mStatusCode;

        public int getStatusCode() {
            return this.mStatusCode;
        }

        public ServerException(int statusCode) {
            super("HTTP Status Code: " + Integer.toString(statusCode));
            this.mStatusCode = statusCode;
        }

        public ServerException(Throwable cause) {
            super(cause);
        }

        public ServerException() {
        }
    }

    public static class ChatroomNameNotFoundException
    extends NotFoundException {
        public ChatroomNameNotFoundException() {
        }

        public ChatroomNameNotFoundException(String message) {
            super(message);
        }
    }

    public static class PermissionException
    extends UnsupportedOperationException {
        public PermissionException() {
        }

        public PermissionException(String message) {
            super(message);
        }
    }

    public static class UnauthorizedException
    extends GeneralSecurityException {
    }

    public static class InternalException
    extends Exception {
        public InternalException() {
        }

        public InternalException(Throwable cause) {
            super(cause);
        }

        public InternalException(String message) {
            super(message);
        }
    }

    public static class NetworkException
    extends IOException {
        public NetworkException(Throwable cause) {
            super(cause);
        }
    }
}

