/*
 * Decompiled with CFR 0.152.
 */
package io.straas.android.sdk.messaging;

import java.io.IOException;
import java.security.GeneralSecurityException;

public interface MessagingException {

    public static class RequestRejectedException
    extends Exception {
        public RequestRejectedException(Throwable cause) {
            super(cause);
        }
    }

    public static class ServerException
    extends Exception {
        public ServerException(int statusCode) {
            super("HTTP Status Code: " + Integer.toString(statusCode));
        }

        public ServerException(Throwable cause) {
            super(cause);
        }

        public ServerException() {
        }
    }

    public static class ChatroomNameNotFoundException
    extends RuntimeException {
        public ChatroomNameNotFoundException(String chatroomName) {
            super(chatroomName.replaceAll("d?p?#", ""));
        }
    }

    public static class PermissionException
    extends UnsupportedOperationException {
        public PermissionException(String s) {
            super(s);
        }
    }

    public static class UnauthorizedException
    extends GeneralSecurityException {
    }

    public static class InternalException
    extends Exception {
        public InternalException() {
        }

        public InternalException(Throwable cause) {
            super(cause);
        }

        public InternalException(String message) {
            super(message);
        }
    }

    public static class NetworkException
    extends IOException {
        public NetworkException(Throwable cause) {
            super(cause);
        }
    }
}

