/*
 * Decompiled with CFR 0.152.
 */
package io.straas.android.sdk.messaging;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.CountDownTimer;
import android.os.Handler;
import android.preference.PreferenceManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.SimpleArrayMap;
import android.text.TextUtils;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.ikala.android.controller.Retriable;
import com.ikala.android.controller.RetryDelayController;
import com.ikala.android.httptask.CallManager;
import com.ikala.android.httptask.error.HttpTaskError;
import com.ikala.android.utils.iKalaJSONUtil;
import com.ikala.android.utils.iKalaUtils;
import com.squareup.moshi.JsonDataException;
import com.squareup.moshi.Moshi;
import io.socket.client.IO;
import io.socket.client.Socket;
import io.socket.client.SocketIOException;
import io.socket.emitter.Emitter;
import io.straas.android.sdk.base.credential.Credential;
import io.straas.android.sdk.base.identity.Identity;
import io.straas.android.sdk.base.internal.Configuration;
import io.straas.android.sdk.base.internal.Utils;
import io.straas.android.sdk.messaging.ChatMode;
import io.straas.android.sdk.messaging.ChatroomInfo;
import io.straas.android.sdk.messaging.ChatroomManager;
import io.straas.android.sdk.messaging.ChatroomState;
import io.straas.android.sdk.messaging.Message;
import io.straas.android.sdk.messaging.MessagingException;
import io.straas.android.sdk.messaging.Role;
import io.straas.android.sdk.messaging.Sticker;
import io.straas.android.sdk.messaging.User;
import io.straas.android.sdk.messaging.a.a;
import io.straas.android.sdk.messaging.a.a.a;
import io.straas.android.sdk.messaging.interfaces.EventListener;
import io.straas.android.sdk.messaging.message.MessageRequest;
import io.straas.android.sdk.messaging.user.UserType;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLContext;
import okhttp3.Interceptor;
import okhttp3.ResponseBody;
import org.json.JSONArray;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

final class a {
    private static final String[] a = new String[]{"websocket"};
    private ChatroomState b = ChatroomState.IDLE;
    private int c;
    private String d;
    private Identity e;
    private boolean f;
    private List<EventListener> g;
    private int h;
    private SimpleArrayMap<String, String> i;
    private List<Sticker> j;
    private String k;
    private String l;
    private Integer m;
    private User n;
    private boolean o;
    private io.straas.android.sdk.messaging.a.a p;
    private final CallManager q = new CallManager();
    private RetryDelayController r;
    private String s;
    private SharedPreferences t;
    private Handler u = new Handler();
    private c v;
    private TaskCompletionSource<Void> w;
    private io.straas.android.sdk.messaging.user.a x;
    private ChatMode y = ChatMode.ALL;
    private a.a$a z = new a.a$a(){

        @Override
        public void a(String string) {
            a.this.s = string;
            if (a.this.t != null) {
                a.this.t.edit().putString("KEY_API_TOKEN", string).apply();
            }
        }
    };
    private CountDownTimer A = new CountDownTimer(5000L, 5000L){

        public void onTick(long l2) {
        }

        public void onFinish() {
            a.this.a(new MessagingException.InternalException("timeout"));
        }
    };

    a(Context context) {
        this.j();
        this.t = PreferenceManager.getDefaultSharedPreferences((Context)context);
    }

    private void j() {
        this.r = new RetryDelayController(new Retriable(){

            public void retry() {
                a.this.p();
            }
        });
        this.r.setMaxCount(7);
        this.r.enableExponentialBackoff(true);
        this.r.setBaseRetryInterval(500L);
    }

    private io.straas.android.sdk.messaging.a.a b(Identity identity) {
        return (io.straas.android.sdk.messaging.a.a)Utils.createMemberRetrofit((String)"https://mgr.straas.net", (Identity)identity, (Interceptor[])new Interceptor[]{new io.straas.android.sdk.messaging.a.a.a("https://mgr.straas.net", this.z)}).create(io.straas.android.sdk.messaging.a.a.class);
    }

    Task<Void> a(@NonNull String string, @NonNull Identity identity) {
        MessagingException.RequestRejectedException requestRejectedException = null;
        if (this.b != ChatroomState.IDLE) {
            requestRejectedException = new MessagingException.RequestRejectedException(new IllegalStateException("State must be IDLE."));
        }
        if (TextUtils.isEmpty((CharSequence)string) || identity == null) {
            requestRejectedException = new MessagingException.RequestRejectedException(new IllegalArgumentException("Check chatroom name or Identity."));
        }
        if (requestRejectedException != null) {
            return Tasks.forException((Exception)requestRejectedException);
        }
        this.w = new TaskCompletionSource();
        this.b = ChatroomState.CONNECTING;
        this.e = identity;
        this.d = string;
        this.f = string.startsWith("p#");
        this.p = this.b(identity);
        this.x = new io.straas.android.sdk.messaging.user.a(this.p);
        this.r.stop();
        this.o = false;
        this.l();
        return this.w.getTask();
    }

    boolean a(Identity identity) {
        if (this.b.equals((Object)ChatroomState.CONNECTED)) {
            this.e = identity;
            this.p = this.b(identity);
            return true;
        }
        return false;
    }

    private void k() {
        if (!TextUtils.isEmpty((CharSequence)this.s)) {
            return;
        }
        String string = null;
        if (this.t != null) {
            string = this.t.getString("KEY_API_TOKEN", null);
        }
        this.s = !TextUtils.isEmpty(string) ? string : "unknownApiToken";
    }

    private void a(int n2) {
        switch (n2) {
            case 0: {
                this.m();
                break;
            }
            case 1: {
                this.n();
                break;
            }
            case 2: {
                this.o();
            }
        }
    }

    private void l() {
        this.b = ChatroomState.CONNECTING;
        this.k();
        this.a(0);
    }

    private void m() {
        final String string = Credential.getAccountId();
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.b(new MessagingException.InternalException("check your sdk account_id"));
            this.i();
        }
        Call<a$f> call = this.p.a(this.s, this.d, string);
        call.enqueue((Callback)new a<a$f>(this.q, call, null){

            @Override
            public void onResponse(Call<a$f> call, Response<a$f> response) {
                super.onResponse(call, response);
                if (!a.this.s()) {
                    return;
                }
                if (response.isSuccessful() && response.body() != null) {
                    a.this.k = ((a$f)response.body()).id;
                    a.this.c = ((a$f)response.body()).inputInterval;
                    a.this.y = ChatMode.a(((a$f)response.body()).chatWriteMode);
                    a.this.h = ((a$f)response.body()).guestCount + ((a$f)response.body()).memberCount;
                    a.this.i = ((a$f)response.body()).getStickerMap();
                    a.this.j = ((a$f)response.body()).getStickerSuite();
                    a.this.a(1);
                }
            }

            @Override
            protected void a(Exception exception) {
                if (exception instanceof MessagingException.ChatroomNameNotFoundException && a.this.f && !a.this.e.isGuest()) {
                    a.this.a(a.this.d, string);
                } else {
                    super.a(exception);
                }
            }
        });
    }

    private void a(String string, String string2) {
        Call<ResponseBody> call = this.p.a(this.s, new a$e(ChatroomInfo.a(string), string2));
        call.enqueue((Callback)new a<ResponseBody>(this.q, call, null){

            @Override
            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                super.onResponse(call, response);
                if (!a.this.s()) {
                    return;
                }
                if (response.isSuccessful()) {
                    a.this.a(0);
                }
            }
        });
    }

    private void n() {
        String string = this.e == Identity.GUEST ? "Guest" : null;
        Call<a$c> call = this.p.a(this.s, new a$b(this.k, this.l, string));
        call.enqueue((Callback)new a<a$c>(this.q, call, null){

            @Override
            public void onResponse(Call<a$c> call, Response<a$c> response) {
                super.onResponse(call, response);
                if (!a.this.s()) {
                    return;
                }
                if (response.isSuccessful() && response.body() != null) {
                    a$c$a a2 = ((a$c)response.body()).userMetas[0];
                    a.this.l = a2.userToken;
                    a.this.m = (Integer)a2.label;
                    a.this.n = new User.a(((a$c)response.body()).userModel).a();
                    a.this.a(((a$c)response.body()).socket);
                }
            }
        });
    }

    private void o() {
        this.r.stop();
        this.b = ChatroomState.CONNECTED;
        if (!this.o) {
            this.o = true;
            if (this.w != null) {
                this.w.trySetResult(null);
                this.w = null;
            }
            this.c(this.g);
        }
        this.x.a(this.s, this.l, this.k, this.h);
    }

    private void a(a$m m2) {
        Socket socket;
        IO.Options options = new IO.Options();
        options.reconnection = false;
        options.rememberUpgrade = true;
        options.forceNew = true;
        options.path = m2.path;
        options.query = (!TextUtils.isEmpty((CharSequence)m2.query) ? m2.query + "&" : "") + "userAgent=" + Configuration.USER_AGENT;
        options.transports = a;
        options.timeout = 30000L;
        try {
            options.sslContext = SSLContext.getDefault();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        try {
            socket = IO.socket((String)m2.host, (IO.Options)options);
        }
        catch (URISyntaxException uRISyntaxException) {
            this.a(new MessagingException.InternalException(uRISyntaxException.getMessage()));
            return;
        }
        this.v = new c(socket);
        this.a(this.v);
        this.b(this.v);
        socket.connect();
    }

    private void a(final c c2) {
        if (c2 == null) {
            return;
        }
        c2.a("connect", new Emitter.Listener(){

            public void call(Object ... args) {
                a.this.A.start();
                c2.a("subscribe", a.this.l, a.this.k);
            }
        });
        c2.a("connect_error", new Emitter.Listener(){

            public void call(Object ... args) {
                Object object = args.length > 0 ? args[0] : null;
                a.this.a(new MessagingException.NetworkException((Throwable)new SocketIOException("Connection error", (Throwable)(object instanceof Exception ? (Exception)object : null))));
            }
        });
        c2.a("disconnect", new Emitter.Listener(){

            public void call(Object ... args) {
                if (!a.this.s()) {
                    return;
                }
                Object object = args.length > 0 ? args[0] : null;
                String string = object instanceof String ? (String)object : null;
                a.this.a(new MessagingException.NetworkException((Throwable)new SocketIOException(string)));
            }
        });
    }

    private void b(c c2) {
        if (c2 == null) {
            return;
        }
        c2.a("subscribed", new Emitter.Listener(){

            public void call(Object ... args) {
                a.this.A.cancel();
                a.this.n.a("ACTIVE");
                a.this.h++;
                a.this.a(2);
            }
        });
        c2.a("message", new Emitter.Listener(){

            public void call(Object ... args) {
                if (args.length <= 0) {
                    return;
                }
                if (!(args[0] instanceof JSONObject)) {
                    return;
                }
                JSONObject jSONObject = (JSONObject)args[0];
                a.this.a(a.this.g, Message.a(jSONObject, (SimpleArrayMap<String, String>)a.this.i), 0L);
            }
        });
        c2.a("raw_data", new Emitter.Listener(){

            public void call(Object ... args) {
                if (args.length <= 0) {
                    return;
                }
                if (!(args[0] instanceof JSONObject)) {
                    return;
                }
                JSONObject jSONObject = (JSONObject)args[0];
                a.this.a((List<EventListener>)a.this.g, Message.a(jSONObject, null));
            }
        });
        c2.a("agg_data", new Emitter.Listener(){

            public void call(Object ... args) {
                if (args.length <= 0) {
                    return;
                }
                if (!(args[0] instanceof JSONObject)) {
                    return;
                }
                JSONObject jSONObject = (JSONObject)args[0];
                a.this.a(iKalaJSONUtil.getJSONArray((JSONObject)jSONObject, (String)"aggregated"));
            }
        });
        c2.a("message_remove", new Emitter.Listener(){

            public void call(Object ... args) {
                if (args == null || args.length <= 0) {
                    return;
                }
                if (!(args[0] instanceof String)) {
                    return;
                }
                String string = (String)args[0];
                a.this.a((List<EventListener>)a.this.g, string);
            }
        });
        c2.a("message_flush", new Emitter.Listener(){

            public void call(Object ... args) {
                a.this.e(a.this.g);
            }
        });
        c2.a("user_add", new Emitter.Listener(){

            public void call(Object ... args) {
                if (args == null || args.length <= 0) {
                    return;
                }
                if (!(args[0] instanceof JSONArray)) {
                    return;
                }
                JSONArray jSONArray = (JSONArray)args[0];
                int n2 = jSONArray.length();
                ArrayList<User> arrayList = new ArrayList<User>();
                for (int i2 = 0; i2 < n2; ++i2) {
                    JSONObject jSONObject = iKalaJSONUtil.getJSONObjectFromJSONArray((JSONArray)jSONArray, (int)i2);
                    if (jSONObject == null) continue;
                    User user = User.a(jSONObject);
                    if (a.this.m != null && a.this.m.intValue() == user.getLabel().intValue()) continue;
                    arrayList.add(user);
                    a.this.h++;
                }
                if (arrayList.size() != 0) {
                    User[] userArray = arrayList.toArray(new User[0]);
                    a.this.a((List<EventListener>)a.this.g, userArray);
                    a.this.a((List<EventListener>)a.this.g, a.this.h);
                    a.this.x.a(userArray);
                }
            }
        });
        c2.a("user_update", new Emitter.Listener(){

            public void call(Object ... args) {
                int n2 = 0;
                if (args == null || args.length <= 0) {
                    return;
                }
                if (!(args[0] instanceof JSONArray)) {
                    return;
                }
                JSONArray jSONArray = (JSONArray)args[0];
                n2 = jSONArray.length();
                ArrayList<User> arrayList = new ArrayList<User>();
                for (int i2 = 0; i2 < n2; ++i2) {
                    JSONObject jSONObject = (JSONObject)iKalaJSONUtil.getObjectFromJSONArray((JSONArray)jSONArray, (int)i2);
                    User user = User.a(jSONObject);
                    arrayList.add(user);
                    if (a.this.m == null || a.this.m.intValue() != user.getLabel().intValue()) continue;
                    a.this.n = user;
                }
                if (arrayList.size() != 0) {
                    User[] userArray = arrayList.toArray(arrayList.toArray(new User[0]));
                    a.this.b((List<EventListener>)a.this.g, userArray);
                    a.this.x.b(userArray);
                }
            }
        });
        c2.a("user_remove", new Emitter.Listener(){

            public void call(Object ... args) {
                if (args == null || args.length <= 0) {
                    return;
                }
                if (!(args[0] instanceof JSONArray)) {
                    return;
                }
                JSONArray jSONArray = (JSONArray)args[0];
                int n2 = jSONArray.length();
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                for (int i2 = 0; i2 < n2; ++i2) {
                    JSONObject jSONObject = (JSONObject)iKalaJSONUtil.getObjectFromJSONArray((JSONArray)jSONArray, (int)i2);
                    int n3 = iKalaJSONUtil.getJSONInt((JSONObject)jSONObject, (String)"label", (int)-1);
                    if (-1 == n3) continue;
                    String string = iKalaJSONUtil.getJSONString((JSONObject)jSONObject, (String)"status");
                    if (a.this.m != null && n3 == a.this.m) {
                        switch (string) {
                            case "DELETED": {
                                if (!a.this.s()) break;
                                break;
                            }
                        }
                    } else {
                        Object object = new User.a();
                        ((User.a)object).a(n3).d(string);
                        arrayList.add(n3);
                    }
                    a.this.h--;
                    a.this.h = a.this.h >= 1 ? a.this.h : 1;
                }
                if (arrayList.size() != 0) {
                    Integer[] integerArray = arrayList.toArray(new Integer[0]);
                    a.this.a((List<EventListener>)a.this.g, integerArray);
                    a.this.a((List<EventListener>)a.this.g, a.this.h);
                    a.this.x.a(integerArray);
                }
            }
        });
        c2.a("user_count", new Emitter.Listener(){

            public void call(Object ... args) {
                if (args == null || args.length <= 0) {
                    return;
                }
                if (!(args[0] instanceof JSONObject)) {
                    return;
                }
                JSONObject jSONObject = (JSONObject)args[0];
                a.this.h = iKalaJSONUtil.getJSONInt((JSONObject)jSONObject, (String)"guestCount") + iKalaJSONUtil.getJSONInt((JSONObject)jSONObject, (String)"memberCount");
                a.this.a((List<EventListener>)a.this.g, a.this.h);
                a.this.x.a(a.this.h);
            }
        });
        c2.a("error", new Emitter.Listener(){

            public void call(Object ... args) {
            }
        });
        c2.a("chat_write_mode", new Emitter.Listener(){

            public void call(Object ... args) {
                if (args == null || args.length <= 0) {
                    return;
                }
                if (!(args[0] instanceof JSONObject)) {
                    return;
                }
                JSONObject jSONObject = (JSONObject)args[0];
                String string = iKalaJSONUtil.getJSONString((JSONObject)jSONObject, (String)"chatWriteMode", (String)"ALL");
                a.this.y = ChatMode.a(string);
                a.this.a((List<EventListener>)a.this.g, a.this.f());
            }
        });
        c2.a("message_input_interval", new Emitter.Listener(){

            public void call(Object ... args) {
                if (args == null || args.length <= 0) {
                    return;
                }
                if (!(args[0] instanceof JSONObject)) {
                    return;
                }
                JSONObject jSONObject = (JSONObject)args[0];
                String string = iKalaJSONUtil.getJSONString((JSONObject)jSONObject, (String)"chatId");
                if (!string.equals(a.this.k)) {
                    return;
                }
                a.this.c = iKalaJSONUtil.getJSONInt((JSONObject)jSONObject, (String)"inputInterval");
                a.this.b((List<EventListener>)a.this.g, a.this.g());
            }
        });
    }

    boolean a(EventListener eventListener) {
        if (eventListener == null) {
            return false;
        }
        if (this.g == null) {
            this.g = new ArrayList<EventListener>();
        }
        return !this.g.contains(eventListener) && this.g.add(eventListener);
    }

    void a(EventListener ... eventListenerArray) {
        if (eventListenerArray == null) {
            return;
        }
        for (EventListener eventListener : eventListenerArray) {
            this.a(eventListener);
        }
    }

    boolean b(EventListener eventListener) {
        return eventListener != null && this.g != null && this.g.remove(eventListener);
    }

    void a() {
        if (this.g == null) {
            return;
        }
        this.g.clear();
    }

    private void c(final List<EventListener> list) {
        if (list == null) {
            return;
        }
        this.u.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onConnected();
                }
            }
        });
    }

    private void a(final List<EventListener> list, final Exception exception) {
        if (list == null) {
            return;
        }
        this.u.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onConnectFailed(exception);
                    eventListener.onConnectFailed(ChatroomManager.exceptionToMessagingError(exception));
                }
            }
        });
    }

    private void b(final List<EventListener> list, final Exception exception) {
        if (list == null) {
            return;
        }
        this.u.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onError(exception);
                    eventListener.onError(ChatroomManager.exceptionToMessagingError(exception));
                }
            }
        });
    }

    private void d(final List<EventListener> list) {
        if (list == null) {
            return;
        }
        this.u.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onDisconnected();
                }
            }
        });
    }

    private void a(final List<EventListener> list, final Message message, long l2) {
        if (list == null) {
            return;
        }
        this.u.postDelayed(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onMessageAdded(message);
                }
            }
        }, l2);
    }

    private void a(final List<EventListener> list, final String string) {
        if (list == null) {
            return;
        }
        this.u.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onMessageRemoved(string);
                }
            }
        });
    }

    private void e(final List<EventListener> list) {
        if (list == null) {
            return;
        }
        this.u.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onMessageFlushed();
                }
            }
        });
    }

    private void a(final List<EventListener> list, final User[] userArray) {
        if (list == null) {
            return;
        }
        this.u.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onUserJoined(userArray);
                }
            }
        });
    }

    private void b(final List<EventListener> list, final User[] userArray) {
        if (list == null) {
            return;
        }
        this.u.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onUserUpdated(userArray);
                }
            }
        });
    }

    private void a(final List<EventListener> list, final Integer[] integerArray) {
        if (list == null) {
            return;
        }
        this.u.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onUserLeft(integerArray);
                }
            }
        });
    }

    private void a(final List<EventListener> list, final int n2) {
        if (list == null) {
            return;
        }
        this.u.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.userCount(n2);
                }
            }
        });
    }

    private void a(final List<EventListener> list, final ChatMode chatMode) {
        if (list == null) {
            return;
        }
        this.u.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onChatWriteModeChanged(chatMode);
                }
            }
        });
    }

    private void b(final List<EventListener> list, final int n2) {
        if (list == null) {
            return;
        }
        this.u.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onInputIntervalChanged(n2);
                }
            }
        });
    }

    private void a(JSONArray jSONArray) {
        if (jSONArray == null || this.g == null) {
            return;
        }
        final SimpleArrayMap simpleArrayMap = new SimpleArrayMap(jSONArray.length());
        int n2 = jSONArray.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            JSONObject jSONObject = iKalaJSONUtil.getJSONObjectFromJSONArray((JSONArray)jSONArray, (int)i2);
            if (jSONObject == null || !jSONObject.has("key")) continue;
            String string = iKalaJSONUtil.getJSONString((JSONObject)jSONObject, (String)"key", (String)"", (boolean)false);
            int n3 = iKalaJSONUtil.getJSONInt((JSONObject)jSONObject, (String)"n", (int)0);
            if (TextUtils.isEmpty((CharSequence)string) || n3 == 0) continue;
            simpleArrayMap.put((Object)string, (Object)n3);
        }
        if (simpleArrayMap.size() == 0) {
            return;
        }
        this.u.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : a.this.g) {
                    eventListener.onAggregatedDataAdded((SimpleArrayMap<String, Integer>)simpleArrayMap);
                }
            }
        });
    }

    private void a(final List<EventListener> list, final Message message) {
        if (list == null) {
            return;
        }
        this.u.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onRawDataAdded(message);
                }
            }
        });
    }

    Task<Message[]> a(MessageRequest messageRequest) {
        if (this.b != ChatroomState.CONNECTED) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalStateException("State must be CONNECTED.")));
        }
        int n2 = messageRequest.getPerPage();
        int n3 = messageRequest.getPage();
        Long l2 = messageRequest.getOldestDate();
        Long l3 = messageRequest.getLatestDate();
        if (!this.a(n3, n2, 100)) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalArgumentException("Check page format is valid or not.")));
        }
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        int n4 = (n3 - 1) * n2;
        Call<a$g> call = this.p.a(this.s, this.l, this.k, Collections.singletonList("USER"), true, n4, n2, l2, l3);
        call.enqueue((Callback)new b<a$g>(this.q, call, taskCompletionSource){

            @Override
            public void onResponse(Call<a$g> call, Response<a$g> response) {
                super.onResponse(call, response);
                a$g g2 = (a$g)response.body();
                if (!response.isSuccessful() || g2 == null || g2.messages == null) {
                    taskCompletionSource.trySetException((Exception)new MessagingException.InternalException());
                    return;
                }
                int n2 = g2.messages.length;
                Message[] messageArray = new Message[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    Message message;
                    messageArray[i2] = message = new Message.Builder(g2.messages[i2], (SimpleArrayMap<String, String>)a.this.i).build();
                }
                taskCompletionSource.setResult((Object)messageArray);
            }
        });
        return taskCompletionSource.getTask();
    }

    Task<User[]> a(UserType userType) {
        if (this.b != ChatroomState.CONNECTED) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalStateException("State must be CONNECTED.")));
        }
        return this.x.a(userType);
    }

    Task<User[]> a(int n2, int n3) {
        if (this.b != ChatroomState.CONNECTED) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalStateException("State must be CONNECTED.")));
        }
        if (!this.a(n2, n3, 200)) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalArgumentException("Check page format is valid or not.")));
        }
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        int n4 = (n2 - 1) * n3;
        Call<a$h> call = this.p.a(this.s, this.l, this.k, Collections.singletonList("ACTIVE"), null, n3, n4);
        call.enqueue((Callback)new b<a$h>(this.q, call, taskCompletionSource){

            @Override
            public void onResponse(Call<a$h> call, Response<a$h> response) {
                super.onResponse(call, response);
                a$h h2 = (a$h)response.body();
                if (!response.isSuccessful() || h2 == null || h2.users == null) {
                    taskCompletionSource.trySetException((Exception)new MessagingException.InternalException());
                    return;
                }
                int n2 = h2.users.length;
                User[] userArray = new User[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    User user;
                    userArray[i2] = user = new User.a(h2.users[i2]).a();
                }
                taskCompletionSource.setResult((Object)userArray);
            }
        });
        return taskCompletionSource.getTask();
    }

    Task<ChatroomInfo> b() {
        if (this.b != ChatroomState.CONNECTED) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalStateException("State must be CONNECTED.")));
        }
        String string = Credential.getAccountId();
        if (TextUtils.isEmpty((CharSequence)string)) {
            MessagingException.InternalException internalException = new MessagingException.InternalException("check your sdk account_id");
            this.b(internalException);
            return Tasks.forException((Exception)internalException);
        }
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        Call<a$f> call = this.p.a(this.s, this.d, string);
        call.enqueue((Callback)new b<a$f>(this.q, call, taskCompletionSource){

            @Override
            public void onResponse(Call<a$f> call, Response<a$f> response) {
                super.onResponse(call, response);
                if (response.isSuccessful() && response.body() != null) {
                    taskCompletionSource.setResult((Object)((a$f)response.body()).toChatroomInfo());
                }
            }
        });
        return taskCompletionSource.getTask();
    }

    Task<Void> a(String string, Object object) {
        if (this.b != ChatroomState.CONNECTED) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalStateException("State must be CONNECTED.")));
        }
        if (string.equals("text") && object instanceof CharSequence) {
            if (TextUtils.isEmpty((CharSequence)((CharSequence)object))) {
                return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalArgumentException("Message is empty, say something please.")));
            }
            if (((CharSequence)object).length() > 300) {
                return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalArgumentException("Message should be within 300 characters.")));
            }
        }
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        Call<ResponseBody> call = this.p.a(this.s, new a$a(this.k, this.l, string, object));
        call.enqueue((Callback)new b<ResponseBody>(this.q, call, taskCompletionSource){

            @Override
            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                super.onResponse(call, response);
                if (response.isSuccessful()) {
                    taskCompletionSource.setResult(null);
                }
            }
        });
        return taskCompletionSource.getTask();
    }

    void a(Message message) {
        this.a(this.g, message, 100L);
    }

    Task<Void> a(final String string) {
        if (this.b != ChatroomState.CONNECTED) {
            return Tasks.forException((Exception)new IllegalStateException("State must be CONNECTED."));
        }
        if (this.e != Identity.GUEST) {
            return Tasks.forException((Exception)new IllegalStateException("Identity must be Identity.GUEST."));
        }
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        Call<ResponseBody> call = this.p.a(this.s, new a$o(this.k, this.l, Collections.singletonList(new a$i(this.m, string, null))));
        call.enqueue((Callback)new b<ResponseBody>(this.q, call, taskCompletionSource){

            @Override
            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                super.onResponse(call, response);
                if (response.isSuccessful()) {
                    a.this.n.setName(string);
                    taskCompletionSource.setResult(null);
                }
            }
        });
        return taskCompletionSource.getTask();
    }

    Task<Void> a(List<User> list) {
        boolean bl;
        User user2;
        Role role = this.n.getRole();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (User user2 : list) {
            arrayList.add(user2.getLabel());
        }
        boolean bl2 = bl = role == Role.MASTER || role == Role.GLOBAL_MANAGER || role == Role.LOCAL_MANAGER;
        if (this.b != ChatroomState.CONNECTED) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalStateException("State must be CONNECTED.")));
        }
        if (arrayList.size() == 0) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalArgumentException("Users are emptys")));
        }
        if (!bl) {
            return Tasks.forException((Exception)new MessagingException.PermissionException("User must be MASTER, GLOBAL_MANAGER or LOCAL_MANAGER."));
        }
        user2 = new TaskCompletionSource();
        Call<ResponseBody> call = this.p.a(this.s, new a$d(this.k, this.l, arrayList));
        call.enqueue((Callback)new b<ResponseBody>(this.q, call, (TaskCompletionSource)user2, (TaskCompletionSource)user2){
            final /* synthetic */ TaskCompletionSource b;
            {
                this.b = taskCompletionSource2;
                super(callManager, call, taskCompletionSource);
            }

            @Override
            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                super.onResponse(call, response);
                if (response.isSuccessful()) {
                    this.b.setResult(null);
                }
            }
        });
        return user2.getTask();
    }

    Task<Void> b(List<User> list) {
        boolean bl;
        User user2;
        Role role = this.n.getRole();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (User user2 : list) {
            arrayList.add(user2.getLabel());
        }
        boolean bl2 = bl = role == Role.MASTER || role == Role.GLOBAL_MANAGER || role == Role.LOCAL_MANAGER;
        if (this.b != ChatroomState.CONNECTED) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalStateException("State must be CONNECTED.")));
        }
        if (arrayList.size() == 0) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalArgumentException("Users are empties")));
        }
        if (!bl) {
            return Tasks.forException((Exception)new MessagingException.PermissionException("User must be MASTER, GLOBAL_MANAGER or LOCAL_MANAGER."));
        }
        user2 = new TaskCompletionSource();
        Call<ResponseBody> call = this.p.b(this.s, new a$d(this.k, this.l, arrayList));
        call.enqueue((Callback)new b<ResponseBody>(this.q, call, (TaskCompletionSource)user2, (TaskCompletionSource)user2){
            final /* synthetic */ TaskCompletionSource b;
            {
                this.b = taskCompletionSource2;
                super(callManager, call, taskCompletionSource);
            }

            @Override
            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                super.onResponse(call, response);
                if (response.isSuccessful()) {
                    this.b.setResult(null);
                }
            }
        });
        return user2.getTask();
    }

    Task<Void> b(Message message) {
        boolean bl;
        Role role = this.n.getRole();
        String string = message.getId();
        boolean bl2 = bl = role == Role.MASTER || role == Role.GLOBAL_MANAGER || role == Role.LOCAL_MANAGER;
        if (this.b != ChatroomState.CONNECTED) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalStateException("State must be CONNECTED.")));
        }
        if (string == null) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalArgumentException("Check message ID.")));
        }
        if (!bl) {
            return Tasks.forException((Exception)new MessagingException.PermissionException("User must be MASTER, GLOBAL_MANAGER or LOCAL_MANAGER."));
        }
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        Call<ResponseBody> call = this.p.a(this.s, this.l, this.k, string);
        call.enqueue((Callback)new b<ResponseBody>(this.q, call, taskCompletionSource){

            @Override
            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                super.onResponse(call, response);
                if (response.isSuccessful()) {
                    taskCompletionSource.setResult(null);
                }
            }
        });
        return taskCompletionSource.getTask();
    }

    List<Sticker> c() {
        return this.j;
    }

    User d() {
        if (this.b != ChatroomState.CONNECTED) {
            return null;
        }
        return this.n;
    }

    int e() {
        return this.h;
    }

    ChatMode f() {
        return this.y;
    }

    int g() {
        return this.c;
    }

    ChatroomState h() {
        return this.b;
    }

    Task<Void> i() {
        if (!this.s()) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalStateException()));
        }
        return this.a(false);
    }

    private void p() {
        this.a(true);
    }

    private Task<Void> a(boolean bl) {
        if (bl) {
            this.b = ChatroomState.CONNECTING;
            this.x.a();
        } else {
            this.b = ChatroomState.DISCONNECTING;
            this.r.stop();
            this.x.b();
        }
        this.q.cancelAllCalls();
        this.r();
        if (iKalaUtils.isEmptyString((CharSequence)this.l) || iKalaUtils.isEmptyString((CharSequence)this.k) || this.m == null) {
            if (bl) {
                this.l();
            }
        } else {
            this.b(bl);
            this.q();
        }
        if (!bl) {
            this.b = ChatroomState.IDLE;
            if (this.o) {
                this.d(this.g);
                return Tasks.forResult(null);
            }
        }
        return Tasks.forException((Exception)new Exception());
    }

    private void q() {
        this.k = null;
        this.l = null;
        this.m = null;
        this.n = null;
    }

    private synchronized void r() {
        if (this.v == null) {
            return;
        }
        this.v.a.off();
        this.v.a.disconnect();
    }

    private void b(final boolean bl) {
        Call<ResponseBody> call = this.p.a(this.s, this.l, this.k, Collections.singletonList(this.m));
        call.enqueue((Callback)new CallManager.Callback<ResponseBody>(this.q, call, null){

            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                super.onResponse(call, response);
                if (bl) {
                    a.this.l();
                }
            }

            public void onFailure(Call<ResponseBody> call, Throwable t) {
                super.onFailure(call, t);
                Exception exception = a.this.a(call, t);
                if (bl && !(exception instanceof InterruptedIOException)) {
                    a.this.l();
                }
            }
        });
    }

    private void a(Exception exception) {
        if (!this.s()) {
            this.b(exception);
            return;
        }
        if (!this.c(exception) || !this.r.retry()) {
            this.b(exception);
            this.i();
        }
    }

    private void b(Exception exception) {
        if (!this.o) {
            this.a(this.g, exception);
            if (this.w != null) {
                this.w.trySetException(exception);
            }
        } else if (!(exception instanceof InterruptedIOException)) {
            this.b(this.g, exception);
        }
    }

    private boolean c(Exception exception) {
        if (exception instanceof MessagingException.NetworkException || exception instanceof MessagingException.InternalException || exception instanceof MessagingException.ServerException) {
            return true;
        }
        if (exception instanceof MessagingException.UnauthorizedException || exception instanceof MessagingException.PermissionException || exception instanceof MessagingException.ChatroomNameNotFoundException || exception instanceof MessagingException.RequestRejectedException || exception instanceof InterruptedIOException) {
            return false;
        }
        return false;
    }

    private Exception a(Response response) {
        int n2 = response.code();
        a$l l2 = this.a(response.errorBody());
        if (l2 == null || l2.code == null) {
            return new MessagingException.InternalException("Unknown error");
        }
        switch (n2) {
            case 401: {
                if (!l2.code.equals("UnauthorizedError")) break;
                return new MessagingException.UnauthorizedException();
            }
            case 403: {
                if (!l2.code.equals("PermissionViolationError")) break;
                return new MessagingException.PermissionException(Integer.toString(n2));
            }
            case 404: {
                if (!l2.code.equals("EntityNotFoundError")) break;
                return new MessagingException.ChatroomNameNotFoundException(this.d);
            }
            case 409: {
                if (!l2.code.equals("DuplicateEntityError") && !l2.code.equals("InvalidRequestError")) break;
                return new MessagingException.InternalException(Integer.toString(n2));
            }
            case 500: 
            case 501: 
            case 502: 
            case 503: 
            case 504: 
            case 505: {
                return new MessagingException.ServerException(n2);
            }
            case 400: {
                return new MessagingException.InternalException(Integer.toString(n2));
            }
            default: {
                return new MessagingException.InternalException();
            }
        }
        return new MessagingException.InternalException();
    }

    private Exception a(Call call, Throwable throwable) {
        int n2 = HttpTaskError.getThrowableMappingId((Call)call, (Throwable)throwable);
        switch (n2) {
            case 6: {
                return new InterruptedIOException("canceled");
            }
        }
        return new MessagingException.NetworkException(throwable);
    }

    private boolean s() {
        return this.b == ChatroomState.CONNECTING || this.b == ChatroomState.CONNECTED;
    }

    private a$l a(ResponseBody responseBody) {
        a$l l2;
        Moshi moshi = new Moshi.Builder().build();
        try {
            l2 = (a$l)moshi.adapter(a$l.class).fromJson(responseBody.source());
        }
        catch (JsonDataException | IOException throwable) {
            throwable.printStackTrace();
            l2 = new a$l();
        }
        return l2;
    }

    private boolean a(int n2, int n3, int n4) {
        return n2 > 0 && n3 > 0 && n3 <= n4;
    }

    private static final class c {
        Socket a;

        c(Socket socket) {
            this.a = socket;
        }

        Emitter a(String string, Object ... objectArray) {
            return this.a.emit(string, objectArray);
        }

        Emitter a(String string, Emitter.Listener listener) {
            return this.a.on(string, listener);
        }
    }

    private class b<T>
    extends CallManager.Callback<T> {
        private int b;
        private final TaskCompletionSource c;

        b(@Nullable CallManager callManager, @Nullable Call call, TaskCompletionSource taskCompletionSource) {
            super(callManager, call, null);
            this.b = 0;
            this.c = taskCompletionSource;
        }

        public void onResponse(Call<T> call, Response<T> response) {
            super.onResponse(call, response);
            if (!response.isSuccessful()) {
                Exception exception = a.this.a(response);
                this.a(call, exception);
            }
        }

        public void onFailure(Call<T> call, Throwable t) {
            super.onFailure(call, t);
            Exception exception = a.this.a(call, t);
            this.a(call, exception);
        }

        private void a(final Call<T> call, Exception exception) {
            if (++this.b <= 3 && a.this.s() && a.this.c(exception)) {
                a.this.u.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        Call call2 = call.clone();
                        call2.enqueue((Callback)b.this);
                    }
                }, 1000L);
            } else if (this.c != null && !(exception instanceof InterruptedIOException)) {
                this.c.trySetException(exception);
            }
        }
    }

    private class a<T>
    extends CallManager.Callback<T> {
        a(@Nullable CallManager callManager, @Nullable Call call, @Nullable CallManager.OnHttpTaskLoadingCallback onHttpTaskLoadingCallback) {
            super(callManager, call, onHttpTaskLoadingCallback);
        }

        public void onResponse(Call<T> call, Response<T> response) {
            super.onResponse(call, response);
            if (!response.isSuccessful()) {
                Exception exception = a.this.a(response);
                this.a(exception);
            }
        }

        public void onFailure(Call<T> call, Throwable t) {
            super.onFailure(call, t);
            Exception exception = a.this.a(call, t);
            this.a(exception);
        }

        protected void a(Exception exception) {
            a.this.a(exception);
        }
    }
}

