/*
 * Decompiled with CFR 0.152.
 */
package io.straas.android.sdk.messaging;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.squareup.moshi.JsonReader;
import io.straas.android.sdk.base.credential.Credential;
import io.straas.android.sdk.base.credential.CredentialFailException;
import io.straas.android.sdk.base.credential.CredentialFailReason;
import io.straas.android.sdk.base.identity.Identity;
import io.straas.android.sdk.base.interfaces.OnResultListener;
import io.straas.android.sdk.messaging.ChatMode;
import io.straas.android.sdk.messaging.ChatroomInfo;
import io.straas.android.sdk.messaging.ChatroomState;
import io.straas.android.sdk.messaging.Message;
import io.straas.android.sdk.messaging.MessagingError;
import io.straas.android.sdk.messaging.MessagingException;
import io.straas.android.sdk.messaging.RawData;
import io.straas.android.sdk.messaging.Sticker;
import io.straas.android.sdk.messaging.User;
import io.straas.android.sdk.messaging.interfaces.EventListener;
import io.straas.android.sdk.messaging.message.MessageRequest;
import io.straas.android.sdk.messaging.user.UserType;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import okio.Buffer;
import okio.BufferedSource;

public class ChatroomManager {
    @Deprecated
    public static final int IS_PERSONAL_CHAT = 1;
    @Deprecated
    public static final int WITH_DATA_CHANNEL = 2;
    private io.straas.android.sdk.messaging.a a = new io.straas.android.sdk.messaging.a(Credential.getContext());

    public static void initialize(final OnResultListener<ChatroomManager, CredentialFailReason> callback) {
        ChatroomManager.initialize().addOnSuccessListener((OnSuccessListener)new OnSuccessListener<ChatroomManager>(){

            public void a(ChatroomManager chatroomManager) {
                if (callback == null) {
                    return;
                }
                callback.onSuccess((Object)chatroomManager);
            }

            public /* synthetic */ void onSuccess(Object object) {
                this.a((ChatroomManager)object);
            }
        }).addOnFailureListener(new OnFailureListener(){

            public void onFailure(@NonNull Exception e2) {
                if (callback == null) {
                    return;
                }
                if (e2 instanceof MessagingException.NetworkException) {
                    callback.onFailure((Object)CredentialFailReason.NETWORK_ERROR);
                } else if (e2 instanceof MessagingException.ServerException) {
                    callback.onFailure((Object)CredentialFailReason.SERVER_ERROR);
                } else if (e2 instanceof CredentialFailException.WrongInformationException) {
                    callback.onFailure((Object)CredentialFailReason.WRONG_INFORMATION);
                }
            }
        });
    }

    public static MessagingError exceptionToMessagingError(@NonNull Exception e2) {
        if (e2 instanceof MessagingException.RequestRejectedException) {
            return MessagingError.REQUEST_REJECTED;
        }
        if (e2 instanceof MessagingException.NetworkException) {
            return MessagingError.NETWORK_ERROR;
        }
        if (e2 instanceof MessagingException.InternalException) {
            return MessagingError.INTERNAL_ERROR;
        }
        if (e2 instanceof MessagingException.UnauthorizedException) {
            return MessagingError.UNAUTHORIZED_ERROR;
        }
        if (e2 instanceof MessagingException.PermissionException) {
            return MessagingError.PERMISSION_ERROR;
        }
        if (e2 instanceof MessagingException.ChatroomNameNotFoundException) {
            return MessagingError.UNKNOWN_CHATROOM;
        }
        if (e2 instanceof MessagingException.ServerException) {
            return MessagingError.SERVER_ERROR;
        }
        return MessagingError.INTERNAL_ERROR;
    }

    public static Task<ChatroomManager> initialize() {
        return Credential.validate().continueWith((Continuation)new a());
    }

    private ChatroomManager() {
    }

    @Deprecated
    public Task<Void> connect(@NonNull String chatroomName, @NonNull Identity identity, int flag) {
        return this.connect(chatroomName, identity, (flag & 1) != 0);
    }

    public Task<Void> connect(@NonNull String chatroomName, @NonNull Identity identity, boolean isPersonalChat) {
        return this.a.a(isPersonalChat ? "p#" + chatroomName : chatroomName, identity);
    }

    public boolean resetIdentity(Identity identity) {
        return this.a.a(identity);
    }

    @Deprecated
    public void getMessages(int page, int perPage, final @NonNull OnResultListener<Message[], MessagingError> listener) {
        this.getMessages(new MessageRequest.Builder().page(page).perPage(perPage).build()).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<Message[]>(){

            public void a(Message[] messageArray) {
                listener.onSuccess((Object)messageArray);
            }

            public /* synthetic */ void onSuccess(Object object) {
                this.a((Message[])object);
            }
        }).addOnFailureListener(ChatroomManager.a(listener));
    }

    public Task<Message[]> getMessages(MessageRequest request) {
        return this.a.a(request);
    }

    @Deprecated
    public void getUsers(int page, int perPage, final @NonNull OnResultListener<User[], MessagingError> listener) {
        this.getUsers(page, perPage).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<User[]>(){

            public void a(User[] userArray) {
                listener.onSuccess((Object)userArray);
            }

            public /* synthetic */ void onSuccess(Object object) {
                this.a((User[])object);
            }
        }).addOnFailureListener(ChatroomManager.a(listener));
    }

    @Deprecated
    public Task<User[]> getUsers(int page, int perPage) {
        return this.a.a(page, perPage);
    }

    public Task<User[]> getUsers(UserType userType) {
        return this.a.a(userType);
    }

    @Deprecated
    public void getChatroomInfo(final @NonNull OnResultListener<ChatroomInfo, MessagingError> listener) {
        this.getChatroomInfo().addOnSuccessListener((OnSuccessListener)new OnSuccessListener<ChatroomInfo>(){

            public void a(ChatroomInfo chatroomInfo) {
                listener.onSuccess((Object)chatroomInfo);
            }

            public /* synthetic */ void onSuccess(Object object) {
                this.a((ChatroomInfo)object);
            }
        }).addOnFailureListener(ChatroomManager.a(listener));
    }

    public Task<ChatroomInfo> getChatroomInfo() {
        return this.a.b();
    }

    @Deprecated
    public void updateNickname(String name, final OnResultListener<Void, MessagingError> listener) {
        this.updateNickname(name).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<Void>(){

            public void a(Void void_) {
                listener.onSuccess((Object)void_);
            }

            public /* synthetic */ void onSuccess(Object object) {
                this.a((Void)object);
            }
        }).addOnFailureListener(ChatroomManager.a(listener));
    }

    public Task<Void> updateNickname(String name) {
        return this.a.a(name);
    }

    @Deprecated
    public void blockUsers(List<User> users, final OnResultListener<Void, MessagingError> listener) {
        this.blockUsers(users).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<Void>(){

            public void a(Void void_) {
                listener.onSuccess((Object)void_);
            }

            public /* synthetic */ void onSuccess(Object object) {
                this.a((Void)object);
            }
        }).addOnFailureListener(ChatroomManager.a(listener));
    }

    public Task<Void> blockUsers(List<User> users) {
        return this.a.a(users);
    }

    @Deprecated
    public void reviveUsers(List<User> users, final OnResultListener<Void, MessagingError> listener) {
        this.reviveUsers(users).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<Void>(){

            public void a(Void void_) {
                listener.onSuccess((Object)void_);
            }

            public /* synthetic */ void onSuccess(Object object) {
                this.a((Void)object);
            }
        }).addOnFailureListener(ChatroomManager.a(listener));
    }

    public Task<Void> reviveUsers(List<User> users) {
        return this.a.b(users);
    }

    @Deprecated
    public void removeMessage(Message message, final OnResultListener<Void, MessagingError> listener) {
        this.removeMessage(message).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<Void>(){

            public void a(Void void_) {
                listener.onSuccess((Object)void_);
            }

            public /* synthetic */ void onSuccess(Object object) {
                this.a((Void)object);
            }
        }).addOnFailureListener(ChatroomManager.a(listener));
    }

    public Task<Void> removeMessage(Message message) {
        return this.a.b(message);
    }

    @Deprecated
    public void sendMessage(String message, final OnResultListener<Void, MessagingError> listener) {
        this.sendMessage(message).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<Void>(){

            public void a(Void void_) {
                listener.onSuccess((Object)void_);
            }

            public /* synthetic */ void onSuccess(Object object) {
                this.a((Void)object);
            }
        }).addOnFailureListener(ChatroomManager.a(listener));
    }

    public Task<Void> sendMessage(String message) {
        return this.a.a("text", (Object)message);
    }

    public Task<Void> sendAggregatedDataTypeMessage(String message) {
        if (TextUtils.isEmpty((CharSequence)message) || message.length() > 100) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalArgumentException("Aggregate data must be between 1~100 characters.")));
        }
        return this.a.a("aggregate", (Object)message);
    }

    public Task<Void> sendRawData(@NonNull RawData rawData) {
        if (rawData == null) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalArgumentException("Check your raw data.")));
        }
        try {
            return this.a.a("raw", JsonReader.of((BufferedSource)new Buffer().writeUtf8(rawData.getJsonText())).readJsonValue());
        }
        catch (IOException iOException) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(iOException));
        }
    }

    public void addFakeMessage(Message message) {
        this.a.a(message);
    }

    public User getCurrentUser() {
        return this.a.d();
    }

    public List<Sticker> getSticker() {
        return this.a.c();
    }

    public int getUserCount() {
        return this.a.e();
    }

    public ChatMode getChatMode() {
        return this.a.f();
    }

    public int getSendMessageInterval() {
        return this.a.g();
    }

    public ChatroomState getChatroomState() {
        return this.a.h();
    }

    public Task<Void> disconnect() {
        return this.a.i();
    }

    public boolean addEventListener(EventListener listener) {
        return this.a.a(listener);
    }

    public void addAllEventListener(EventListener ... listeners) {
        this.a.a(listeners);
    }

    public boolean removeEventListener(EventListener listener) {
        return this.a.b(listener);
    }

    public void removeAllEventListener() {
        this.a.a();
    }

    @NonNull
    private static <T> OnFailureListener a(final OnResultListener<T, MessagingError> onResultListener) {
        return new OnFailureListener(){

            public void onFailure(@NonNull Exception e2) {
                onResultListener.onFailure((Object)ChatroomManager.exceptionToMessagingError(e2));
            }
        };
    }

    private static class a
    implements Continuation<Void, ChatroomManager> {
        private a() {
        }

        public ChatroomManager a(@NonNull Task<Void> task) throws Exception {
            if (task.isSuccessful()) {
                return new ChatroomManager();
            }
            if (task.getException() != null) {
                throw task.getException();
            }
            return null;
        }

        public /* synthetic */ Object then(@NonNull Task task) throws Exception {
            return this.a((Task<Void>)task);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Deprecated
    public static @interface ConnectFlag {
    }
}

