/*
 * Decompiled with CFR 0.152.
 */
package io.straas.android.sdk.messaging;

import java.io.IOException;
import java.security.GeneralSecurityException;

public interface MessagingException {

    public static class RequestRejectedException
    extends Exception {
        public RequestRejectedException(Throwable cause) {
            super(cause);
        }
    }

    public static class ServerException
    extends Exception {
        ServerException(int responseCode) {
            super(Integer.toString(responseCode));
        }
    }

    public static class ChatroomNameNotFoundException
    extends RuntimeException {
        ChatroomNameNotFoundException(String chatroomName) {
            super(chatroomName.replaceAll("d?p?#", ""));
        }
    }

    public static class PermissionException
    extends UnsupportedOperationException {
        PermissionException(String s) {
            super(s);
        }
    }

    public static class UnauthorizedException
    extends GeneralSecurityException {
    }

    public static class InternalException
    extends Exception {
        InternalException() {
        }

        InternalException(String message) {
            super(message);
        }
    }

    public static class NetworkException
    extends IOException {
        NetworkException(Throwable cause) {
            super(cause);
        }
    }
}

