/*
 * Decompiled with CFR 0.152.
 */
package io.straas.android.sdk.messaging;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.v4.os.ParcelableCompat;
import android.support.v4.os.ParcelableCompatCreatorCallbacks;
import android.support.v4.util.SimpleArrayMap;
import com.ikala.android.utils.EnumUtils;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import io.straas.android.sdk.messaging.User;
import io.straas.android.sdk.messaging.a.a;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.json.JSONObject;

public final class Message
implements Parcelable,
CharSequence {
    private static final SimpleDateFormat a = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private String b;
    private String c;
    private MessageType d;
    private MessageStatus e;
    private String f;
    private long g;
    private User h;
    private String i;
    private boolean j;
    public static final Parcelable.Creator<Message> CREATOR;

    private Message(Builder builder) {
        this.b = builder.a;
        this.c = builder.b;
        this.d = builder.c;
        this.e = builder.d;
        this.f = builder.e;
        this.g = builder.f;
        this.h = builder.g;
        SimpleArrayMap simpleArrayMap = builder.h;
        if (simpleArrayMap != null && simpleArrayMap.containsKey((Object)this.f)) {
            this.j = true;
            this.i = (String)simpleArrayMap.get((Object)this.f);
        }
    }

    protected Message(Parcel in, ClassLoader loader) {
        this.b = in.readString();
        this.c = in.readString();
        this.f = in.readString();
        this.g = in.readLong();
        this.h = (User)in.readParcelable(User.class.getClassLoader());
        this.i = in.readString();
        this.j = in.readByte() != 0;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.b);
        dest.writeString(this.c);
        dest.writeString(this.f);
        dest.writeLong(this.g);
        dest.writeParcelable((Parcelable)this.h, flags);
        dest.writeString(this.i);
        dest.writeByte((byte)(this.j ? 1 : 0));
    }

    public String getId() {
        return this.b;
    }

    public long getCreatedDate() {
        return this.g;
    }

    public String getText() {
        return this.f;
    }

    public User getCreator() {
        return this.h;
    }

    public boolean isSticker() {
        return this.j;
    }

    public String getStickerUrl() {
        return this.i;
    }

    static Message a(JSONObject jSONObject, SimpleArrayMap<String, String> simpleArrayMap) {
        Message message = null;
        Moshi moshi = new Moshi.Builder().build();
        JsonAdapter jsonAdapter = moshi.adapter(a.j.class);
        try {
            a.j j2 = (a.j)jsonAdapter.fromJson(jSONObject.toString());
            message = new Builder(j2, simpleArrayMap).build();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return message;
    }

    @Override
    public int length() {
        if (this.f == null) {
            return 0;
        }
        return this.f.length();
    }

    @Override
    public char charAt(int index) {
        if (this.f == null) {
            return '\u0000';
        }
        return this.f.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (this.f == null) {
            return "";
        }
        return this.f.subSequence(start, end);
    }

    public boolean equals(Object obj) {
        if (this.getId() == null || !(obj instanceof Message)) {
            return false;
        }
        return this.getId().equals(((Message)obj).getId());
    }

    static {
        a.setTimeZone(TimeZone.getTimeZone("UTC"));
        CREATOR = ParcelableCompat.newCreator((ParcelableCompatCreatorCallbacks)new ParcelableCompatCreatorCallbacks<Message>(){

            public Message createFromParcel(Parcel in, ClassLoader loader) {
                return new Message(in, loader);
            }

            public Message[] newArray(int size) {
                return new Message[size];
            }
        });
    }

    public static class Builder {
        private String a;
        private String b;
        private MessageType c;
        private MessageStatus d;
        private String e = "";
        private long f;
        private User g;
        private SimpleArrayMap<String, String> h;

        public Builder(@NonNull String id) {
            this.a = id;
        }

        public Builder buildCreator(User creator) {
            this.g = creator;
            return this;
        }

        public Builder buildText(String text) {
            if (null != text) {
                this.e = text;
            }
            return this;
        }

        public Builder buildCreatedDate(long createdDate) {
            this.f = createdDate;
            return this;
        }

        public Message build() {
            return new Message(this);
        }

        Builder(a.j response, SimpleArrayMap<String, String> sticker) {
            long l2 = 0L;
            try {
                Date date = a.parse(response.createdDate);
                l2 = date.getTime();
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
            }
            this.a = response.id;
            this.a(response.category, response.type).a(response.status).buildCreatedDate(l2).buildText(response.text).buildCreator(new User.a(response.creator).a()).a(sticker);
        }

        Builder a(SimpleArrayMap<String, String> simpleArrayMap) {
            this.h = simpleArrayMap;
            return this;
        }

        Builder a(String string, String string2) {
            switch (this.b = string) {
                case "SYSTEM": {
                    this.c = (MessageType)EnumUtils.searchEnum(MessageType.class, (String)string2, (Enum)MessageType.e);
                    break;
                }
            }
            return this;
        }

        Builder a(String string) {
            this.d = (MessageStatus)EnumUtils.searchEnum(MessageStatus.class, (String)string, (Enum)MessageStatus.c);
            return this;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface MessageCategory {
    }

    static enum MessageStatus {
        a,
        b,
        c;

    }

    static enum MessageType {
        a,
        b,
        c,
        d,
        e;

    }
}

