/*
 * Decompiled with CFR 0.152.
 */
package io.straas.android.sdk.messaging;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.v4.os.ParcelableCompat;
import android.support.v4.os.ParcelableCompatCreatorCallbacks;
import android.text.TextUtils;
import com.squareup.moshi.JsonDataException;
import com.squareup.moshi.Moshi;
import java.io.IOException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class RawData
implements Parcelable {
    private final String a;
    public static final Parcelable.Creator<RawData> CREATOR = ParcelableCompat.newCreator((ParcelableCompatCreatorCallbacks)new ParcelableCompatCreatorCallbacks<RawData>(){

        public RawData createFromParcel(Parcel in, ClassLoader loader) {
            return new RawData(in, loader);
        }

        public RawData[] newArray(int size) {
            return new RawData[size];
        }
    });

    private RawData(@NonNull String jsonText) {
        this.a = jsonText;
    }

    @NonNull
    public String getJsonText() {
        return this.a;
    }

    public <T> T getJsonTextAsData(Class<T> type) throws IOException, JSONException {
        Moshi moshi = new Moshi.Builder().build();
        try {
            return (T)moshi.adapter(type).fromJson(this.a);
        }
        catch (JsonDataException jsonDataException) {
            throw new JSONException(jsonDataException.getMessage());
        }
    }

    protected RawData(Parcel in, ClassLoader loader) {
        this.a = in.readString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.a);
    }

    public static class Builder {
        private String a;

        public Builder setJsonText(@NonNull String jsonString) {
            try {
                Object object = new JSONTokener(jsonString).nextValue();
                if (object instanceof JSONObject || object instanceof JSONArray) {
                    this.a = jsonString;
                    return this;
                }
                throw new IllegalArgumentException(new JSONException("Not a valid JSON format"));
            }
            catch (JSONException jSONException) {
                throw new IllegalArgumentException(jSONException);
            }
        }

        public <T> Builder setObject(T object) {
            String string = new Moshi.Builder().build().adapter(object.getClass()).toJson(object);
            if (TextUtils.isEmpty((CharSequence)string)) {
                throw new IllegalArgumentException("Please check your JSON model class structure.");
            }
            this.setJsonText(string);
            return this;
        }

        public RawData build() {
            if (TextUtils.isEmpty((CharSequence)this.a)) {
                throw new IllegalStateException("Your JSON data is empty. Please use setObject or setJsonText first.");
            }
            return new RawData(this.a);
        }
    }
}

