/*
 * Decompiled with CFR 0.152.
 */
package io.straas.android.sdk.messaging;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.SimpleArrayMap;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.squareup.moshi.JsonReader;
import io.straas.android.sdk.authentication.credential.Credential;
import io.straas.android.sdk.authentication.identity.Identity;
import io.straas.android.sdk.messaging.AggregatedData;
import io.straas.android.sdk.messaging.ChatMetadata;
import io.straas.android.sdk.messaging.ChatMode;
import io.straas.android.sdk.messaging.ChatroomInfo;
import io.straas.android.sdk.messaging.ChatroomState;
import io.straas.android.sdk.messaging.Message;
import io.straas.android.sdk.messaging.MessagingException$RequestRejectedException;
import io.straas.android.sdk.messaging.RawData;
import io.straas.android.sdk.messaging.Role;
import io.straas.android.sdk.messaging.Sticker;
import io.straas.android.sdk.messaging.User;
import io.straas.android.sdk.messaging.a;
import io.straas.android.sdk.messaging.http.MessagingEndpoint;
import io.straas.android.sdk.messaging.interfaces.EventListener;
import io.straas.android.sdk.messaging.message.MessageRequest;
import io.straas.android.sdk.messaging.user.UserType;
import java.io.IOException;
import java.util.List;
import okio.Buffer;
import okio.BufferedSource;

public class ChatroomManager {
    private a a;

    public static Task<ChatroomManager> initialize() {
        return ChatroomManager.initialize(new ChatroomConfig.Builder().build());
    }

    public static Task<ChatroomManager> initialize(@NonNull ChatroomConfig config) {
        ChatroomConfig chatroomConfig;
        return Credential.validate().continueWith((Continuation)new b(chatroomConfig));
    }

    private ChatroomManager(ChatroomConfig chatroomConfig) {
        this.a = new a(Credential.getContext(), chatroomConfig);
    }

    /*
     * WARNING - void declaration
     */
    public Task<Void> connect(@NonNull String chatroomName, @NonNull Identity identity) {
        void var2_2;
        void var1_1;
        return this.a.a((String)var1_1, (Identity)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public boolean resetIdentity(Identity identity) {
        void var1_1;
        return this.a.a((Identity)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Task<Message[]> getMessages(MessageRequest request) {
        void var1_1;
        return this.a.a((MessageRequest)var1_1, "text");
    }

    /*
     * WARNING - void declaration
     */
    public Task<AggregatedData[]> getAggregatedData(MessageRequest request) {
        void var1_1;
        return this.a.a((MessageRequest)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Task<Message[]> getRawData(MessageRequest request) {
        void var1_1;
        return this.a.a((MessageRequest)var1_1, "raw");
    }

    /*
     * WARNING - void declaration
     */
    public Task<User[]> getUsers(UserType userType) {
        void var1_1;
        return this.a.a((UserType)var1_1);
    }

    public Task<ChatroomInfo> getChatroomInfo() {
        return this.a.i();
    }

    /*
     * WARNING - void declaration
     */
    public Task<Void> updateNickname(String name) {
        void var1_1;
        return this.a.a((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Task<Void> updateUserRole(User user, Role role) {
        void var2_2;
        void var1_1;
        return this.a.a(new MessagingEndpoint.q((int)var1_1.getLabel(), (Role)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public Task<Void> updateUserRoleByMemberId(String memberId, Role role) {
        void var2_2;
        void var1_1;
        return this.a.a(new MessagingEndpoint.q(Credential.getAccountId(), (String)var1_1, (Role)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public Task<Void> blockUsers(List<User> users) {
        void var1_1;
        return this.a.a((List<User>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Task<Void> reviveUsers(List<User> users) {
        void var1_1;
        return this.a.b((List<User>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Task<Void> removeMessage(Message message) {
        void var1_1;
        return this.a.c((Message)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Task<Void> sendMessage(String message) {
        void var1_1;
        return this.a.a("text", var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Task<Void> pinMessage(Message message) {
        void var1_1;
        return this.a.b((Message)var1_1);
    }

    public Task<Void> unpinMessage() {
        return this.a.v();
    }

    /*
     * WARNING - void declaration
     */
    public Task<Void> sendAggregatedData(String message) {
        void var1_1;
        if (!TextUtils.isEmpty((CharSequence)message) && var1_1.length() <= 100) {
            return this.a.a("aggregate", var1_1);
        }
        return Tasks.forException((Exception)new MessagingException$RequestRejectedException(new IllegalArgumentException("Aggregate data must be between 1~100 characters.")));
    }

    /*
     * WARNING - void declaration
     */
    public Task<Void> sendRawData(@NonNull RawData rawData) {
        void var1_2;
        a a2;
        if (rawData == null) {
            return Tasks.forException((Exception)new MessagingException$RequestRejectedException(new IllegalArgumentException("Check your raw data.")));
        }
        try {
            a2 = this.a;
        }
        catch (IOException iOException) {
            return Tasks.forException((Exception)new MessagingException$RequestRejectedException(iOException));
        }
        return a2.a("raw", JsonReader.of((BufferedSource)new Buffer().writeUtf8(var1_2.getJsonText())).readJsonValue());
    }

    /*
     * WARNING - void declaration
     */
    public void addFakeMessage(Message message) {
        void var1_1;
        this.a.a((Message)var1_1);
    }

    public User getCurrentUser() {
        return this.a.k();
    }

    public Message getPinnedMessage() {
        return this.a.m();
    }

    public List<Sticker> getSticker() {
        return this.a.n();
    }

    public int getUserCount() {
        return this.a.p();
    }

    public ChatMode getChatMode() {
        return this.a.h();
    }

    public int getSendMessageInterval() {
        return this.a.l();
    }

    public ChatroomState getChatroomState() {
        return this.a.j();
    }

    public Task<Void> disconnect() {
        return this.a.f();
    }

    /*
     * WARNING - void declaration
     */
    public boolean addEventListener(EventListener listener) {
        void var1_1;
        return this.a.a((EventListener)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void addAllEventListener(EventListener ... listeners) {
        void var1_1;
        this.a.a((EventListener[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean removeEventListener(EventListener listener) {
        void var1_1;
        return this.a.b((EventListener)var1_1);
    }

    public void removeAllEventListener() {
        this.a.t();
    }

    @NonNull
    public SimpleArrayMap<String, Integer> getTotalAggregatedData() {
        return this.a.o();
    }

    /*
     * WARNING - void declaration
     */
    public Task<Void> setMetadata(@NonNull String key, @Nullable Object value, boolean broadcast) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.a.a((String)var1_1, var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public Task<SimpleArrayMap<String, ChatMetadata>> getMetadata(String ... keys) {
        void var1_1;
        return this.a.a((String[])var1_1);
    }

    public static class ChatroomConfig {
        private final String a;
        private final String b;
        private final String c;

        private ChatroomConfig(Builder builder) {
            this.a = builder.a;
            this.b = builder.b;
            this.c = builder.c;
        }

        public String b() {
            return this.a;
        }

        public String c() {
            return this.b;
        }

        public String a() {
            return this.c;
        }

        public static class Builder {
            private String a = "mgr.straas.net";
            private String b;
            private String c = "app.straas.net";

            /*
             * WARNING - void declaration
             */
            public Builder setRestHost(String host) {
                if (!TextUtils.isEmpty((CharSequence)host)) {
                    void var1_1;
                    this.a = var1_1;
                }
                return this;
            }

            /*
             * WARNING - void declaration
             */
            public Builder setSocketHost(String host) {
                void var1_1;
                this.b = var1_1;
                return this;
            }

            /*
             * WARNING - void declaration
             */
            public Builder setCmsHost(String host) {
                if (!TextUtils.isEmpty((CharSequence)host)) {
                    void var1_1;
                    this.c = var1_1;
                }
                return this;
            }

            public ChatroomConfig build() {
                return new ChatroomConfig(this);
            }
        }
    }

    private static class b
    implements Continuation<Void, ChatroomManager> {
        private final ChatroomConfig a;

        private b(ChatroomConfig chatroomConfig) {
            this.a = chatroomConfig;
        }

        public ChatroomManager a(@NonNull Task<Void> task) throws Exception {
            if (task.isSuccessful()) {
                return new ChatroomManager(this.a);
            }
            if (task.getException() == null) {
                return null;
            }
            throw task.getException();
        }
    }
}

