/*
 * Decompiled with CFR 0.152.
 */
package io.straas.android.sdk.messaging;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.preference.PreferenceManager;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.collection.SimpleArrayMap;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.ikala.android.httptask.CallManager;
import com.ikala.android.httptask.iKalaHttpUtils;
import io.straas.android.sdk.authentication.credential.Credential;
import io.straas.android.sdk.authentication.identity.Identity;
import io.straas.android.sdk.authentication.internal.Utils;
import io.straas.android.sdk.base.internal.Utils;
import io.straas.android.sdk.messaging.Message;
import io.straas.android.sdk.messaging.MessagingException$InternalException;
import io.straas.android.sdk.messaging.MessagingException$NotFoundException;
import io.straas.android.sdk.messaging.MessagingException$RequestRejectedException;
import io.straas.android.sdk.messaging.c;
import io.straas.android.sdk.messaging.http.ArchivedMessagesEndpoint;
import io.straas.android.sdk.messaging.http.MessagingEndpoint;
import io.straas.android.sdk.messaging.http.a.a;
import io.straas.android.sdk.messaging.message.ArchivedMessagesMeta;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import java.util.regex.Pattern;
import okhttp3.Interceptor;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.moshi.MoshiConverterFactory;

public class ArchivedMessagesManager {
    private static final Pattern b = Pattern.compile("[A-Za-z0-9_-]+");
    private c a;

    public static Task<ArchivedMessagesManager> initialize(Identity identity) {
        Identity identity2;
        return Credential.validate().continueWith((Continuation)new b(identity2));
    }

    ArchivedMessagesManager(Identity identity, String string) {
        HandlerThread handlerThread;
        ArchivedMessagesManager archivedMessagesManager = handlerThread;
        new HandlerThread("ArchivedMessagesManager").start();
        v1.a = new c(archivedMessagesManager.getLooper(), identity, string);
    }

    /*
     * WARNING - void declaration
     */
    public Task<ArchivedMessagesMeta> getArchivedMessagesMeta(String chatroomName, String archiveId) {
        void var2_2;
        if (!TextUtils.isEmpty((CharSequence)chatroomName) && !TextUtils.isEmpty((CharSequence)var2_2)) {
            void var1_1;
            TaskCompletionSource taskCompletionSource;
            if (!b.matcher((CharSequence)var2_2).matches()) {
                return Tasks.forException((Exception)new MessagingException$RequestRejectedException(new IllegalArgumentException("Wrong archiveId.")));
            }
            TaskCompletionSource taskCompletionSource2 = taskCompletionSource;
            ArchivedMessagesManager archivedMessagesManager = archivedMessagesManager2;
            taskCompletionSource2();
            ArchivedMessagesManager archivedMessagesManager2 = archivedMessagesManager.a.obtainMessage();
            ((android.os.Message)archivedMessagesManager2).what = 0;
            ((android.os.Message)archivedMessagesManager2).obj = taskCompletionSource2;
            Bundle bundle = new Bundle();
            bundle.putString("CHATROOM_NAME", (String)var1_1);
            bundle.putString("ARCHIVE_ID", (String)var2_2);
            archivedMessagesManager2.setData(bundle);
            archivedMessagesManager.a.sendMessage((android.os.Message)archivedMessagesManager2);
            return taskCompletionSource.getTask();
        }
        return Tasks.forException((Exception)new MessagingException$RequestRejectedException(new IllegalArgumentException("ChatroomName and archiveId shouldn't be null.")));
    }

    /*
     * WARNING - void declaration
     */
    public Task<Message[]> getArchivedMessages(String chatroomName, String archiveId, long startTime, long endTime) {
        void var2_2;
        if (!TextUtils.isEmpty((CharSequence)chatroomName) && !TextUtils.isEmpty((CharSequence)var2_2)) {
            void var5_4;
            void var3_3;
            if (!b.matcher((CharSequence)var2_2).matches()) {
                return Tasks.forException((Exception)new MessagingException$RequestRejectedException(new IllegalArgumentException("Wrong archive id.")));
            }
            if (var3_3 <= var5_4 && var3_3 != 0L && var5_4 != 0L) {
                void var1_1;
                TaskCompletionSource taskCompletionSource;
                TaskCompletionSource taskCompletionSource2 = taskCompletionSource;
                ArchivedMessagesManager archivedMessagesManager = archivedMessagesManager2;
                taskCompletionSource2();
                ArchivedMessagesManager archivedMessagesManager2 = archivedMessagesManager.a.obtainMessage();
                ((android.os.Message)archivedMessagesManager2).what = 1;
                ((android.os.Message)archivedMessagesManager2).obj = taskCompletionSource2;
                Bundle bundle = new Bundle();
                bundle.putString("CHATROOM_NAME", (String)var1_1);
                bundle.putString("ARCHIVE_ID", (String)var2_2);
                bundle.putLong("START_TIME", (long)var3_3);
                bundle.putLong("END_TIME", (long)var5_4);
                archivedMessagesManager2.setData(bundle);
                archivedMessagesManager.a.sendMessage((android.os.Message)archivedMessagesManager2);
                return taskCompletionSource.getTask();
            }
            return Tasks.forException((Exception)new MessagingException$RequestRejectedException(new IllegalArgumentException("Wrong startTime and endTime.")));
        }
        return Tasks.forException((Exception)new MessagingException$RequestRejectedException(new IllegalArgumentException("ChatroomName and archiveId shouldn't be null.")));
    }

    private static class b
    implements Continuation<Void, ArchivedMessagesManager> {
        private Identity a;

        private b(Identity identity) {
            this.a = identity;
        }

        public ArchivedMessagesManager a(@NonNull Task<Void> task) throws Exception {
            if (task.isSuccessful()) {
                return new ArchivedMessagesManager(this.a, "mgr.straas.net");
            }
            throw task.getException();
        }
    }

    private static class io.straas.android.sdk.messaging.ArchivedMessagesManager$c
    extends Handler {
        private Utils.HandlerThreadExecutor a;
        private MessagingEndpoint b;
        private String c;
        private SharedPreferences d;
        private final SimpleArrayMap<String, String> e;
        private final SimpleArrayMap<String, ArchivedMessagesEndpoint> f;
        private final SimpleArrayMap<String, SimpleArrayMap<String, ArchivedMessagesEndpoint.a>> g;
        private final SimpleArrayMap<ArchivedMessagesEndpoint.a, SimpleArrayMap<String, Message[]>> h;
        private a.a i;

        private io.straas.android.sdk.messaging.ArchivedMessagesManager$c(Looper looper, Identity identity, String string) {
            io.straas.android.sdk.messaging.ArchivedMessagesManager$c c2 = this;
            super(looper);
            c2.e = new SimpleArrayMap();
            c2.f = new SimpleArrayMap();
            c2.g = new SimpleArrayMap();
            c2.h = new SimpleArrayMap();
            c2.i = new a.a(){

                @Override
                public void a(String string) {
                    f f2 = this;
                    io.straas.android.sdk.messaging.ArchivedMessagesManager$c.a(f2.c.this, string);
                    if (f2.c.this.d != null) {
                        c.this.d.edit().putString("KEY_API_TOKEN", string).apply();
                    }
                }
            };
            c2.a = new Utils.HandlerThreadExecutor((Handler)this);
            c2.d = PreferenceManager.getDefaultSharedPreferences((Context)Credential.getContext());
            c2.a();
            this.b = this.a(identity, string);
        }

        private void a(TaskCompletionSource<ArchivedMessagesMeta> taskCompletionSource, String string, String string2) {
            TaskCompletionSource<ArchivedMessagesMeta> taskCompletionSource2 = taskCompletionSource;
            io.straas.android.sdk.messaging.ArchivedMessagesManager$c c2 = a2;
            String string3 = string;
            ArchivedMessagesEndpoint.a a2 = ((io.straas.android.sdk.messaging.ArchivedMessagesManager$c)((Object)a2)).a(string, string2);
            try {
                c2.a(string3);
                taskCompletionSource2.setResult((Object)a2.toArchivedMessagesMeta());
            }
            catch (Exception exception) {
                taskCompletionSource.setException(exception);
            }
        }

        private ArchivedMessagesEndpoint.a a(String string, String string2) throws Exception {
            ArchivedMessagesEndpoint.a a2 = this.b(string, string2);
            if (a2 != null) {
                return a2;
            }
            a2 = this.c(string, string2);
            this.a(string, string2, a2);
            return a2;
        }

        private ArchivedMessagesEndpoint.a b(String string, String string2) {
            io.straas.android.sdk.messaging.ArchivedMessagesManager$c c2 = (SimpleArrayMap)c2.g.get((Object)string);
            if (c2 != null) {
                return (ArchivedMessagesEndpoint.a)c2.get(string2);
            }
            return null;
        }

        private void a(String string, String string2, ArchivedMessagesEndpoint.a a2) {
            SimpleArrayMap simpleArrayMap = (SimpleArrayMap)this.g.get((Object)string);
            if (simpleArrayMap == null) {
                SimpleArrayMap simpleArrayMap2;
                simpleArrayMap = simpleArrayMap2;
                simpleArrayMap2 = new SimpleArrayMap();
                this.g.put((Object)string, (Object)simpleArrayMap);
            }
            simpleArrayMap.put((Object)string2, (Object)a2);
        }

        private ArchivedMessagesEndpoint.a c(String string, String string2) throws Exception {
            Response response = response.c(string).getMeta(string2);
            try {
                response = response.execute();
            }
            catch (IOException iOException) {
                throw io.straas.android.sdk.messaging.c.a((Call)response, iOException);
            }
            if (response.isSuccessful()) {
                ((ArchivedMessagesEndpoint.a)response.body()).archiveId = string2;
                return (ArchivedMessagesEndpoint.a)response.body();
            }
            if (response.code() == 404) {
                throw new MessagingException$NotFoundException();
            }
            throw io.straas.android.sdk.messaging.c.a(response);
        }

        private void a(final TaskCompletionSource<Message[]> taskCompletionSource, String object, final String aArray, final long l2, final long l3) {
            io.straas.android.sdk.messaging.ArchivedMessagesManager$c c2 = this;
            io.straas.android.sdk.messaging.ArchivedMessagesManager$c c3 = c2;
            io.straas.android.sdk.messaging.ArchivedMessagesManager$c c4 = c2;
            String string = object;
            object = this.a((String)object, (String)aArray);
            try {
                c3.a(string);
                aArray = c4.a((ArchivedMessagesEndpoint.a)object, l2, l3);
            }
            catch (Exception exception) {
                taskCompletionSource.setException(exception);
                return;
            }
            if (aArray.length == 0) {
                taskCompletionSource.setResult((Object)new Message[0]);
                return;
            }
            final Task[] taskArray = new Task[aArray.length];
            for (int i2 = 0; i2 < aArray.length; ++i2) {
                taskArray[i2] = this.a((ArchivedMessagesEndpoint.a)object, aArray[i2].id);
            }
            Tasks.whenAll((Task[])taskArray).addOnSuccessListener((Executor)this.a, (OnSuccessListener)new OnSuccessListener<Void>(){

                public void a(Void void_) {
                    int n2 = 0;
                    ArchivedMessagesEndpoint.a.a[] aArray2 = messageArray3.aArray;
                    int n3 = messageArray3.aArray.length;
                    for (int i2 = 0; i2 < n3; ++i2) {
                        n2 += aArray2[i2].len;
                    }
                    Message[] messageArray = new Message[n2];
                    int n4 = 0;
                    n3 = 0;
                    while (true) {
                        int n5;
                        Object[] objectArray = messageArray3.taskArray;
                        if (n3 >= messageArray3.taskArray.length) break;
                        objectArray = (Message[])objectArray[n3].getResult();
                        int n6 = 0;
                        if (n3 != 0 && n3 != messageArray3.taskArray.length - 1) {
                            n5 = objectArray.length;
                        } else {
                            n6 = messageArray3.c.this.a((Message[])objectArray, messageArray3.l2, false);
                            n5 = messageArray3.c.this.a((Message[])objectArray, messageArray3.l3, true) - n6 + 1;
                            if (n5 < 0) {
                                messageArray3.taskCompletionSource.setException((Exception)new MessagingException$InternalException());
                                return;
                            }
                        }
                        System.arraycopy(objectArray, n6, messageArray, n4, n5);
                        n4 += n5;
                        ++n3;
                    }
                    Message[] messageArray2 = messageArray3;
                    Message[] messageArray3 = new Message[n4];
                    System.arraycopy(messageArray, 0, messageArray3, 0, n4);
                    messageArray2.taskCompletionSource.setResult((Object)messageArray3);
                }
            }).addOnFailureListener(new OnFailureListener(this){

                public void onFailure(@NonNull Exception exception) {
                    Task[] taskArray2 = taskArray;
                    int n2 = taskArray.length;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        Task task = taskArray2[i2];
                        if (task.isSuccessful()) continue;
                        taskCompletionSource.setException(task.getException());
                        return;
                    }
                    taskCompletionSource.setException(exception);
                }
            });
            return;
        }

        private ArchivedMessagesEndpoint.a.a[] a(ArchivedMessagesEndpoint.a aArray, long l2, long l3) throws Exception {
            ArrayList arrayList;
            ArrayList arrayList2 = arrayList;
            arrayList = new ArrayList();
            aArray = aArray.files;
            int n2 = aArray.files.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                ArchivedMessagesEndpoint.a.a a2 = aArray[i2];
                if (a2.start > l3 || a2.end < l2) continue;
                arrayList2.add(a2);
            }
            return arrayList2.toArray(new ArchivedMessagesEndpoint.a.a[0]);
        }

        private Task<Message[]> a(final ArchivedMessagesEndpoint.a a2, final String string) {
            Message[] messageArray = this.b(a2, string);
            if (messageArray != null) {
                return Tasks.forResult((Object)messageArray);
            }
            return this.c(a2, string).addOnSuccessListener((Executor)this.a, (OnSuccessListener)new OnSuccessListener<Message[]>(){

                public void a(Message[] messageArray) {
                    c c2 = a22;
                    ArchivedMessagesEndpoint.a a22 = c2.a2;
                    a22.c.this.a(a22, c2.string, messageArray);
                }
            });
        }

        private Message[] b(ArchivedMessagesEndpoint.a a2, String string) {
            io.straas.android.sdk.messaging.ArchivedMessagesManager$c c2 = (SimpleArrayMap)c2.h.get((Object)a2);
            if (c2 != null) {
                return (Message[])c2.get(string);
            }
            return null;
        }

        private void a(ArchivedMessagesEndpoint.a a2, String string, Message[] messageArray) {
            if (a2 != null) {
                SimpleArrayMap simpleArrayMap = (SimpleArrayMap)this.h.get((Object)a2);
                if (simpleArrayMap == null) {
                    SimpleArrayMap simpleArrayMap2;
                    simpleArrayMap = simpleArrayMap2;
                    simpleArrayMap2 = new SimpleArrayMap();
                    this.h.put((Object)a2, (Object)simpleArrayMap);
                }
                simpleArrayMap.put((Object)string, (Object)messageArray);
            }
        }

        private Task<Message[]> c(final ArchivedMessagesEndpoint.a a2, final String string) {
            TaskCompletionSource taskCompletionSource;
            final TaskCompletionSource taskCompletionSource2 = taskCompletionSource;
            taskCompletionSource = new TaskCompletionSource();
            try {
                final ArchivedMessagesEndpoint archivedMessagesEndpoint = this.c(a2.chatroomName);
                new Thread(new Runnable(this){

                    @Override
                    public void run() {
                        d d2 = this;
                        Response response = d2.a2.archiveId;
                        response = archivedMessagesEndpoint.getMessages((String)response, d2.string);
                        try {
                            response = response.execute();
                        }
                        catch (IOException iOException) {
                            taskCompletionSource2.setException(io.straas.android.sdk.messaging.c.a((Call)response, iOException));
                            return;
                        }
                        if (response.isSuccessful()) {
                            c.a a22;
                            int n2 = ((MessagingEndpoint.k[])response.body()).length;
                            Message[] messageArray = new Message[n2];
                            c.a a3 = a22;
                            a22 = new c.a();
                            for (int i2 = 0; i2 < n2; ++i2) {
                                messageArray[i2] = new Message.Builder(((MessagingEndpoint.k[])response.body())[i2], a3).build();
                            }
                            taskCompletionSource2.setResult((Object)messageArray);
                        } else {
                            taskCompletionSource2.setException(io.straas.android.sdk.messaging.c.a(response));
                        }
                        return;
                    }
                }).start();
            }
            catch (Exception exception) {
                return Tasks.forException((Exception)exception);
            }
            return taskCompletionSource2.getTask();
        }

        private int a(Message[] messageArray, long l2, boolean bl) {
            int n2;
            int n3 = 0;
            int n4 = messageArray.length - 1;
            while (n4 - n3 > 1) {
                n2 = this.a(messageArray, n3, n4, l2, bl);
                if (n2 != -1) {
                    return n2;
                }
                n2 = (n3 + n4) / 2;
                if (l2 < messageArray[n2].getCreatedDate()) {
                    int n5 = n3;
                    n3 = n2;
                    n2 = n5;
                } else {
                    n3 = n4;
                }
                int n6 = n3;
                n3 = n2;
                n4 = n6;
            }
            n2 = bl ? n4 : n3;
            while (bl ? n2 >= n3 : n2 <= n4) {
                int n7 = n2;
                int n8 = this.a(messageArray, n7, n7, l2, bl);
                if (n8 != -1) {
                    return n8;
                }
                n8 = bl ? -1 : 1;
                n2 += n8;
            }
            return -1;
        }

        private int a(Message[] messageArray, int n2, int n3, long l2, boolean bl) {
            if (bl) {
                if (messageArray[n3].getCreatedDate() <= l2) {
                    return n3;
                }
            } else if (l2 <= messageArray[n2].getCreatedDate()) {
                return n2;
            }
            return -1;
        }

        private ArchivedMessagesEndpoint c(String string) throws Exception {
            ArchivedMessagesEndpoint archivedMessagesEndpoint = this.e(string);
            if (archivedMessagesEndpoint != null) {
                return archivedMessagesEndpoint;
            }
            archivedMessagesEndpoint = this.d(string);
            this.a(string, archivedMessagesEndpoint);
            return archivedMessagesEndpoint;
        }

        private ArchivedMessagesEndpoint e(String string) {
            return (ArchivedMessagesEndpoint)this.f.get((Object)string);
        }

        private void a(String string, ArchivedMessagesEndpoint archivedMessagesEndpoint) {
            this.f.put((Object)string, (Object)archivedMessagesEndpoint);
        }

        private ArchivedMessagesEndpoint d(String string) throws Exception {
            Response response = this.b.getChatProfileByChannel(this.c, string, Credential.getAccountId());
            try {
                response = response.execute();
            }
            catch (IOException iOException) {
                throw io.straas.android.sdk.messaging.c.a((Call)response, iOException);
            }
            if (response.isSuccessful()) {
                this.e.put((Object)string, (Object)((MessagingEndpoint.g)response.body()).id);
                return this.b(((MessagingEndpoint.g)response.body()).arcMsgURL);
            }
            throw io.straas.android.sdk.messaging.c.a(response);
        }

        private MessagingEndpoint a(Identity identity, String string) {
            a a2;
            Interceptor[] interceptorArray = new Interceptor[1];
            Interceptor[] interceptorArray2 = interceptorArray;
            a a3 = a2;
            a2 = new a(string, this.i);
            interceptorArray[0] = a3;
            return (MessagingEndpoint)Utils.createMemberRetrofit((String)string, (String)"app.straas.net", (Identity)identity, (Interceptor[])interceptorArray2).create(MessagingEndpoint.class);
        }

        private ArchivedMessagesEndpoint b(String string) {
            if (!string.endsWith("/")) {
                string = string + "/";
            }
            return (ArchivedMessagesEndpoint)new Retrofit.Builder().baseUrl(string).addConverterFactory((Converter.Factory)MoshiConverterFactory.create()).client(iKalaHttpUtils.getOkHttpClient()).build().create(ArchivedMessagesEndpoint.class);
        }

        private void a(String call) {
            if (TextUtils.isEmpty((CharSequence)(call = (String)this.e.get((Object)call)))) {
                return;
            }
            call = this.b.addUsersToChat(this.c, new MessagingEndpoint.b((String)call, null, "Guest"));
            call.enqueue((Callback)new CallManager.Callback<MessagingEndpoint.c>(this, null, call, null){

                public void onResponse(Call<MessagingEndpoint.c> call, Response<MessagingEndpoint.c> response) {
                    super.onResponse(call, response);
                }

                public void onFailure(Call<MessagingEndpoint.c> call, Throwable throwable) {
                    super.onFailure(call, throwable);
                }
            });
        }

        private void a() {
            if (!TextUtils.isEmpty((CharSequence)this.c)) {
                return;
            }
            String string = null;
            SharedPreferences sharedPreferences = this.d;
            if (sharedPreferences != null) {
                string = sharedPreferences.getString("KEY_API_TOKEN", null);
            }
            this.c = !TextUtils.isEmpty(string) ? string : "unknownApiToken";
        }

        static /* synthetic */ String a(io.straas.android.sdk.messaging.ArchivedMessagesManager$c c2, String string) {
            c2.c = string;
            return string;
        }

        public void handleMessage(android.os.Message object) {
            io.straas.android.sdk.messaging.ArchivedMessagesManager$c c2;
            android.os.Message message = object;
            super.handleMessage(object);
            Object object2 = message.getData();
            int n2 = message.what;
            if (n2 != 0) {
                if (n2 == 1) {
                    io.straas.android.sdk.messaging.ArchivedMessagesManager$c c3 = c2;
                    Bundle bundle = object2;
                    c2 = (TaskCompletionSource)object.obj;
                    object = bundle.getString("CHATROOM_NAME");
                    object2 = bundle.getString("ARCHIVE_ID");
                    long l2 = bundle.getLong("START_TIME");
                    long l3 = bundle.getLong("END_TIME");
                    c3.a((TaskCompletionSource<Message[]>)c2, (String)object, (String)object2, l2, l3);
                }
            } else {
                io.straas.android.sdk.messaging.ArchivedMessagesManager$c c4 = c2;
                Bundle bundle = object2;
                c2 = (TaskCompletionSource)object.obj;
                object = bundle.getString("CHATROOM_NAME");
                object2 = bundle.getString("ARCHIVE_ID");
                c4.a((TaskCompletionSource<ArchivedMessagesMeta>)c2, (String)object, (String)object2);
            }
        }
    }
}

