/*
 * Decompiled with CFR 0.152.
 */
package io.straas.android.sdk.messaging;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.preference.PreferenceManager;
import android.support.annotation.NonNull;
import android.support.v4.util.SimpleArrayMap;
import android.text.TextUtils;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.ikala.android.httptask.CallManager;
import com.ikala.android.httptask.iKalaHttpUtils;
import io.straas.android.sdk.authentication.credential.Credential;
import io.straas.android.sdk.authentication.identity.Identity;
import io.straas.android.sdk.authentication.internal.Utils;
import io.straas.android.sdk.base.internal.Utils;
import io.straas.android.sdk.messaging.Message;
import io.straas.android.sdk.messaging.MessagingException;
import io.straas.android.sdk.messaging.c;
import io.straas.android.sdk.messaging.http.ArchivedMessagesEndpoint;
import io.straas.android.sdk.messaging.http.MessagingEndpoint;
import io.straas.android.sdk.messaging.http.a.a;
import io.straas.android.sdk.messaging.message.ArchivedMessagesMeta;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import java.util.regex.Pattern;
import okhttp3.Interceptor;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.moshi.MoshiConverterFactory;

public class ArchivedMessagesManager {
    private b a;
    private static final Pattern b = Pattern.compile("[A-Za-z0-9_-]+");

    public static Task<ArchivedMessagesManager> initialize(Identity identity) {
        return Credential.validate().continueWith((Continuation)new a(identity));
    }

    ArchivedMessagesManager(Identity identity, String restfulHost) {
        HandlerThread handlerThread = new HandlerThread("ArchivedMessagesManager");
        handlerThread.start();
        this.a = new b(handlerThread.getLooper(), identity, restfulHost);
    }

    public Task<ArchivedMessagesMeta> getArchivedMessagesMeta(String chatroomName, String archiveId) {
        if (TextUtils.isEmpty((CharSequence)chatroomName) || TextUtils.isEmpty((CharSequence)archiveId)) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalArgumentException("ChatroomName and archiveId shouldn't be null.")));
        }
        if (!b.matcher(archiveId).matches()) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalArgumentException("Wrong archiveId.")));
        }
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        android.os.Message message = this.a.obtainMessage();
        message.what = 0;
        message.obj = taskCompletionSource;
        Bundle bundle = new Bundle();
        bundle.putString("CHATROOM_NAME", chatroomName);
        bundle.putString("ARCHIVE_ID", archiveId);
        message.setData(bundle);
        this.a.sendMessage(message);
        return taskCompletionSource.getTask();
    }

    public Task<Message[]> getArchivedMessages(String chatroomName, String archiveId, long startTime, long endTime) {
        if (TextUtils.isEmpty((CharSequence)chatroomName) || TextUtils.isEmpty((CharSequence)archiveId)) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalArgumentException("ChatroomName and archiveId shouldn't be null.")));
        }
        if (!b.matcher(archiveId).matches()) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalArgumentException("Wrong archive id.")));
        }
        if (startTime > endTime || startTime == 0L || endTime == 0L) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalArgumentException("Wrong startTime and endTime.")));
        }
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        android.os.Message message = this.a.obtainMessage();
        message.what = 1;
        message.obj = taskCompletionSource;
        Bundle bundle = new Bundle();
        bundle.putString("CHATROOM_NAME", chatroomName);
        bundle.putString("ARCHIVE_ID", archiveId);
        bundle.putLong("START_TIME", startTime);
        bundle.putLong("END_TIME", endTime);
        message.setData(bundle);
        this.a.sendMessage(message);
        return taskCompletionSource.getTask();
    }

    private static class a
    implements Continuation<Void, ArchivedMessagesManager> {
        private Identity a;

        private a(Identity identity) {
            this.a = identity;
        }

        public ArchivedMessagesManager a(@NonNull Task<Void> task) throws Exception {
            if (task.isSuccessful()) {
                return new ArchivedMessagesManager(this.a, "https://mgr.straas.net");
            }
            throw task.getException();
        }

        public /* synthetic */ Object then(@NonNull Task task) throws Exception {
            return this.a((Task<Void>)task);
        }
    }

    private static class b
    extends Handler {
        private Utils.HandlerThreadExecutor a;
        private MessagingEndpoint b;
        private String c;
        private SharedPreferences d;
        private final SimpleArrayMap<String, String> e = new SimpleArrayMap();
        private final SimpleArrayMap<String, ArchivedMessagesEndpoint> f = new SimpleArrayMap();
        private final SimpleArrayMap<String, SimpleArrayMap<String, ArchivedMessagesEndpoint.a>> g = new SimpleArrayMap();
        private final SimpleArrayMap<ArchivedMessagesEndpoint.a, SimpleArrayMap<String, Message[]>> h = new SimpleArrayMap();
        private a.a i = new a.a(){

            @Override
            public void a(String string) {
                b.this.c = string;
                if (b.this.d != null) {
                    b.this.d.edit().putString("KEY_API_TOKEN", string).apply();
                }
            }
        };

        private b(Looper looper, Identity identity, String string) {
            super(looper);
            this.a = new Utils.HandlerThreadExecutor((Handler)this);
            this.d = PreferenceManager.getDefaultSharedPreferences((Context)Credential.getContext());
            this.a();
            this.b = this.a(identity, string);
        }

        public void handleMessage(android.os.Message msg) {
            super.handleMessage(msg);
            Bundle bundle = msg.getData();
            switch (msg.what) {
                case 0: {
                    this.a((TaskCompletionSource<ArchivedMessagesMeta>)((TaskCompletionSource)msg.obj), bundle.getString("CHATROOM_NAME"), bundle.getString("ARCHIVE_ID"));
                    break;
                }
                case 1: {
                    this.a((TaskCompletionSource<Message[]>)((TaskCompletionSource)msg.obj), bundle.getString("CHATROOM_NAME"), bundle.getString("ARCHIVE_ID"), bundle.getLong("START_TIME"), bundle.getLong("END_TIME"));
                }
            }
        }

        private void a(TaskCompletionSource<ArchivedMessagesMeta> taskCompletionSource, String string, String string2) {
            try {
                ArchivedMessagesEndpoint.a a2 = this.a(string, string2);
                this.e(string);
                taskCompletionSource.setResult((Object)a2.toArchivedMessagesMeta());
            }
            catch (Exception exception) {
                taskCompletionSource.setException(exception);
            }
        }

        private ArchivedMessagesEndpoint.a a(String string, String string2) throws Exception {
            ArchivedMessagesEndpoint.a a2 = this.b(string, string2);
            if (a2 != null) {
                return a2;
            }
            a2 = this.c(string, string2);
            this.a(string, string2, a2);
            return a2;
        }

        private ArchivedMessagesEndpoint.a b(String string, String string2) {
            SimpleArrayMap simpleArrayMap = (SimpleArrayMap)this.g.get((Object)string);
            if (simpleArrayMap != null) {
                return (ArchivedMessagesEndpoint.a)simpleArrayMap.get((Object)string2);
            }
            return null;
        }

        private void a(String string, String string2, ArchivedMessagesEndpoint.a a2) {
            SimpleArrayMap simpleArrayMap = (SimpleArrayMap)this.g.get((Object)string);
            if (simpleArrayMap == null) {
                simpleArrayMap = new SimpleArrayMap();
                this.g.put((Object)string, (Object)simpleArrayMap);
            }
            simpleArrayMap.put((Object)string2, (Object)a2);
        }

        private ArchivedMessagesEndpoint.a c(String string, String string2) throws Exception {
            Response response;
            Call<ArchivedMessagesEndpoint.a> call = this.a(string).getMeta(string2);
            try {
                response = call.execute();
            }
            catch (IOException iOException) {
                throw io.straas.android.sdk.messaging.c.a(call, iOException);
            }
            if (response.isSuccessful()) {
                ((ArchivedMessagesEndpoint.a)response.body()).archiveId = string2;
                return (ArchivedMessagesEndpoint.a)response.body();
            }
            if (response.code() == 404) {
                throw new MessagingException.NotFoundException();
            }
            throw io.straas.android.sdk.messaging.c.a(response);
        }

        private void a(final TaskCompletionSource<Message[]> taskCompletionSource, String string, String string2, final long l2, final long l3) {
            ArchivedMessagesEndpoint.a.a[] aArray;
            ArchivedMessagesEndpoint.a a2;
            try {
                a2 = this.a(string, string2);
                this.e(string);
                aArray = this.a(a2, l2, l3);
            }
            catch (Exception exception) {
                taskCompletionSource.setException(exception);
                return;
            }
            if (aArray.length == 0) {
                taskCompletionSource.setResult((Object)new Message[0]);
                return;
            }
            final Task[] taskArray = new Task[aArray.length];
            for (int i2 = 0; i2 < aArray.length; ++i2) {
                taskArray[i2] = this.a(a2, aArray[i2].id);
            }
            Tasks.whenAll((Task[])taskArray).addOnSuccessListener((Executor)this.a, (OnSuccessListener)new OnSuccessListener<Void>(){

                public void a(Void void_) {
                    int n2 = 0;
                    for (ArchivedMessagesEndpoint.a.a messageArray : aArray) {
                        n2 += messageArray.len;
                    }
                    Object[] objectArray = new Message[n2];
                    int n3 = 0;
                    for (int i2 = 0; i2 < taskArray.length; ++i2) {
                        int n4;
                        Message[] messageArray = (Message[])taskArray[i2].getResult();
                        int n5 = 0;
                        if (i2 == 0 || i2 == taskArray.length - 1) {
                            n5 = b.this.a(messageArray, l2, false);
                            int n6 = b.this.a(messageArray, l3, true);
                            n4 = n6 - n5 + 1;
                            if (n4 < 0) {
                                taskCompletionSource.setException((Exception)new MessagingException.InternalException());
                                return;
                            }
                        } else {
                            n4 = messageArray.length;
                        }
                        System.arraycopy(messageArray, n5, objectArray, n3, n4);
                        n3 += n4;
                    }
                    Message[] messageArray = new Message[n3];
                    System.arraycopy(objectArray, 0, messageArray, 0, messageArray.length);
                    taskCompletionSource.setResult((Object)messageArray);
                }

                public /* synthetic */ void onSuccess(Object object) {
                    this.a((Void)object);
                }
            }).addOnFailureListener(new OnFailureListener(){

                public void onFailure(@NonNull Exception e2) {
                    for (Task task : taskArray) {
                        if (task.isSuccessful()) continue;
                        taskCompletionSource.setException(task.getException());
                        return;
                    }
                    taskCompletionSource.setException(e2);
                }
            });
        }

        private ArchivedMessagesEndpoint.a.a[] a(ArchivedMessagesEndpoint.a a2, long l2, long l3) throws Exception {
            ArrayList<ArchivedMessagesEndpoint.a.a> arrayList = new ArrayList<ArchivedMessagesEndpoint.a.a>();
            for (ArchivedMessagesEndpoint.a.a a3 : a2.files) {
                if (a3.start > l3 || a3.end < l2) continue;
                arrayList.add(a3);
            }
            return arrayList.toArray(new ArchivedMessagesEndpoint.a.a[0]);
        }

        private Task<Message[]> a(final ArchivedMessagesEndpoint.a a2, final String string) {
            Message[] messageArray = this.b(a2, string);
            if (messageArray != null) {
                return Tasks.forResult((Object)messageArray);
            }
            return this.c(a2, string).addOnSuccessListener((Executor)this.a, (OnSuccessListener)new OnSuccessListener<Message[]>(){

                public void a(Message[] messageArray) {
                    b.this.a(a2, string, messageArray);
                }

                public /* synthetic */ void onSuccess(Object object) {
                    this.a((Message[])object);
                }
            });
        }

        private Message[] b(ArchivedMessagesEndpoint.a a2, String string) {
            SimpleArrayMap simpleArrayMap = (SimpleArrayMap)this.h.get((Object)a2);
            if (simpleArrayMap != null) {
                return (Message[])simpleArrayMap.get((Object)string);
            }
            return null;
        }

        private void a(ArchivedMessagesEndpoint.a a2, String string, Message[] messageArray) {
            if (a2 != null) {
                SimpleArrayMap simpleArrayMap = (SimpleArrayMap)this.h.get((Object)a2);
                if (simpleArrayMap == null) {
                    simpleArrayMap = new SimpleArrayMap();
                    this.h.put((Object)a2, (Object)simpleArrayMap);
                }
                simpleArrayMap.put((Object)string, (Object)messageArray);
            }
        }

        private Task<Message[]> c(final ArchivedMessagesEndpoint.a a2, final String string) {
            ArchivedMessagesEndpoint archivedMessagesEndpoint;
            final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
            try {
                archivedMessagesEndpoint = this.a(a2.chatroomName);
            }
            catch (Exception exception) {
                return Tasks.forException((Exception)exception);
            }
            new Thread(new Runnable(){

                @Override
                public void run() {
                    Response response;
                    Call<MessagingEndpoint.k[]> call = archivedMessagesEndpoint.getMessages(a2.archiveId, string);
                    try {
                        response = call.execute();
                    }
                    catch (IOException iOException) {
                        taskCompletionSource.setException(io.straas.android.sdk.messaging.c.a(call, iOException));
                        return;
                    }
                    if (response.isSuccessful()) {
                        int n2 = ((MessagingEndpoint.k[])response.body()).length;
                        Message[] messageArray = new Message[n2];
                        c.a a22 = new c.a();
                        for (int i2 = 0; i2 < n2; ++i2) {
                            Message message;
                            messageArray[i2] = message = new Message.Builder(((MessagingEndpoint.k[])response.body())[i2], a22).build();
                        }
                        taskCompletionSource.setResult((Object)messageArray);
                    } else {
                        taskCompletionSource.setException(io.straas.android.sdk.messaging.c.a(response));
                    }
                }
            }).start();
            return taskCompletionSource.getTask();
        }

        private int a(Message[] messageArray, long l2, boolean bl) {
            int n2;
            int n3;
            int n4 = 0;
            int n5 = messageArray.length - 1;
            while (n5 - n4 > 1) {
                n3 = this.a(messageArray, n4, n5, l2, bl);
                if (n3 != -1) {
                    return n3;
                }
                n2 = (n4 + n5) / 2;
                if (l2 < messageArray[n2].getCreatedDate()) {
                    n5 = n2;
                    continue;
                }
                n4 = n2;
            }
            int n6 = n2 = bl ? n5 : n4;
            while (bl ? n2 >= n4 : n2 <= n5) {
                n3 = this.a(messageArray, n2, n2, l2, bl);
                if (n3 != -1) {
                    return n3;
                }
                n2 += bl ? -1 : 1;
            }
            return -1;
        }

        private int a(Message[] messageArray, int n2, int n3, long l2, boolean bl) {
            if (bl) {
                if (messageArray[n3].getCreatedDate() <= l2) {
                    return n3;
                }
            } else if (l2 <= messageArray[n2].getCreatedDate()) {
                return n2;
            }
            return -1;
        }

        private ArchivedMessagesEndpoint a(String string) throws Exception {
            ArchivedMessagesEndpoint archivedMessagesEndpoint = this.b(string);
            if (archivedMessagesEndpoint != null) {
                return archivedMessagesEndpoint;
            }
            archivedMessagesEndpoint = this.c(string);
            this.a(string, archivedMessagesEndpoint);
            return archivedMessagesEndpoint;
        }

        private ArchivedMessagesEndpoint b(String string) {
            return (ArchivedMessagesEndpoint)this.f.get((Object)string);
        }

        private void a(String string, ArchivedMessagesEndpoint archivedMessagesEndpoint) {
            this.f.put((Object)string, (Object)archivedMessagesEndpoint);
        }

        private ArchivedMessagesEndpoint c(String string) throws Exception {
            Response response;
            Call<MessagingEndpoint.g> call = this.b.getChatProfileByChannel(this.c, string, Credential.getAccountId());
            try {
                response = call.execute();
            }
            catch (IOException iOException) {
                throw io.straas.android.sdk.messaging.c.a(call, iOException);
            }
            if (response.isSuccessful()) {
                this.e.put((Object)string, (Object)((MessagingEndpoint.g)response.body()).id);
                return this.d(((MessagingEndpoint.g)response.body()).arcMsgURL);
            }
            throw io.straas.android.sdk.messaging.c.a(response);
        }

        private MessagingEndpoint a(Identity identity, String string) {
            return (MessagingEndpoint)Utils.createMemberRetrofit((String)string, (Identity)identity, (Interceptor[])new Interceptor[]{new io.straas.android.sdk.messaging.http.a.a(string, this.i)}).create(MessagingEndpoint.class);
        }

        private ArchivedMessagesEndpoint d(String string) {
            if (!string.endsWith("/")) {
                string = string + "/";
            }
            return (ArchivedMessagesEndpoint)new Retrofit.Builder().baseUrl(string).addConverterFactory((Converter.Factory)MoshiConverterFactory.create()).client(iKalaHttpUtils.getOkHttpClient()).build().create(ArchivedMessagesEndpoint.class);
        }

        private void e(String string) {
            String string2 = (String)this.e.get((Object)string);
            if (TextUtils.isEmpty((CharSequence)string2)) {
                return;
            }
            Call<MessagingEndpoint.c> call = this.b.addUsersToChat(this.c, new MessagingEndpoint.b(string2, null, "Guest"));
            call.enqueue((Callback)new CallManager.Callback<MessagingEndpoint.c>(null, call, null){

                public void onResponse(Call<MessagingEndpoint.c> call, Response<MessagingEndpoint.c> response) {
                    super.onResponse(call, response);
                }

                public void onFailure(Call<MessagingEndpoint.c> call, Throwable t) {
                    super.onFailure(call, t);
                }
            });
        }

        private void a() {
            if (!TextUtils.isEmpty((CharSequence)this.c)) {
                return;
            }
            String string = null;
            if (this.d != null) {
                string = this.d.getString("KEY_API_TOKEN", null);
            }
            this.c = !TextUtils.isEmpty(string) ? string : "unknownApiToken";
        }
    }
}

