/*
 * Decompiled with CFR 0.152.
 */
package io.straas.android.sdk.messaging;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.CountDownTimer;
import android.os.Handler;
import android.preference.PreferenceManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.ikala.android.controller.Retriable;
import com.ikala.android.controller.RetryDelayController;
import com.ikala.android.httptask.CallManager;
import com.ikala.android.httptask.error.HttpTaskError;
import com.ikala.android.utils.iKalaJSONUtil;
import com.ikala.android.utils.iKalaUtils;
import com.squareup.moshi.JsonDataException;
import com.squareup.moshi.Moshi;
import io.socket.client.IO;
import io.socket.client.Socket;
import io.socket.client.SocketIOException;
import io.socket.emitter.Emitter;
import io.straas.android.sdk.base.credential.Credential;
import io.straas.android.sdk.base.identity.Identity;
import io.straas.android.sdk.base.interfaces.OnResultListener;
import io.straas.android.sdk.base.internal.Utils;
import io.straas.android.sdk.messaging.ChatMode;
import io.straas.android.sdk.messaging.ChatRoomInfo;
import io.straas.android.sdk.messaging.ChatRoomState;
import io.straas.android.sdk.messaging.Message;
import io.straas.android.sdk.messaging.MessagingError;
import io.straas.android.sdk.messaging.User;
import io.straas.android.sdk.messaging.a.a;
import io.straas.android.sdk.messaging.a.a.a;
import io.straas.android.sdk.messaging.interfaces.EventListener;
import io.straas.android.sdk.messaging.internal.MessageCategory;
import io.straas.android.sdk.messaging.internal.UserStatus;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.net.ssl.SSLContext;
import okhttp3.Interceptor;
import okhttp3.ResponseBody;
import org.json.JSONArray;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class a {
    private static String a = iKalaUtils.getLogTag((String)a.class.getSimpleName());
    private static final String[] b = new String[]{"websocket"};
    private ChatRoomState c = ChatRoomState.IDLE;
    private int d;
    private long e;
    private String f;
    private Identity g;
    private boolean h;
    private EventListener i;
    private String j;
    private int k;
    private int l;
    private String m;
    private String n;
    private Integer o;
    private User p;
    private boolean q;
    private io.straas.android.sdk.messaging.a.a r;
    private final CallManager s = new CallManager();
    private RetryDelayController t;
    private String u;
    private SharedPreferences v;
    private Handler w = new Handler();
    private Socket x;
    private ChatMode y = ChatMode.ALL;
    private a.a$a z = new a.a$a(){

        @Override
        public void a(String string) {
            a.this.u = string;
            if (a.this.v != null) {
                a.this.v.edit().putString("KEY_API_TOKEN", string).apply();
            }
        }
    };
    private CountDownTimer A = new CountDownTimer(5000L, 5000L){

        public void onTick(long l2) {
        }

        public void onFinish() {
            a.this.a(MessagingError.INTERNAL_ERROR);
        }
    };

    a(Context context) {
        this.h();
        this.v = PreferenceManager.getDefaultSharedPreferences((Context)context);
    }

    private void h() {
        this.t = new RetryDelayController(new Retriable(){

            public void retry() {
                a.this.o();
            }
        });
        this.t.setMaxCount(7);
        this.t.enableExponentialBackoff(true);
        this.t.setBaseRetryInterval(500L);
    }

    private io.straas.android.sdk.messaging.a.a a(Identity identity) {
        return (io.straas.android.sdk.messaging.a.a)Utils.createMemberRetrofit((String)"https://mgr.straas.net", (Identity)identity, (Interceptor[])new Interceptor[]{new io.straas.android.sdk.messaging.a.a.a("https://mgr.straas.net", this.z)}).create(io.straas.android.sdk.messaging.a.a.class);
    }

    void a(@NonNull String string, @NonNull Identity identity, boolean bl, @NonNull EventListener eventListener) {
        if (eventListener == null) {
            return;
        }
        if (this.c != ChatRoomState.IDLE || TextUtils.isEmpty((CharSequence)string) || identity == null) {
            this.a(eventListener, MessagingError.REQUEST_REJECTED);
            return;
        }
        this.c = ChatRoomState.CONNECTING;
        this.g = identity;
        this.f = string;
        this.h = bl;
        this.i = eventListener;
        this.r = this.a(identity);
        this.t.stop();
        this.q = false;
        this.a();
    }

    private void i() {
        if (!TextUtils.isEmpty((CharSequence)this.u)) {
            return;
        }
        String string = null;
        if (this.v != null) {
            string = this.v.getString("KEY_API_TOKEN", null);
        }
        this.u = !TextUtils.isEmpty(string) ? string : "unknownApiToken";
    }

    private void a(b b2) {
        switch (b2) {
            case a: {
                this.j();
                break;
            }
            case b: {
                this.k();
                break;
            }
            case c: {
                this.l();
                break;
            }
            case d: {
                this.m();
            }
        }
    }

    void a() {
        this.c = ChatRoomState.CONNECTING;
        this.i();
        this.a(io.straas.android.sdk.messaging.a$b.a);
    }

    private void j() {
        String string = Credential.getAccountId();
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.b(MessagingError.INTERNAL_ERROR);
            this.g();
        }
        Call<a$d> call = this.r.a(this.u, this.f, string);
        call.enqueue((Callback)new c<a$d>(this.s, call, null){

            @Override
            public void onResponse(Call<a$d> call, Response<a$d> response) {
                super.onResponse(call, response);
                if (!a.this.r()) {
                    return;
                }
                if (response.isSuccessful() && response.body() != null) {
                    a.this.m = ((a$d)response.body()).id;
                    a.this.d = ((a$d)response.body()).inputInterval;
                    a.this.y = ChatMode.a(((a$d)response.body()).chatWriteMode);
                    a.this.l = ((a$d)response.body()).guestCount;
                    a.this.k = ((a$d)response.body()).memberCount;
                    a.this.a(io.straas.android.sdk.messaging.a$b.b);
                }
            }
        });
    }

    private void k() {
        this.j = this.g.isGuest() ? "Guest" : null;
        Call<a$c> call = this.r.a(this.u, new a$b(this.m, this.n, this.j));
        call.enqueue((Callback)new c<a$c>(this.s, call, null){

            @Override
            public void onResponse(Call<a$c> call, Response<a$c> response) {
                super.onResponse(call, response);
                if (!a.this.r()) {
                    return;
                }
                if (response.isSuccessful() && response.body() != null) {
                    a$c$a a2 = ((a$c)response.body()).userMetas[0];
                    a.this.n = a2.userToken;
                    a.this.o = (Integer)a2.label;
                    a.this.a(io.straas.android.sdk.messaging.a$b.c);
                }
            }
        });
    }

    private void l() {
        this.n();
    }

    private void m() {
        this.t.stop();
        this.c = ChatRoomState.CONNECTED;
        if (!this.q) {
            this.q = true;
            this.a(this.i);
        }
    }

    private void n() {
        Socket socket;
        IO.Options options = new IO.Options();
        options.reconnection = false;
        options.rememberUpgrade = true;
        options.forceNew = true;
        options.transports = b;
        options.timeout = 30000L;
        try {
            options.sslContext = SSLContext.getDefault();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        try {
            socket = IO.socket((String)"https://mgs.straas.net", (IO.Options)options);
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
            this.a(MessagingError.INTERNAL_ERROR);
            return;
        }
        this.a(socket);
        this.b(socket);
        this.x = socket;
        socket.connect();
    }

    private void a(final Socket socket) {
        if (socket == null) {
            return;
        }
        socket.on("connect", new Emitter.Listener(){

            public void call(Object ... objectArray) {
                JSONArray jSONArray = new JSONArray();
                jSONArray.put((Object)a.this.n);
                jSONArray.put((Object)a.this.m);
                a.this.A.start();
                socket.emit(io.straas.android.sdk.messaging.a$a.a.a(), new Object[]{a.this.n, a.this.m});
            }
        });
        socket.on("connect_error", new Emitter.Listener(){

            public void call(Object ... objectArray) {
                if (objectArray.length > 0) {
                    for (Object object : objectArray) {
                        if (!a.this.a(object)) continue;
                        a.this.a(MessagingError.INTERNAL_ERROR);
                        return;
                    }
                }
            }
        });
        socket.on("disconnect", new Emitter.Listener(){

            public void call(Object ... objectArray) {
                if (!a.this.r()) {
                    return;
                }
                a.this.a(MessagingError.NETWORK_ERROR);
            }
        });
    }

    private boolean a(Object object) {
        return object instanceof SocketIOException && ((SocketIOException)object).getMessage().equals("timeout");
    }

    private void b(Socket socket) {
        if (socket == null) {
            return;
        }
        socket.on(io.straas.android.sdk.messaging.a$a.b.a(), new Emitter.Listener(){

            public void call(Object ... objectArray) {
                if (objectArray == null || objectArray.length <= 0) {
                    return;
                }
                if (!(objectArray[0] instanceof JSONObject)) {
                    return;
                }
                a.this.A.cancel();
                User user = User.a((JSONObject)objectArray[0]);
                a.this.p = user;
                a.this.a(io.straas.android.sdk.messaging.a$b.d);
            }
        });
        socket.on(io.straas.android.sdk.messaging.a$a.c.a(), new Emitter.Listener(){

            public void call(Object ... objectArray) {
                if (objectArray.length <= 0) {
                    return;
                }
                if (!(objectArray[0] instanceof JSONObject)) {
                    return;
                }
                JSONObject jSONObject = (JSONObject)objectArray[0];
                Message message = Message.a(jSONObject);
                a.this.a(a.this.i, message);
            }
        });
        socket.on(io.straas.android.sdk.messaging.a$a.d.a(), new Emitter.Listener(){

            public void call(Object ... objectArray) {
                if (objectArray == null || objectArray.length <= 0) {
                    return;
                }
                if (!(objectArray[0] instanceof String)) {
                    return;
                }
                String string = (String)objectArray[0];
                a.this.a(a.this.i, string);
            }
        });
        socket.on(io.straas.android.sdk.messaging.a$a.e.a(), new Emitter.Listener(){

            public void call(Object ... objectArray) {
                a.this.c(a.this.i);
            }
        });
        socket.on(io.straas.android.sdk.messaging.a$a.f.a(), new Emitter.Listener(){

            public void call(Object ... objectArray) {
                int n = 0;
                if (objectArray == null || objectArray.length <= 0) {
                    return;
                }
                if (!(objectArray[0] instanceof JSONArray)) {
                    return;
                }
                JSONArray jSONArray = (JSONArray)objectArray[0];
                if (jSONArray != null) {
                    n = jSONArray.length();
                }
                ArrayList<User> arrayList = new ArrayList<User>();
                for (int i2 = 0; i2 < n; ++i2) {
                    JSONObject jSONObject = iKalaJSONUtil.getJSONObjectFromJSONArray((JSONArray)jSONArray, (int)i2);
                    if (jSONObject == null) continue;
                    User user = User.a(jSONObject);
                    if (a.this.o != null && a.this.o.intValue() == user.getLabel().intValue()) continue;
                    arrayList.add(user);
                }
                if (arrayList.size() != 0) {
                    a.this.a(a.this.i, arrayList.toArray(new User[0]));
                }
            }
        });
        socket.on(io.straas.android.sdk.messaging.a$a.g.a(), new Emitter.Listener(){

            public void call(Object ... objectArray) {
                int n = 0;
                if (objectArray == null || objectArray.length <= 0) {
                    return;
                }
                if (!(objectArray[0] instanceof JSONArray)) {
                    return;
                }
                JSONArray jSONArray = (JSONArray)objectArray[0];
                if (jSONArray != null) {
                    n = jSONArray.length();
                }
                ArrayList<User> arrayList = new ArrayList<User>();
                for (int i2 = 0; i2 < n; ++i2) {
                    JSONObject jSONObject = (JSONObject)iKalaJSONUtil.getObjectFromJSONArray((JSONArray)jSONArray, (int)i2);
                    User user = User.a(jSONObject);
                    arrayList.add(user);
                    if (a.this.o == null || a.this.o.intValue() != user.getLabel().intValue()) continue;
                    a.this.p = user;
                }
                if (arrayList.size() != 0) {
                    a.this.b(a.this.i, arrayList.toArray(new User[0]));
                }
            }
        });
        socket.on(io.straas.android.sdk.messaging.a$a.h.a(), new Emitter.Listener(){

            public void call(Object ... objectArray) {
                int n = 0;
                if (objectArray == null || objectArray.length <= 0) {
                    return;
                }
                if (!(objectArray[0] instanceof JSONArray)) {
                    return;
                }
                JSONArray jSONArray = (JSONArray)objectArray[0];
                if (jSONArray != null) {
                    n = jSONArray.length();
                }
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                block3: for (int i2 = 0; i2 < n; ++i2) {
                    JSONObject jSONObject = (JSONObject)iKalaJSONUtil.getObjectFromJSONArray((JSONArray)jSONArray, (int)i2);
                    int n2 = iKalaJSONUtil.getJSONInt((JSONObject)jSONObject, (String)"label", (int)-1);
                    if (-1 == n2) continue;
                    String string = iKalaJSONUtil.getJSONString((JSONObject)jSONObject, (String)"status");
                    if (a.this.o != null && n2 == a.this.o) {
                        switch (UserStatus.a(string)) {
                            case DELETED: {
                                if (!a.this.r()) continue block3;
                                break;
                            }
                        }
                        continue;
                    }
                    User.a a2 = new User.a();
                    a2.a(n2).a(string);
                    arrayList.add(n2);
                }
                if (arrayList.size() != 0) {
                    a.this.a(a.this.i, arrayList.toArray(new Integer[0]));
                }
            }
        });
        socket.on(io.straas.android.sdk.messaging.a$a.i.a(), new Emitter.Listener(){

            public void call(Object ... objectArray) {
                if (objectArray == null || objectArray.length <= 0) {
                    return;
                }
                if (!(objectArray[0] instanceof JSONObject)) {
                    return;
                }
                JSONObject jSONObject = (JSONObject)objectArray[0];
                a.this.l = iKalaJSONUtil.getJSONInt((JSONObject)jSONObject, (String)"guestCount");
                a.this.k = iKalaJSONUtil.getJSONInt((JSONObject)jSONObject, (String)"memberCount");
                a.this.a(a.this.i, a.this.l, a.this.k);
            }
        });
        socket.on(io.straas.android.sdk.messaging.a$a.j.a(), new Emitter.Listener(){

            public void call(Object ... objectArray) {
            }
        });
        socket.on(io.straas.android.sdk.messaging.a$a.k.a(), new Emitter.Listener(){

            public void call(Object ... objectArray) {
                if (objectArray == null || objectArray.length <= 0) {
                    return;
                }
                if (!(objectArray[0] instanceof JSONObject)) {
                    return;
                }
                JSONObject jSONObject = (JSONObject)objectArray[0];
                String string = iKalaJSONUtil.getJSONString((JSONObject)jSONObject, (String)"chatWriteMode", (String)"ALL");
                a.this.y = ChatMode.a(string);
                a.this.a(a.this.i, a.this.y);
            }
        });
        socket.on(io.straas.android.sdk.messaging.a$a.l.a(), new Emitter.Listener(){

            public void call(Object ... objectArray) {
                if (objectArray == null || objectArray.length <= 0) {
                    return;
                }
                if (!(objectArray[0] instanceof JSONObject)) {
                    return;
                }
                JSONObject jSONObject = (JSONObject)objectArray[0];
                String string = iKalaJSONUtil.getJSONString((JSONObject)jSONObject, (String)"chatId");
                if (!string.equals(a.this.m)) {
                    return;
                }
                a.this.d = iKalaJSONUtil.getJSONInt((JSONObject)jSONObject, (String)"inputInterval");
                a.this.a(a.this.i, a.this.d);
            }
        });
    }

    private void a(final EventListener eventListener) {
        this.w.post(new Runnable(){

            @Override
            public void run() {
                eventListener.onConnected();
            }
        });
    }

    private void a(final EventListener eventListener, final MessagingError messagingError) {
        this.w.post(new Runnable(){

            @Override
            public void run() {
                eventListener.onConnectFailed(messagingError);
            }
        });
    }

    private void b(final EventListener eventListener, final MessagingError messagingError) {
        this.w.post(new Runnable(){

            @Override
            public void run() {
                eventListener.onError(messagingError);
            }
        });
    }

    private void b(final EventListener eventListener) {
        this.w.post(new Runnable(){

            @Override
            public void run() {
                eventListener.onDisconnected();
            }
        });
    }

    private void a(final EventListener eventListener, final Message message) {
        this.w.post(new Runnable(){

            @Override
            public void run() {
                eventListener.onMessageAdded(message);
            }
        });
    }

    private void a(final EventListener eventListener, final String string) {
        this.w.post(new Runnable(){

            @Override
            public void run() {
                eventListener.onMessageRemoved(string);
            }
        });
    }

    private void c(final EventListener eventListener) {
        this.w.post(new Runnable(){

            @Override
            public void run() {
                eventListener.onMessageFlushed();
            }
        });
    }

    private void a(final EventListener eventListener, final User[] userArray) {
        this.w.post(new Runnable(){

            @Override
            public void run() {
                eventListener.onUserJoined(userArray);
            }
        });
    }

    private void b(final EventListener eventListener, final User[] userArray) {
        this.w.post(new Runnable(){

            @Override
            public void run() {
                eventListener.onUserUpdated(userArray);
            }
        });
    }

    private void a(final EventListener eventListener, final Integer[] integerArray) {
        this.w.post(new Runnable(){

            @Override
            public void run() {
                eventListener.onUserLeft(integerArray);
            }
        });
    }

    private void a(final EventListener eventListener, final int n, final int n2) {
        this.w.post(new Runnable(){

            @Override
            public void run() {
                eventListener.userCount(n, n2);
            }
        });
    }

    private void a(final EventListener eventListener, final ChatMode chatMode) {
        this.w.post(new Runnable(){

            @Override
            public void run() {
                eventListener.onChatWriteModeChanged(chatMode);
            }
        });
    }

    private void a(final EventListener eventListener, final int n) {
        this.w.post(new Runnable(){

            @Override
            public void run() {
                eventListener.onInputIntervalChanged(n);
            }
        });
    }

    void a(int n, int n2, final @NonNull OnResultListener<Message[], MessagingError> onResultListener) {
        if (onResultListener == null) {
            return;
        }
        if (this.c != ChatRoomState.CONNECTED || !this.a(n, n2, 100)) {
            onResultListener.onFailure((Object)MessagingError.REQUEST_REJECTED);
            return;
        }
        int n3 = n2;
        int n4 = (n - 1) * n2;
        Call<a$e> call = this.r.a(this.u, this.n, this.m, Arrays.asList(MessageCategory.USER), true, n3, n4);
        call.enqueue((Callback)new d<a$e>(this.s, call, onResultListener){

            @Override
            public void onResponse(Call<a$e> call, Response<a$e> response) {
                super.onResponse(call, response);
                a$e e2 = (a$e)response.body();
                if (!response.isSuccessful() || e2 == null || e2.messages == null) {
                    return;
                }
                int n = e2.messages.length;
                Message[] messageArray = new Message[n];
                for (int i2 = 0; i2 < n; ++i2) {
                    Message message;
                    messageArray[i2] = message = new Message.a(e2.messages[i2]).a();
                }
                onResultListener.onSuccess((Object)messageArray);
            }
        });
    }

    void b(int n, int n2, final @NonNull OnResultListener<User[], MessagingError> onResultListener) {
        if (onResultListener == null) {
            return;
        }
        if (this.c != ChatRoomState.CONNECTED || !this.a(n, n2, 200)) {
            onResultListener.onFailure((Object)MessagingError.REQUEST_REJECTED);
            return;
        }
        int n3 = n2;
        int n4 = (n - 1) * n2;
        Call<a$f> call = this.r.a(this.u, this.n, this.m, Collections.singletonList(UserStatus.ACTIVE), null, null, n3, n4);
        call.enqueue((Callback)new d<a$f>(this.s, call, onResultListener){

            @Override
            public void onResponse(Call<a$f> call, Response<a$f> response) {
                super.onResponse(call, response);
                a$f f2 = (a$f)response.body();
                if (!response.isSuccessful() || f2 == null || f2.users == null) {
                    return;
                }
                int n = f2.users.length;
                User[] userArray = new User[n];
                for (int i2 = 0; i2 < n; ++i2) {
                    User user;
                    userArray[i2] = user = new User.a(f2.users[i2]).a();
                }
                onResultListener.onSuccess((Object)userArray);
            }
        });
    }

    void a(final @NonNull OnResultListener<ChatRoomInfo, MessagingError> onResultListener) {
        if (onResultListener == null) {
            return;
        }
        if (this.c != ChatRoomState.CONNECTED) {
            onResultListener.onFailure((Object)MessagingError.REQUEST_REJECTED);
            return;
        }
        String string = Credential.getAccountId();
        if (TextUtils.isEmpty((CharSequence)string)) {
            onResultListener.onFailure((Object)MessagingError.INTERNAL_ERROR);
            return;
        }
        Call<a$d> call = this.r.a(this.u, this.f, string);
        call.enqueue((Callback)new d<a$d>(this.s, call, onResultListener){

            @Override
            public void onResponse(Call<a$d> call, Response<a$d> response) {
                super.onResponse(call, response);
                if (response.isSuccessful() && response.body() != null && onResultListener != null) {
                    onResultListener.onSuccess((Object)((a$d)response.body()).toChatRoomInfo());
                }
            }
        });
    }

    void a(String string, final OnResultListener<Void, MessagingError> onResultListener) {
        if (this.c != ChatRoomState.CONNECTED || TextUtils.isEmpty((CharSequence)string)) {
            if (onResultListener != null) {
                onResultListener.onFailure((Object)MessagingError.REQUEST_REJECTED);
            }
            return;
        }
        Call<ResponseBody> call = this.r.a(this.u, new a$a(this.m, this.n, string, null));
        call.enqueue((Callback)new d<ResponseBody>(this.s, call, onResultListener){

            @Override
            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                super.onResponse(call, response);
                if (response.isSuccessful()) {
                    a.this.e = System.currentTimeMillis();
                    if (onResultListener != null) {
                        onResultListener.onSuccess(null);
                    }
                }
                Log.d((String)"Ray", (String)"onResponse");
            }

            @Override
            public void onFailure(Call<ResponseBody> call, Throwable throwable) {
                super.onFailure(call, throwable);
            }
        });
    }

    void b(final String string, final OnResultListener<Void, MessagingError> onResultListener) {
        if (this.c != ChatRoomState.CONNECTED || !this.g.isGuest()) {
            if (onResultListener != null) {
                onResultListener.onFailure((Object)MessagingError.REQUEST_REJECTED);
            }
            return;
        }
        this.j = string;
        Call<ResponseBody> call = this.r.a(this.u, new a$l(this.m, this.n, Collections.singletonList(new a$g(this.o, this.j, null))));
        call.enqueue((Callback)new d<ResponseBody>(this.s, call, onResultListener){

            @Override
            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                super.onResponse(call, response);
                a.this.p.a(string);
                if (response.isSuccessful() && onResultListener != null) {
                    onResultListener.onSuccess(null);
                }
            }
        });
    }

    User b() {
        return this.p;
    }

    int c() {
        return this.k;
    }

    int d() {
        return this.l;
    }

    int e() {
        int n = (int)((System.currentTimeMillis() - this.e) / 1000L);
        int n2 = this.d - n;
        return n2 > 0 ? n2 : 0;
    }

    ChatRoomState f() {
        return this.c;
    }

    void g() {
        if (!this.r()) {
            return;
        }
        this.a(false);
    }

    private void o() {
        this.a(true);
    }

    private void a(boolean bl) {
        if (bl) {
            this.c = ChatRoomState.CONNECTING;
        } else {
            this.c = ChatRoomState.DISCONNECTING;
            this.t.stop();
        }
        this.s.cancelAllCalls();
        this.q();
        if (iKalaUtils.isEmptyString((CharSequence)this.n) || iKalaUtils.isEmptyString((CharSequence)this.m) || this.o == null) {
            if (bl) {
                this.a();
            }
        } else {
            this.b(bl);
            this.p();
        }
        if (!bl) {
            this.c = ChatRoomState.IDLE;
            if (this.q) {
                this.b(this.i);
            }
        }
    }

    private void p() {
        this.m = null;
        this.n = null;
        this.o = null;
        this.p = null;
    }

    private synchronized void q() {
        if (this.x == null) {
            return;
        }
        this.x.off();
        this.x.disconnect();
    }

    private void b(final boolean bl) {
        Call<ResponseBody> call = this.r.a(this.u, this.n, this.m, Collections.singletonList(this.o));
        call.enqueue((Callback)new CallManager.Callback<ResponseBody>(this.s, call, null){

            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                super.onResponse(call, response);
                if (bl) {
                    a.this.a();
                }
            }

            public void onFailure(Call<ResponseBody> call, Throwable throwable) {
                super.onFailure(call, throwable);
                MessagingError messagingError = a.this.a(call, throwable);
                if (bl && messagingError != MessagingError.TASK_CANCELED) {
                    a.this.a();
                }
            }
        });
    }

    private void a(MessagingError messagingError) {
        if (!this.r()) {
            this.b(messagingError);
            return;
        }
        if (!this.c(messagingError) || !this.t.retry()) {
            this.b(messagingError);
            this.g();
        }
    }

    private void b(MessagingError messagingError) {
        if (!this.q) {
            this.a(this.i, messagingError);
        } else if (messagingError != MessagingError.TASK_CANCELED) {
            this.b(this.i, messagingError);
        }
    }

    private boolean c(MessagingError messagingError) {
        switch (messagingError) {
            case NETWORK_ERROR: 
            case INTERNAL_ERROR: 
            case SERVER_ERROR: {
                return true;
            }
        }
        return false;
    }

    private MessagingError a(Response response) {
        int n = response.code();
        a$j j2 = this.a(response.errorBody());
        if (j2 == null || j2.code == null) {
            return MessagingError.INTERNAL_ERROR;
        }
        switch (n) {
            case 401: {
                if (!j2.code.equals("UnauthorizedError")) break;
                return MessagingError.UNAUTHORIZED_ERROR;
            }
            case 403: {
                if (!j2.code.equals("PermissionViolationError")) break;
                return MessagingError.PERMISSION_ERROR;
            }
            case 404: {
                if (!j2.code.equals("EntityNotFoundError")) break;
                return MessagingError.UNKNOWN_CHANNEL;
            }
            case 409: {
                if (!j2.code.equals("DuplicateEntityError") && !j2.code.equals("InvalidRequestError")) break;
                return MessagingError.INTERNAL_ERROR;
            }
            case 500: {
                return MessagingError.SERVER_ERROR;
            }
            default: {
                return MessagingError.INTERNAL_ERROR;
            }
        }
        return MessagingError.INTERNAL_ERROR;
    }

    private MessagingError a(Call call, Throwable throwable) {
        int n = HttpTaskError.getThrowableMappingId((Call)call, (Throwable)throwable);
        switch (n) {
            case 6: {
                return MessagingError.TASK_CANCELED;
            }
        }
        return MessagingError.NETWORK_ERROR;
    }

    private boolean r() {
        return this.c == ChatRoomState.CONNECTING || this.c == ChatRoomState.CONNECTED;
    }

    private a$j a(ResponseBody responseBody) {
        a$j j2;
        Moshi moshi = new Moshi.Builder().build();
        try {
            j2 = (a$j)moshi.adapter(a$j.class).fromJson(responseBody.source());
        }
        catch (JsonDataException | IOException throwable) {
            throwable.printStackTrace();
            j2 = new a$j();
        }
        return j2;
    }

    private boolean a(int n, int n2, int n3) {
        return n > 0 && n2 > 0 && n2 <= n3;
    }

    private class d<T>
    extends CallManager.Callback<T> {
        private int b;
        private OnResultListener c;

        public d(@Nullable CallManager callManager, @Nullable Call call, OnResultListener onResultListener) {
            super(callManager, call, null);
            this.b = 0;
            this.c = onResultListener;
        }

        public void onResponse(Call<T> call, Response<T> response) {
            super.onResponse(call, response);
            if (!response.isSuccessful()) {
                MessagingError messagingError = a.this.a(response);
                this.a(call, messagingError);
            }
        }

        public void onFailure(Call<T> call, Throwable throwable) {
            super.onFailure(call, throwable);
            MessagingError messagingError = a.this.a(call, throwable);
            this.a(call, messagingError);
        }

        private void a(final Call<T> call, MessagingError messagingError) {
            if (++this.b <= 3 && a.this.r() && a.this.c(messagingError)) {
                a.this.w.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        Call call2 = call.clone();
                        call2.enqueue((Callback)d.this);
                    }
                }, 1000L);
            } else if (this.c != null && messagingError != MessagingError.TASK_CANCELED) {
                this.c.onFailure((Object)messagingError);
            }
        }
    }

    private class c<T>
    extends CallManager.Callback<T> {
        public c(@Nullable CallManager callManager, @Nullable Call call, @Nullable CallManager.OnHttpTaskLoadingCallback onHttpTaskLoadingCallback) {
            super(callManager, call, onHttpTaskLoadingCallback);
        }

        public void onResponse(Call<T> call, Response<T> response) {
            super.onResponse(call, response);
            if (!response.isSuccessful()) {
                MessagingError messagingError = a.this.a(response);
                this.a(messagingError);
            }
        }

        public void onFailure(Call<T> call, Throwable throwable) {
            super.onFailure(call, throwable);
            MessagingError messagingError = a.this.a(call, throwable);
            this.a(messagingError);
        }

        protected void a(MessagingError messagingError) {
            a.this.a(messagingError);
        }
    }

    static enum a {
        a,
        b,
        c,
        d,
        e,
        f,
        g,
        h,
        i,
        j,
        k,
        l;


        public String a() {
            switch (this) {
                case a: {
                    return "subscribe";
                }
                case b: {
                    return "subscribed";
                }
                case c: {
                    return "message";
                }
                case d: {
                    return "message_remove";
                }
                case e: {
                    return "message_flush";
                }
                case f: {
                    return "user_add";
                }
                case g: {
                    return "user_update";
                }
                case h: {
                    return "user_remove";
                }
                case i: {
                    return "user_count";
                }
                case j: {
                    return "error";
                }
                case k: {
                    return "chat_write_mode";
                }
                case l: {
                    return "message_input_interval";
                }
            }
            return null;
        }
    }

    private static enum b {
        a,
        b,
        c,
        d;

    }
}

