/*
 * Decompiled with CFR 0.152.
 */
package io.straas.android.sdk.messaging.ui;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.app.Activity;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v4.os.ParcelableCompat;
import android.support.v4.os.ParcelableCompatCreatorCallbacks;
import android.support.v4.util.SimpleArrayMap;
import android.support.v4.view.AbsSavedState;
import android.support.v4.view.ViewCompat;
import android.support.v4.widget.TextViewCompat;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.ikala.android.utils.iKalaUtils;
import io.straas.android.sdk.base.identity.Identity;
import io.straas.android.sdk.messaging.ChatMode;
import io.straas.android.sdk.messaging.ChatroomManager;
import io.straas.android.sdk.messaging.ChatroomState;
import io.straas.android.sdk.messaging.Message;
import io.straas.android.sdk.messaging.User;
import io.straas.android.sdk.messaging.interfaces.EventListener;
import io.straas.android.sdk.messaging.message.MessageRequest;
import io.straas.android.sdk.messaging.ui.R;
import io.straas.android.sdk.messaging.ui.interfaces.CredentialAuthorizeListener;
import io.straas.android.sdk.messaging.ui.sticker.h;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public final class ChatroomOutputView
extends FrameLayout {
    private static final String a = ChatroomOutputView.class.getSimpleName();
    private boolean b = false;
    private int c = 0;
    private ChatroomManager d;
    private a e;
    private RecyclerView f;
    private View g;
    private CredentialAuthorizeListener h;
    private EventListener i;
    private boolean j;
    private boolean k;
    private LinearLayout l;
    private TextView m;
    private int n = 1;
    private EventListener o = new EventListener(){

        public void onConnected() {
            if (ViewCompat.isAttachedToWindow((View)ChatroomOutputView.this) && ((ChatroomOutputView)ChatroomOutputView.this).e.a.isEmpty() && ChatroomOutputView.this.c == 0) {
                ChatroomOutputView.this.a(true);
            } else {
                ChatroomOutputView.this.g.setVisibility(8);
            }
        }

        public void onConnectFailed(Exception error) {
            ChatroomOutputView.this.g.setVisibility(8);
        }

        public void onError(Exception error) {
            ChatroomOutputView.this.g.setVisibility(8);
        }

        public void onDisconnected() {
            ChatroomOutputView.this.g.setVisibility(8);
        }

        public void onChatWriteModeChanged(ChatMode chatMode) {
        }

        public void onInputIntervalChanged(int inputInterval) {
        }

        public void onMessageAdded(Message message) {
            if (!ChatroomOutputView.this.e.a(message)) {
                ChatroomOutputView.this.b();
            }
        }

        public void onMessageRemoved(String messageId) {
            ChatroomOutputView.this.e.b(new Message.Builder(messageId).build());
        }

        public void onAggregatedDataAdded(SimpleArrayMap<String, Integer> map) {
        }

        public void onRawDataAdded(Message message) {
        }

        public void onMessageFlushed() {
        }

        public void onUserJoined(User[] users) {
        }

        public void onUserUpdated(User[] users) {
        }

        public void onUserLeft(Integer[] userLabels) {
        }

        public void userCount(int userCount) {
        }
    };

    public ChatroomOutputView(Context context) {
        this(context, null);
    }

    public ChatroomOutputView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ChatroomOutputView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.a(context, attrs);
    }

    private void a(Context context, AttributeSet attributeSet) {
        ViewGroup viewGroup = (ViewGroup)LayoutInflater.from((Context)new ContextThemeWrapper(context, R.style.ChatroomTheme)).inflate(R.layout.chatroom_main_container, (ViewGroup)this, false);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.Chatroom, 0, R.style.ChatroomTheme);
        this.f = (RecyclerView)iKalaUtils.getView((View)viewGroup, (int)16908298);
        this.g = iKalaUtils.getView((View)viewGroup, (int)R.id.loadingBar);
        this.e = new a(this);
        this.f = (RecyclerView)iKalaUtils.getView((View)viewGroup, (int)16908298);
        this.f.setAdapter((RecyclerView.Adapter)this.e);
        GradientDrawable gradientDrawable = (GradientDrawable)ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.recyclerview_divider);
        gradientDrawable.setColor(typedArray.getColor(R.styleable.Chatroom_msgDividerColor, 0));
        this.f.addItemDecoration((RecyclerView.ItemDecoration)new io.straas.android.sdk.messaging.ui.a((Drawable)gradientDrawable));
        this.f.addOnScrollListener((RecyclerView.OnScrollListener)new b());
        this.j = typedArray.getBoolean(R.styleable.Chatroom_showAvatar, true);
        this.k = typedArray.getBoolean(R.styleable.Chatroom_relativeTime, true);
        this.l = (LinearLayout)iKalaUtils.getView((View)viewGroup, (int)R.id.new_msg_container);
        this.m = (TextView)iKalaUtils.getView((View)viewGroup, (int)R.id.new_msg_btn);
        this.m.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ChatroomOutputView.this.a();
                ChatroomOutputView.this.e.b();
            }
        });
        Drawable drawable2 = io.straas.android.sdk.messaging.ui.c.a(this.getContext(), R.drawable.ic_arrow_downward_chatroom);
        TextViewCompat.setCompoundDrawablesRelativeWithIntrinsicBounds((TextView)this.m, (Drawable)drawable2, null, null, null);
        Drawable drawable3 = ContextCompat.getDrawable((Context)context, (int)R.drawable.new_msg_background);
        int n = typedArray.getColor(R.styleable.Chatroom_sendButtonColor, 0);
        DrawableCompat.setTintList((Drawable)drawable3, (ColorStateList)this.a(n, this.a(n, 0.9f)));
        ViewCompat.setBackground((View)this.m, (Drawable)drawable3);
        this.addView((View)viewGroup);
        typedArray.recycle();
    }

    private ColorStateList a(int n, int n2) {
        int[] nArray = new int[]{n2, n};
        int[][] nArrayArray = new int[][]{{16842919}, new int[0]};
        return new ColorStateList((int[][])nArrayArray, nArray);
    }

    private int a(int n, float f2) {
        int n2 = Color.alpha((int)n);
        int n3 = Math.round((float)Color.red((int)n) * f2);
        int n4 = Math.round((float)Color.green((int)n) * f2);
        int n5 = Math.round((float)Color.blue((int)n) * f2);
        return Color.argb((int)n2, (int)Math.min(n3, 255), (int)Math.min(n4, 255), (int)Math.min(n5, 255));
    }

    public ChatroomOutputView setShowAvatar(boolean showAvatar) {
        this.j = showAvatar;
        return this;
    }

    public ChatroomOutputView enableRelativeTime(boolean enable) {
        this.k = enable;
        return this;
    }

    public void connect(final String chatroomName, final Identity identity, final boolean isPersonalChat) {
        this.g.setVisibility(0);
        Activity activity = iKalaUtils.getActivity((View)this);
        if (activity == null) {
            return;
        }
        ChatroomManager.initialize().addOnSuccessListener(activity, (OnSuccessListener)new OnSuccessListener<ChatroomManager>(){

            public void a(ChatroomManager chatroomManager) {
                ChatroomOutputView.this.setChatroomManager(chatroomManager);
                ChatroomOutputView.this.d.connect(chatroomName, identity, isPersonalChat);
                if (ChatroomOutputView.this.h != null) {
                    ChatroomOutputView.this.h.onSuccess(chatroomManager);
                }
            }

            public /* synthetic */ void onSuccess(Object object) {
                this.a((ChatroomManager)object);
            }
        }).addOnFailureListener(activity, new OnFailureListener(){

            public void onFailure(@NonNull Exception e2) {
                if (ChatroomOutputView.this.h != null) {
                    ChatroomOutputView.this.h.onFailure(e2);
                }
                ChatroomOutputView.this.g.setVisibility(8);
            }
        });
    }

    public ChatroomOutputView setChatroomManager(@NonNull ChatroomManager chatroomManager) {
        if (chatroomManager == null) {
            return this;
        }
        if (this.d != null) {
            this.d.removeEventListener(this.o);
            this.d.removeEventListener(this.i);
        }
        this.d = chatroomManager;
        this.d.addEventListener(this.o);
        if (this.i != null) {
            this.d.addEventListener(this.i);
        }
        if (this.d.getChatroomState() == ChatroomState.CONNECTED) {
            this.o.onConnected();
        }
        return this;
    }

    public void clearMessages() {
        this.e.a();
    }

    public void disconnect() {
        if (this.d != null) {
            this.d.disconnect();
        }
    }

    private void a(final boolean bl) {
        this.d.getMessages(new MessageRequest.Builder().page(this.c + 1).perPage(40).build()).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<Message[]>(){

            public void a(Message[] messageArray) {
                ChatroomOutputView.this.c++;
                ChatroomOutputView.this.e.a(messageArray, bl);
                ChatroomOutputView.this.g.setVisibility(8);
            }

            public /* synthetic */ void onSuccess(Object object) {
                this.a((Message[])object);
            }
        }).addOnFailureListener(new OnFailureListener(){

            public void onFailure(@NonNull Exception e2) {
                ChatroomOutputView.this.g.setVisibility(8);
            }
        });
    }

    public ChatroomManager getChatroomManager() {
        return this.d;
    }

    public ChatroomOutputView setCredentialAuthorizeListener(CredentialAuthorizeListener listener) {
        this.h = listener;
        return this;
    }

    public ChatroomOutputView setEventListener(EventListener listener) {
        if (this.d != null) {
            this.d.removeEventListener(this.i);
            this.d.addEventListener(listener);
        }
        this.i = listener;
        return this;
    }

    protected Parcelable onSaveInstanceState() {
        c c2 = new c(super.onSaveInstanceState());
        c2.a = (ArrayList)this.e.a;
        c2.b = this.c;
        return c2;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof c)) {
            super.onRestoreInstanceState(state);
            return;
        }
        c c2 = (c)state;
        super.onRestoreInstanceState(c2.getSuperState());
        this.e.a = c2.a;
        this.c = c2.b;
        this.setChatroomManager(this.d);
    }

    private void a() {
        this.l.animate().setDuration(100L).translationY((float)this.l.getHeight()).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                ChatroomOutputView.this.n = 2;
            }

            public void onAnimationEnd(Animator animation) {
                ChatroomOutputView.this.n = 1;
            }
        });
    }

    private void b() {
        this.l.animate().setDuration(200L).translationY(0.0f).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                ChatroomOutputView.this.n = 2;
            }

            public void onAnimationEnd(Animator animation) {
                ChatroomOutputView.this.n = 0;
                if (ViewCompat.isAttachedToWindow((View)ChatroomOutputView.this)) {
                    ChatroomOutputView.this.c();
                }
            }
        });
    }

    private void c() {
        if (this.n != 0) {
            return;
        }
        if (this.f.getAdapter().getItemCount() - 1 == ((LinearLayoutManager)this.f.getLayoutManager()).findLastCompletelyVisibleItemPosition()) {
            this.a();
        }
    }

    private void d() {
        if (this.n != 1) {
            return;
        }
        int n = this.f.getAdapter().getItemCount() - 1;
        int n2 = ((LinearLayoutManager)this.f.getLayoutManager()).findLastCompletelyVisibleItemPosition();
        if (n2 <= n - 2) {
            this.b();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        io.straas.android.sdk.messaging.ui.sticker.h.a();
    }

    private static class c
    extends AbsSavedState {
        ArrayList a;
        int b;
        public static final Parcelable.Creator<c> CREATOR = ParcelableCompat.newCreator((ParcelableCompatCreatorCallbacks)new ParcelableCompatCreatorCallbacks<c>(){

            public c a(Parcel parcel, ClassLoader classLoader) {
                return new c(parcel, classLoader);
            }

            public c[] a(int n) {
                return new c[n];
            }

            public /* synthetic */ Object[] newArray(int n) {
                return this.a(n);
            }

            public /* synthetic */ Object createFromParcel(Parcel parcel, ClassLoader classLoader) {
                return this.a(parcel, classLoader);
            }
        });

        c(Parcel parcel, ClassLoader classLoader) {
            super(parcel, classLoader);
            this.a = parcel.readArrayList(classLoader != null ? classLoader : Message.class.getClassLoader());
            this.b = parcel.readInt();
        }

        c(Parcelable parcelable) {
            super(parcelable);
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeList((List)this.a);
            dest.writeInt(this.b);
        }
    }

    private class b
    extends RecyclerView.OnScrollListener {
        int a;

        private b() {
        }

        public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
            super.onScrollStateChanged(recyclerView, newState);
            this.a = newState;
            int n = ((LinearLayoutManager)recyclerView.getLayoutManager()).findLastCompletelyVisibleItemPosition();
            ChatroomOutputView.this.b = n == recyclerView.getAdapter().getItemCount() - 1;
            ChatroomOutputView.this.c();
        }

        public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
            super.onScrolled(recyclerView, dx, dy);
            if (this.a != 0) {
                ChatroomOutputView.this.d();
            }
            if (dy == 0) {
                ChatroomOutputView.this.c();
            }
        }
    }

    private static class io.straas.android.sdk.messaging.ui.ChatroomOutputView$a
    extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
        List<Message> a = new ArrayList<Message>();
        private ChatroomOutputView b;
        private LayoutInflater c;

        io.straas.android.sdk.messaging.ui.ChatroomOutputView$a(ChatroomOutputView chatroomOutputView) {
            this.b = chatroomOutputView;
        }

        public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            if (this.c == null) {
                this.c = LayoutInflater.from((Context)new ContextThemeWrapper(parent.getContext(), R.style.ChatroomTheme));
            }
            return new b(this.c.inflate(R.layout.message_item, parent, false));
        }

        public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
            if (holder instanceof a) {
                this.b.a(false);
            } else if (holder instanceof b) {
                b b2 = (b)holder;
                ImageView imageView = b2.a();
                if (this.b.j) {
                    if (imageView.getVisibility() != 0) {
                        imageView.setVisibility(0);
                    }
                } else if (imageView.getVisibility() != 8) {
                    imageView.setVisibility(8);
                }
                Message message = this.a.get(position);
                io.straas.android.sdk.messaging.ui.c.b(b2.b(), message);
                if (imageView.getVisibility() == 0) {
                    io.straas.android.sdk.messaging.ui.c.a(imageView, message, io.straas.android.sdk.messaging.ui.c.a(this.b.getContext(), R.drawable.common_default_avatar));
                }
                io.straas.android.sdk.messaging.ui.c.a(b2.d(), message);
                io.straas.android.sdk.messaging.ui.c.a(b2.c(), message, this.b.k);
            }
        }

        public int getItemViewType(int position) {
            return 0;
        }

        public int getItemCount() {
            return this.a.size();
        }

        boolean a(Message message) {
            int n = this.a.size();
            this.a.add(n, message);
            this.notifyItemInserted(n);
            if (this.b.b || message.getCreator().equals((Object)this.b.getChatroomManager().getCurrentUser())) {
                this.b();
                return true;
            }
            return false;
        }

        void a(Message[] messageArray, boolean bl) {
            this.a.addAll(0, Arrays.asList(messageArray));
            Collections.sort(this.a, new Comparator<Message>(){

                public int a(Message message, Message message2) {
                    return a.this.a(message, message2);
                }

                @Override
                public /* synthetic */ int compare(Object object, Object object2) {
                    return this.a((Message)object, (Message)object2);
                }
            });
            this.notifyItemRangeInserted(0, messageArray.length);
            if (bl) {
                this.b();
            }
        }

        private int a(Message message, Message message2) {
            long l;
            long l2 = message.getCreatedDate();
            if (l2 > (l = message2.getCreatedDate())) {
                return 1;
            }
            if (l2 < l) {
                return -1;
            }
            return 0;
        }

        private void b() {
            this.b.f.scrollToPosition(this.getItemCount() - 1);
            this.b.b = true;
        }

        boolean b(Message message) {
            if (this.a.contains(message)) {
                int n = this.a.indexOf(message);
                if (this.a.remove(message)) {
                    this.notifyItemRemoved(n);
                    return true;
                }
            }
            return false;
        }

        void a() {
            int n = this.a.size();
            this.a.clear();
            this.notifyItemRangeRemoved(0, n);
        }

        private class a
        extends RecyclerView.ViewHolder {
        }

        private class b
        extends RecyclerView.ViewHolder {
            private ImageView b;
            private TextView c;
            private TextView d;
            private TextView e;

            b(View view) {
                super(view);
                this.b = (ImageView)iKalaUtils.getView((View)view, (int)R.id.avatar);
                this.c = (TextView)iKalaUtils.getView((View)view, (int)R.id.nickName);
                this.d = (TextView)iKalaUtils.getView((View)view, (int)R.id.time);
                this.e = (TextView)iKalaUtils.getView((View)view, (int)R.id.message);
            }

            public ImageView a() {
                return this.b;
            }

            public TextView b() {
                return this.c;
            }

            public TextView c() {
                return this.d;
            }

            public TextView d() {
                return this.e;
            }
        }
    }
}

