/*
 * Decompiled with CFR 0.152.
 */
package io.straas.android.sdk.messaging.ui;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.TypedArray;
import android.os.CountDownTimer;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.support.v4.os.ParcelableCompat;
import android.support.v4.os.ParcelableCompatCreatorCallbacks;
import android.support.v4.util.SimpleArrayMap;
import android.support.v4.view.AbsSavedState;
import android.support.v4.widget.TextViewCompat;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.AppCompatEditText;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import android.view.ContextThemeWrapper;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import io.straas.android.sdk.base.interfaces.OnResultListener;
import io.straas.android.sdk.messaging.ChatMode;
import io.straas.android.sdk.messaging.ChatroomManager;
import io.straas.android.sdk.messaging.ChatroomState;
import io.straas.android.sdk.messaging.Message;
import io.straas.android.sdk.messaging.MessagingException;
import io.straas.android.sdk.messaging.Role;
import io.straas.android.sdk.messaging.User;
import io.straas.android.sdk.messaging.interfaces.EventListener;
import io.straas.android.sdk.messaging.ui.R;
import io.straas.android.sdk.messaging.ui.interfaces.SignInListener;
import io.straas.android.sdk.messaging.ui.sticker.panel.d;
import io.straas.android.sdk.messaging.ui.sticker.panel.e;
import java.util.List;

public class ChatroomInputView
extends FrameLayout
implements d.a {
    private static final String a = ChatroomInputView.class.getSimpleName();
    private int b;
    private ChatMode c;
    private User d;
    private OnCompleteListener<Void> e;
    private SignInListener f;
    private View g;
    private View h;
    private EditText i;
    private FragmentActivity j;
    private ChatroomManager k;
    private e l;
    private View.OnTouchListener m;
    private boolean n;
    private View.OnTouchListener o = new View.OnTouchListener(){

        public boolean onTouch(View v, MotionEvent event) {
            if (event.getAction() == 0 && ChatroomInputView.this.d.isGuest()) {
                switch (ChatroomInputView.this.c) {
                    case ALL: {
                        if (ChatroomInputView.this.n) break;
                        ChatroomInputView.this.b();
                        return true;
                    }
                    case LOGIN: 
                    case ANCHOR: {
                        if (ChatroomInputView.this.f != null) {
                            ChatroomInputView.this.f.signIn();
                        }
                        return true;
                    }
                }
            }
            return ChatroomInputView.this.m != null && ChatroomInputView.this.m.onTouch((View)ChatroomInputView.this, event) || v.onTouchEvent(event);
        }
    };
    private EventListener p = new EventListener(){

        public void onConnected() {
            ChatroomInputView.this.d = ChatroomInputView.this.k.getCurrentUser();
            ChatroomInputView.this.c = ChatroomInputView.this.k.getChatMode();
            ChatroomInputView.this.a();
            if (ChatroomInputView.this.j != null) {
                ChatroomInputView.this.setBtnStickerVisible(true);
            }
        }

        public void onConnectFailed(Exception error) {
        }

        public void onError(Exception error) {
        }

        public void onDisconnected() {
        }

        public void onMessageAdded(Message message) {
        }

        public void onMessageRemoved(String messageId) {
        }

        public void onAggregatedDataAdded(SimpleArrayMap<String, Integer> map) {
        }

        public void onRawDataAdded(Message message) {
        }

        public void onMessageFlushed() {
        }

        public void onUserJoined(User[] users) {
        }

        public void onUserUpdated(User[] users) {
            for (User user : users) {
                if (!user.getLabel().equals(ChatroomInputView.this.d.getLabel())) continue;
                ChatroomInputView.this.d = user;
                ChatroomInputView.this.a();
            }
        }

        public void onUserLeft(Integer[] userLabels) {
        }

        public void userCount(int userCount) {
        }

        public void onChatWriteModeChanged(ChatMode chatMode) {
            ChatroomInputView.this.c = chatMode;
            ChatroomInputView.this.a();
        }

        public void onInputIntervalChanged(int inputInterval) {
        }

        public void onPinnedMessageUpdated(@Nullable Message pinnedMessage) {
        }
    };

    public ChatroomInputView(Context context) {
        this(context, null);
    }

    public ChatroomInputView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ChatroomInputView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.a(attrs);
    }

    private void a(AttributeSet attributeSet) {
        ContextThemeWrapper contextThemeWrapper = new ContextThemeWrapper(this.getContext(), R.style.ChatroomTheme);
        ViewGroup viewGroup = (ViewGroup)LayoutInflater.from((Context)contextThemeWrapper).inflate(R.layout.chatroom_input_layout, (ViewGroup)this, false);
        TypedValue typedValue = new TypedValue();
        this.getContext().getTheme().resolveAttribute(R.attr.dialogPreferredPadding, typedValue, true);
        this.b = this.getResources().getDimensionPixelSize(typedValue.resourceId);
        this.addView((View)viewGroup);
        TypedArray typedArray = contextThemeWrapper.obtainStyledAttributes(attributeSet, R.styleable.Chatroom, 0, R.style.ChatroomTheme);
        io.straas.android.sdk.messaging.ui.sticker.panel.preference.c.a(this.getContext());
        Activity activity = io.straas.android.sdk.messaging.ui.c.a((View)viewGroup);
        if (activity instanceof FragmentActivity) {
            this.j = (FragmentActivity)activity;
        }
        this.i = (EditText)io.straas.android.sdk.messaging.ui.c.a((View)viewGroup, R.id.inputEditText);
        int n = typedArray.getInt(R.styleable.Chatroom_inputMaxLines, 4);
        this.setInputMaxLines(n);
        this.i.setOnTouchListener(this.o);
        this.i.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                if (actionId == v.getImeOptions()) {
                    CharSequence charSequence = v.getText();
                    if (TextUtils.isEmpty((CharSequence)charSequence)) {
                        return false;
                    }
                    ChatroomInputView.this.sendMessage(charSequence.toString());
                    return true;
                }
                return false;
            }
        });
        this.i.addTextChangedListener((TextWatcher)new a(){

            public void afterTextChanged(Editable s) {
                if (s.length() != 0) {
                    if (!ChatroomInputView.this.g.isEnabled()) {
                        ChatroomInputView.this.setSendButton(true);
                    }
                    String string2 = s.toString().replaceAll("\\n", " ");
                    if (!TextUtils.equals((CharSequence)s.toString(), (CharSequence)string2)) {
                        int n = ChatroomInputView.this.i.getSelectionEnd();
                        ChatroomInputView.this.i.setText((CharSequence)string2);
                        ChatroomInputView.this.i.setSelection(n);
                    }
                } else if (ChatroomInputView.this.g.isEnabled()) {
                    ChatroomInputView.this.setSendButton(false);
                }
            }
        });
        this.g = io.straas.android.sdk.messaging.ui.c.a((View)viewGroup, R.id.btnSend);
        this.g.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                String string2 = ChatroomInputView.this.i.getText().toString();
                ChatroomInputView.this.sendMessage(string2);
            }
        });
        this.h = io.straas.android.sdk.messaging.ui.c.a((View)viewGroup, R.id.btnSticker);
        this.h.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (ChatroomInputView.this.d.isGuest()) {
                    switch (ChatroomInputView.this.c) {
                        case ALL: {
                            if (ChatroomInputView.this.n) break;
                            ChatroomInputView.this.b();
                            return;
                        }
                        case LOGIN: 
                        case ANCHOR: {
                            if (ChatroomInputView.this.f == null) break;
                            ChatroomInputView.this.f.signIn();
                        }
                    }
                }
                ChatroomInputView.this.c();
            }
        });
        this.setChatroomManager(this.k);
        typedArray.recycle();
    }

    public void setOnTouchListener(View.OnTouchListener l) {
        this.m = l;
    }

    public void sendMessage(String message) {
        Task<Void> task = this.a(message);
        if (this.e != null) {
            task.addOnCompleteListener(this.e);
        }
    }

    public ChatroomInputView setInputMaxLines(int maxLines) {
        if (maxLines < 1) {
            throw new IllegalArgumentException("Must larger than 1.");
        }
        if (maxLines == 1) {
            this.i.setInputType(64);
        } else {
            this.i.setInputType(131137);
        }
        this.i.setMaxLines(maxLines);
        return this;
    }

    public int getInputMaxLines() {
        return TextViewCompat.getMaxLines((TextView)this.i);
    }

    private Task<Void> a(String string2) {
        if (this.k == null) {
            Log.w((String)a, (String)"Chatroom is not connected. Please call connect function first.");
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException((Throwable)new IllegalStateException("Chatroom is not connected. Please call connect function first.")));
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException((Throwable)new IllegalArgumentException("Message is empty, say something please.")));
        }
        if (!this.i.isEnabled()) {
            Log.w((String)a, (String)"Current user can't talk in this mode");
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException((Throwable)new IllegalStateException("Input is disabled.")));
        }
        io.straas.android.sdk.messaging.ui.c.a(this.getContext(), this.getWindowToken());
        OnSuccessListener<Void> onSuccessListener = new OnSuccessListener<Void>(){

            public void a(Void void_) {
                if (!TextUtils.isEmpty((CharSequence)ChatroomInputView.this.i.getText().toString())) {
                    ChatroomInputView.this.i.setText((CharSequence)"");
                    ChatroomInputView.this.i.clearFocus();
                }
                ChatroomInputView.this.a(ChatroomInputView.this.k.getSendMessageInterval());
            }

            public /* synthetic */ void onSuccess(Object object) {
                this.a((Void)object);
            }
        };
        if (this.k.getCurrentUser().getRole() != Role.BLOCKED) {
            return this.k.sendMessage(string2).addOnSuccessListener((OnSuccessListener)onSuccessListener);
        }
        onSuccessListener.onSuccess(null);
        this.k.addFakeMessage(new Message.Builder("").buildCreator(this.k.getCurrentUser()).buildText(string2).buildCreatedDate(System.currentTimeMillis()).build());
        return Tasks.forResult(null);
    }

    public void setChatroomManager(@NonNull ChatroomManager chatroomManager) {
        if (chatroomManager == null) {
            return;
        }
        if (this.k != null) {
            this.k.removeEventListener(this.p);
        }
        this.k = chatroomManager;
        this.k.addEventListener(this.p);
        if (this.k.getChatroomState() == ChatroomState.CONNECTED) {
            this.p.onConnected();
        }
    }

    private void a(boolean bl, String string2) {
        this.setSendButton(bl && !TextUtils.isEmpty((CharSequence)this.i.getText()));
        this.i.setHint((CharSequence)string2);
        if (!bl) {
            this.i.clearFocus();
        }
    }

    private void setSendButton(boolean enable) {
        this.g.setEnabled(enable);
        this.g.setAlpha(enable ? 1.0f : 0.3f);
    }

    protected Parcelable onSaveInstanceState() {
        b b2 = new b(super.onSaveInstanceState());
        b2.a = this.n;
        return b2;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof b)) {
            super.onRestoreInstanceState(state);
            return;
        }
        b b2 = (b)state;
        super.onRestoreInstanceState(b2.getSuperState());
        this.n = b2.a;
        this.setChatroomManager(this.k);
    }

    private void a() {
        switch (this.c) {
            case LOGIN: {
                if (!this.d.isGuest()) break;
                this.a(false, this.getResources().getString(R.string.plz_signin));
                this.i.setEnabled(true);
                return;
            }
            case ANCHOR: {
                Role role = this.d.getRole();
                if (role != Role.NORMAL && role != Role.BLOCKED && role != Role.UNKNOWN) break;
                this.a(false, this.getResources().getString(R.string.anchor_chat_mode));
                this.i.setEnabled(this.d.isGuest());
                return;
            }
        }
        this.a(true, this.a(this.d));
        this.i.setEnabled(true);
    }

    private void setBtnStickerVisible(boolean visible) {
        this.h.setVisibility(visible ? 0 : 8);
    }

    private void a(int n) {
        if (n <= 0) {
            return;
        }
        c c2 = new c((long)n * 1000L, 500L);
        c2.a();
    }

    private String a(User user) {
        if (user.isGuest() && this.n) {
            return String.format(this.getResources().getString(R.string.input_hint_guest), user.getName());
        }
        return this.getResources().getString(R.string.input_hint);
    }

    private void b(String string2) {
        OnResultListener<Void, Exception> onResultListener = new OnResultListener<Void, Exception>(){

            public void a(Void void_) {
                ChatroomInputView.this.n = true;
                ChatroomInputView.this.p.onUserUpdated(new User[]{ChatroomInputView.this.k.getCurrentUser()});
            }

            public void a(Exception exception) {
                Toast.makeText((Context)ChatroomInputView.this.getContext(), (CharSequence)ChatroomInputView.this.getResources().getString(R.string.update_nickname_fail), (int)1).show();
            }

            public /* synthetic */ void onFailure(Object object) {
                this.a((Exception)object);
            }

            public /* synthetic */ void onSuccess(Object object) {
                this.a((Void)object);
            }
        };
        if (this.d.getRole() != Role.BLOCKED) {
            this.k.updateNickname(string2).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<Void>((OnResultListener)onResultListener){
                final /* synthetic */ OnResultListener a;
                {
                    this.a = onResultListener;
                }

                public void a(Void void_) {
                    this.a.onSuccess((Object)void_);
                }

                public /* synthetic */ void onSuccess(Object object) {
                    this.a((Void)object);
                }
            }).addOnFailureListener(new OnFailureListener((OnResultListener)onResultListener){
                final /* synthetic */ OnResultListener a;
                {
                    this.a = onResultListener;
                }

                public void onFailure(@NonNull Exception e2) {
                    this.a.onFailure((Object)e2);
                }
            });
        } else {
            this.d.setName(string2);
            onResultListener.onSuccess(null);
        }
    }

    private void b() {
        AlertDialog.Builder builder = new AlertDialog.Builder(this.getContext());
        builder.setTitle((CharSequence)this.getResources().getString(R.string.enter_nickname));
        AppCompatEditText appCompatEditText = new AppCompatEditText(this.getContext());
        InputFilter[] inputFilterArray = new InputFilter[]{new InputFilter.LengthFilter(15)};
        appCompatEditText.setFilters(inputFilterArray);
        appCompatEditText.setInputType(64);
        appCompatEditText.setImeOptions(6);
        builder.setPositiveButton((CharSequence)this.getResources().getString(R.string.common_confirm), null);
        builder.setNegativeButton((CharSequence)this.getResources().getString(R.string.common_cancel), null);
        final AlertDialog alertDialog = builder.create();
        alertDialog.getWindow().setSoftInputMode(5);
        alertDialog.setView((View)appCompatEditText, this.b, this.b, this.b, 0);
        alertDialog.setOnShowListener(new DialogInterface.OnShowListener((EditText)appCompatEditText){
            final /* synthetic */ EditText b;
            {
                this.b = editText;
            }

            public void onShow(DialogInterface dialog) {
                final Button button = alertDialog.getButton(-1);
                Button button2 = alertDialog.getButton(-2);
                button.setEnabled(false);
                this.b.setOnEditorActionListener(new TextView.OnEditorActionListener(){

                    public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                        if (actionId == v.getImeOptions()) {
                            ChatroomInputView.this.b(b.getText().toString());
                            alertDialog.dismiss();
                        }
                        return false;
                    }
                });
                this.b.addTextChangedListener((TextWatcher)new a(){

                    public void afterTextChanged(Editable s) {
                        button.setEnabled(s.length() != 0);
                    }
                });
                button.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        ChatroomInputView.this.b(b.getText().toString());
                        alertDialog.dismiss();
                    }
                });
                button2.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        alertDialog.dismiss();
                    }
                });
            }
        });
        alertDialog.show();
    }

    public void setSendMessageListener(OnCompleteListener<Void> listener) {
        this.e = listener;
    }

    public void setSignInListener(SignInListener listener) {
        this.f = listener;
    }

    private void c() {
        List list = this.k.getSticker();
        if (list == null) {
            return;
        }
        if (this.l == null) {
            this.l = new e(list);
        }
        d d2 = new d();
        d2.a(this.k.getSticker());
        d2.a(this.l);
        d2.a(this);
        d2.show(this.j.getSupportFragmentManager(), d2.getTag());
    }

    @Override
    public void onStickerMessage(String message) {
        this.sendMessage(message);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.l != null) {
            this.l.c();
        }
    }

    private static class b
    extends AbsSavedState {
        boolean a;
        public static final Parcelable.Creator<b> CREATOR = ParcelableCompat.newCreator((ParcelableCompatCreatorCallbacks)new ParcelableCompatCreatorCallbacks<b>(){

            public b a(Parcel parcel, ClassLoader classLoader) {
                return new b(parcel, classLoader);
            }

            public b[] a(int n) {
                return new b[n];
            }

            public /* synthetic */ Object[] newArray(int n) {
                return this.a(n);
            }

            public /* synthetic */ Object createFromParcel(Parcel parcel, ClassLoader classLoader) {
                return this.a(parcel, classLoader);
            }
        });

        b(Parcel parcel, ClassLoader classLoader) {
            super(parcel, classLoader);
            this.a = parcel.readByte() != 0;
        }

        b(Parcelable parcelable) {
            super(parcelable);
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeByte((byte)(this.a ? 1 : 0));
        }
    }

    private static abstract class a
    implements TextWatcher {
        private a() {
        }

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
        }
    }

    private class c
    extends CountDownTimer {
        private long b;

        c(long l, long l2) {
            super(l, l2);
            this.b = l;
        }

        CountDownTimer a() {
            ChatroomInputView.this.a(false, ChatroomInputView.this.getResources().getString(R.string.send_msg_time_left_android, new Object[]{this.b / 1000L + 1L}));
            ChatroomInputView.this.i.setEnabled(false);
            return super.start();
        }

        public void onTick(long millisUntilFinished) {
            ChatroomInputView.this.a(false, ChatroomInputView.this.getResources().getString(R.string.send_msg_time_left_android, new Object[]{millisUntilFinished / 1000L + 1L}));
        }

        public void onFinish() {
            ChatroomInputView.this.a(true, ChatroomInputView.this.a(ChatroomInputView.this.d));
            ChatroomInputView.this.i.setEnabled(true);
        }
    }
}

