/*
 * Decompiled with CFR 0.152.
 */
package io.straas.android.sdk.messaging.ui;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.os.CountDownTimer;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentActivity;
import android.support.v4.os.ParcelableCompat;
import android.support.v4.os.ParcelableCompatCreatorCallbacks;
import android.support.v4.view.AbsSavedState;
import android.support.v7.app.AlertDialog;
import android.support.v7.view.ContextThemeWrapper;
import android.support.v7.widget.AppCompatEditText;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.Button;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.ikala.android.utils.iKalaUtils;
import io.straas.android.sdk.base.interfaces.OnResultListener;
import io.straas.android.sdk.messaging.ChatMode;
import io.straas.android.sdk.messaging.ChatroomManager;
import io.straas.android.sdk.messaging.ChatroomState;
import io.straas.android.sdk.messaging.Message;
import io.straas.android.sdk.messaging.MessagingError;
import io.straas.android.sdk.messaging.Role;
import io.straas.android.sdk.messaging.User;
import io.straas.android.sdk.messaging.interfaces.EventListener;
import io.straas.android.sdk.messaging.ui.R;
import io.straas.android.sdk.messaging.ui.interfaces.SignInListener;
import io.straas.android.sdk.messaging.ui.sticker.panel.d;
import io.straas.android.sdk.messaging.ui.sticker.panel.e;

public class ChatroomInputView
extends FrameLayout
implements d.a {
    private static final String a = ChatroomInputView.class.getSimpleName();
    private int b;
    private ChatMode c;
    private User d;
    private OnResultListener<Void, MessagingError> e;
    private SignInListener f;
    private View g;
    private View h;
    private TextView i;
    private FragmentActivity j;
    private ChatroomManager k;
    private e l;
    private View.OnTouchListener m;
    private boolean n;
    private View.OnTouchListener o = new View.OnTouchListener(){

        public boolean onTouch(View view, MotionEvent motionEvent) {
            if (motionEvent.getAction() == 0 && ChatroomInputView.this.d.isGuest()) {
                switch (ChatroomInputView.this.c) {
                    case ALL: {
                        if (ChatroomInputView.this.n) break;
                        ChatroomInputView.this.b();
                        return true;
                    }
                    case LOGIN: 
                    case ANCHOR: {
                        if (ChatroomInputView.this.f != null) {
                            ChatroomInputView.this.f.signIn();
                        }
                        return true;
                    }
                }
            }
            return ChatroomInputView.this.m != null && ChatroomInputView.this.m.onTouch((View)ChatroomInputView.this, motionEvent) || view.onTouchEvent(motionEvent);
        }
    };
    private EventListener p = new EventListener(){

        public void onConnected() {
            ChatroomInputView.this.d = ChatroomInputView.this.k.getCurrentUser();
            ChatroomInputView.this.c = ChatroomInputView.this.k.getChatMode();
            ChatroomInputView.this.a();
            if (ChatroomInputView.this.j != null) {
                ChatroomInputView.this.setBtnStickerVisible(true);
            }
        }

        public void onConnectFailed(MessagingError messagingError) {
        }

        public void onError(MessagingError messagingError) {
        }

        public void onDisconnected() {
        }

        public void onMessageAdded(Message message) {
        }

        public void onMessageRemoved(String string2) {
        }

        public void onMessageFlushed() {
        }

        public void onUserJoined(User[] userArray) {
        }

        public void onUserUpdated(User[] userArray) {
            for (User user : userArray) {
                if (!user.getLabel().equals(ChatroomInputView.this.d.getLabel())) continue;
                ChatroomInputView.this.d = user;
                ChatroomInputView.this.a();
            }
        }

        public void onUserLeft(Integer[] integerArray) {
        }

        public void userCount(int n) {
        }

        public void onChatWriteModeChanged(ChatMode chatMode) {
            ChatroomInputView.this.c = chatMode;
            ChatroomInputView.this.a();
        }

        public void onInputIntervalChanged(int n) {
        }
    };

    public ChatroomInputView(Context context) {
        this(context, null);
    }

    public ChatroomInputView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public ChatroomInputView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.a(attributeSet);
    }

    private void a(AttributeSet attributeSet) {
        ContextThemeWrapper contextThemeWrapper = new ContextThemeWrapper(this.getContext(), R.style.ChatroomTheme);
        ViewGroup viewGroup = (ViewGroup)LayoutInflater.from((Context)contextThemeWrapper).inflate(R.layout.chatroom_input_layout, (ViewGroup)this, false);
        TypedValue typedValue = new TypedValue();
        this.getContext().getTheme().resolveAttribute(R.attr.dialogPreferredPadding, typedValue, true);
        this.b = this.getResources().getDimensionPixelSize(typedValue.resourceId);
        this.addView((View)viewGroup);
        io.straas.android.sdk.messaging.ui.sticker.panel.preference.c.a(this.getContext());
        Activity activity = iKalaUtils.getActivity((View)viewGroup);
        if (activity instanceof FragmentActivity) {
            this.j = (FragmentActivity)activity;
        }
        this.i = (TextView)iKalaUtils.getView((View)viewGroup, (int)R.id.inputEditText);
        this.i.setOnTouchListener(this.o);
        this.i.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView textView, int n, KeyEvent keyEvent) {
                if (n == textView.getImeOptions()) {
                    CharSequence charSequence = textView.getText();
                    if (TextUtils.isEmpty((CharSequence)charSequence)) {
                        return false;
                    }
                    ChatroomInputView.this.sendMessage(charSequence.toString());
                    return true;
                }
                return false;
            }
        });
        this.i.addTextChangedListener((TextWatcher)new a(){

            public void afterTextChanged(Editable editable) {
                if (editable.length() != 0) {
                    if (!ChatroomInputView.this.g.isEnabled()) {
                        ChatroomInputView.this.setSendButton(true);
                    }
                } else if (ChatroomInputView.this.g.isEnabled()) {
                    ChatroomInputView.this.setSendButton(false);
                }
            }
        });
        this.g = iKalaUtils.getView((View)viewGroup, (int)R.id.btnSend);
        this.g.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                String string2 = ChatroomInputView.this.i.getText().toString();
                ChatroomInputView.this.sendMessage(string2);
            }
        });
        this.h = iKalaUtils.getView((View)viewGroup, (int)R.id.btnSticker);
        this.h.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (ChatroomInputView.this.d.isGuest()) {
                    switch (ChatroomInputView.this.c) {
                        case ALL: {
                            if (ChatroomInputView.this.n) break;
                            ChatroomInputView.this.b();
                            return;
                        }
                        case LOGIN: 
                        case ANCHOR: {
                            if (ChatroomInputView.this.f == null) break;
                            ChatroomInputView.this.f.signIn();
                        }
                    }
                }
                ChatroomInputView.this.c();
            }
        });
        this.setBtnStickerVisible(false);
        this.setChatroomManager(this.k);
    }

    public void setOnTouchListener(View.OnTouchListener onTouchListener) {
        this.m = onTouchListener;
    }

    public void sendMessage(String string2) {
        if (this.k == null) {
            Log.w((String)a, (String)"Chatroom is not connected. Please call connect function first.");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        if (!this.i.isEnabled()) {
            Log.w((String)a, (String)"Current user can't talk in this mode");
            return;
        }
        iKalaUtils.hideKeyboard((Context)this.getContext(), (IBinder)this.getWindowToken());
        OnResultListener<Void, MessagingError> onResultListener = new OnResultListener<Void, MessagingError>(){

            public void a(Void void_) {
                if (!TextUtils.isEmpty((CharSequence)ChatroomInputView.this.i.getText().toString())) {
                    ChatroomInputView.this.i.setText((CharSequence)"");
                    ChatroomInputView.this.i.clearFocus();
                }
                ChatroomInputView.this.a(ChatroomInputView.this.k.getSendMessageInterval());
                if (ChatroomInputView.this.e != null) {
                    ChatroomInputView.this.e.onSuccess((Object)void_);
                }
            }

            public void a(MessagingError messagingError) {
                if (ChatroomInputView.this.e != null) {
                    ChatroomInputView.this.e.onFailure((Object)messagingError);
                }
            }

            public /* synthetic */ void onFailure(Object object) {
                this.a((MessagingError)object);
            }

            public /* synthetic */ void onSuccess(Object object) {
                this.a((Void)object);
            }
        };
        if (this.k.getCurrentUser().getRole() != Role.BLOCKED) {
            this.k.sendMessage(string2, (OnResultListener)onResultListener);
        } else {
            onResultListener.onSuccess(null);
            this.k.addFakeMessage(new Message.Builder("").buildCreator(this.k.getCurrentUser()).buildText(string2).buildCreatedDate(System.currentTimeMillis()).build());
        }
    }

    public void setChatroomManager(@NonNull ChatroomManager chatroomManager) {
        if (chatroomManager == null) {
            return;
        }
        if (this.k != null) {
            this.k.removeEventListener(this.p);
        }
        this.k = chatroomManager;
        this.k.addEventListener(this.p);
        if (this.k.getChatroomState() == ChatroomState.CONNECTED) {
            this.p.onConnected();
        }
    }

    private void a(boolean bl, String string2) {
        this.setSendButton(bl && !TextUtils.isEmpty((CharSequence)this.i.getText()));
        this.i.setHint((CharSequence)string2);
        if (!bl) {
            this.i.clearFocus();
        }
    }

    private void setSendButton(boolean bl) {
        this.g.setEnabled(bl);
        this.g.setAlpha(bl ? 1.0f : 0.3f);
    }

    protected Parcelable onSaveInstanceState() {
        b b2 = new b(super.onSaveInstanceState());
        b2.a = this.n;
        return b2;
    }

    protected void onRestoreInstanceState(Parcelable parcelable) {
        if (!(parcelable instanceof b)) {
            super.onRestoreInstanceState(parcelable);
            return;
        }
        b b2 = (b)parcelable;
        super.onRestoreInstanceState(b2.getSuperState());
        this.n = b2.a;
        this.setChatroomManager(this.k);
    }

    private void a() {
        switch (this.c) {
            case LOGIN: {
                if (!this.d.isGuest()) break;
                this.a(false, this.getResources().getString(R.string.plz_signin));
                this.i.setEnabled(true);
                return;
            }
            case ANCHOR: {
                Role role = this.d.getRole();
                if (role != Role.NORMAL && role != Role.BLOCKED && role != Role.UNKNOWN) break;
                this.a(false, this.getResources().getString(R.string.anchor_chat_mode));
                this.i.setEnabled(this.d.isGuest());
                return;
            }
        }
        this.a(true, this.a(this.d));
        this.i.setEnabled(true);
    }

    private void setBtnStickerVisible(boolean bl) {
        this.h.setVisibility(bl ? 0 : 8);
    }

    private void a(int n) {
        if (n <= 0) {
            return;
        }
        c c2 = new c((long)n * 1000L, 500L);
        c2.a();
    }

    private String a(User user) {
        if (user.isGuest() && this.n) {
            return String.format(this.getResources().getString(R.string.input_hint_guest), user.getName());
        }
        return this.getResources().getString(R.string.input_hint);
    }

    private void a(String string2) {
        OnResultListener<Void, MessagingError> onResultListener = new OnResultListener<Void, MessagingError>(){

            public void a(Void void_) {
                ChatroomInputView.this.n = true;
                ChatroomInputView.this.p.onUserUpdated(new User[]{ChatroomInputView.this.k.getCurrentUser()});
            }

            public void a(MessagingError messagingError) {
                Toast.makeText((Context)ChatroomInputView.this.getContext(), (CharSequence)ChatroomInputView.this.getResources().getString(R.string.update_nickname_fail), (int)1).show();
            }

            public /* synthetic */ void onFailure(Object object) {
                this.a((MessagingError)object);
            }

            public /* synthetic */ void onSuccess(Object object) {
                this.a((Void)object);
            }
        };
        if (this.d.getRole() != Role.BLOCKED) {
            this.k.updateNickname(string2, (OnResultListener)onResultListener);
        } else {
            this.d.setName(string2);
            onResultListener.onSuccess(null);
        }
    }

    private void b() {
        AlertDialog.Builder builder = new AlertDialog.Builder(this.getContext());
        builder.setTitle((CharSequence)this.getResources().getString(R.string.enter_nickname));
        AppCompatEditText appCompatEditText = new AppCompatEditText(this.getContext());
        InputFilter[] inputFilterArray = new InputFilter[]{new InputFilter.LengthFilter(15)};
        appCompatEditText.setFilters(inputFilterArray);
        appCompatEditText.setInputType(64);
        appCompatEditText.setImeOptions(6);
        builder.setPositiveButton((CharSequence)this.getResources().getString(R.string.common_confirm), null);
        builder.setNegativeButton((CharSequence)this.getResources().getString(R.string.common_cancel), null);
        final AlertDialog alertDialog = builder.create();
        iKalaUtils.showKeyboard((Window)alertDialog.getWindow());
        alertDialog.setView((View)appCompatEditText, this.b, this.b, this.b, 0);
        alertDialog.setOnShowListener(new DialogInterface.OnShowListener((EditText)appCompatEditText){
            final /* synthetic */ EditText b;
            {
                this.b = editText;
            }

            public void onShow(DialogInterface dialogInterface) {
                final Button button = alertDialog.getButton(-1);
                Button button2 = alertDialog.getButton(-2);
                button.setEnabled(false);
                this.b.setOnEditorActionListener(new TextView.OnEditorActionListener(){

                    public boolean onEditorAction(TextView textView, int n, KeyEvent keyEvent) {
                        if (n == textView.getImeOptions()) {
                            ChatroomInputView.this.a(b.getText().toString());
                            alertDialog.dismiss();
                        }
                        return false;
                    }
                });
                this.b.addTextChangedListener((TextWatcher)new a(){

                    public void afterTextChanged(Editable editable) {
                        button.setEnabled(editable.length() != 0);
                    }
                });
                button.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        ChatroomInputView.this.a(b.getText().toString());
                        alertDialog.dismiss();
                    }
                });
                button2.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        alertDialog.dismiss();
                    }
                });
            }
        });
        alertDialog.show();
    }

    public void setSendMessageListener(OnResultListener<Void, MessagingError> onResultListener) {
        this.e = onResultListener;
    }

    public void setSignInListener(SignInListener signInListener) {
        this.f = signInListener;
    }

    private void c() {
        if (this.l == null) {
            this.l = new e(this.k.getSticker());
        }
        d d2 = new d();
        d2.a(this.k.getSticker());
        d2.a(this.l);
        d2.a(this);
        d2.show(this.j.getSupportFragmentManager(), d2.getTag());
    }

    @Override
    public void onStickerMessage(String string2) {
        this.sendMessage(string2);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.l != null) {
            this.l.c();
        }
    }

    private static class b
    extends AbsSavedState {
        boolean a;
        public static final Parcelable.Creator<b> CREATOR = ParcelableCompat.newCreator((ParcelableCompatCreatorCallbacks)new ParcelableCompatCreatorCallbacks<b>(){

            public b a(Parcel parcel, ClassLoader classLoader) {
                return new b(parcel, classLoader);
            }

            public b[] a(int n) {
                return new b[n];
            }

            public /* synthetic */ Object[] newArray(int n) {
                return this.a(n);
            }

            public /* synthetic */ Object createFromParcel(Parcel parcel, ClassLoader classLoader) {
                return this.a(parcel, classLoader);
            }
        });

        b(Parcel parcel, ClassLoader classLoader) {
            super(parcel, classLoader);
            this.a = parcel.readByte() != 0;
        }

        b(Parcelable parcelable) {
            super(parcelable);
        }

        public void writeToParcel(Parcel parcel, int n) {
            super.writeToParcel(parcel, n);
            parcel.writeByte((byte)(this.a ? 1 : 0));
        }
    }

    private static abstract class a
    implements TextWatcher {
        private a() {
        }

        public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        }

        public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        }
    }

    private class c
    extends CountDownTimer {
        private long b;

        c(long l, long l2) {
            super(l, l2);
            this.b = l;
        }

        CountDownTimer a() {
            ChatroomInputView.this.a(false, ChatroomInputView.this.getResources().getString(R.string.send_msg_time_left_android, new Object[]{this.b / 1000L + 1L}));
            ChatroomInputView.this.i.setEnabled(false);
            return super.start();
        }

        public void onTick(long l) {
            ChatroomInputView.this.a(false, ChatroomInputView.this.getResources().getString(R.string.send_msg_time_left_android, new Object[]{l / 1000L + 1L}));
        }

        public void onFinish() {
            ChatroomInputView.this.a(true, ChatroomInputView.this.a(ChatroomInputView.this.d));
            ChatroomInputView.this.i.setEnabled(true);
        }
    }
}

