/*
 * Decompiled with CFR 0.152.
 */
package io.straas.android.sdk.messaging.ui;

import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.CountDownTimer;
import android.os.IBinder;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.graphics.drawable.VectorDrawableCompat;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AlertDialog;
import android.support.v7.view.ContextThemeWrapper;
import android.support.v7.widget.AppCompatEditText;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.Button;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import com.ikala.android.utils.iKalaUtils;
import io.straas.android.sdk.base.credential.CredentialFailReason;
import io.straas.android.sdk.base.identity.Identity;
import io.straas.android.sdk.base.interfaces.OnResultListener;
import io.straas.android.sdk.messaging.ChatMode;
import io.straas.android.sdk.messaging.ChatroomManager;
import io.straas.android.sdk.messaging.ChatroomState;
import io.straas.android.sdk.messaging.Message;
import io.straas.android.sdk.messaging.MessagingError;
import io.straas.android.sdk.messaging.User;
import io.straas.android.sdk.messaging.interfaces.EventListener;
import io.straas.android.sdk.messaging.ui.ChatroomInputView;
import io.straas.android.sdk.messaging.ui.R;
import io.straas.android.sdk.messaging.ui.a.h;
import io.straas.android.sdk.messaging.ui.interfaces.CredentialAuthorizeListener;
import io.straas.android.sdk.messaging.ui.interfaces.SignInListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public final class ChatroomOutputView
extends FrameLayout {
    private static final String a = ChatroomOutputView.class.getSimpleName();
    private boolean b = false;
    private int c = 0;
    private ChatroomManager d;
    private a e;
    private RecyclerView f;
    private View g;
    private View h;
    private TextView i;
    private int j;
    private OnResultListener<Void, MessagingError> k;
    private CredentialAuthorizeListener l;
    private SignInListener m;
    private EventListener n;
    private ChatMode o;
    private User p;
    private boolean q;
    private EventListener r = new EventListener(){

        public void onConnected() {
            ChatroomOutputView.this.a(true);
            ChatroomOutputView.this.setSendBtnVisibility(0);
            ChatroomOutputView.this.o = ChatroomOutputView.this.d.getChatMode();
            ChatroomOutputView.this.p = ChatroomOutputView.this.d.getCurrentUser();
            ChatroomOutputView.this.a(ChatroomOutputView.this.o, ChatroomOutputView.this.p.isGuest());
        }

        public void onConnectFailed(MessagingError messagingError) {
            ChatroomOutputView.this.g.setVisibility(8);
        }

        public void onError(MessagingError messagingError) {
            ChatroomOutputView.this.g.setVisibility(8);
        }

        public void onDisconnected() {
            ChatroomOutputView.this.g.setVisibility(8);
        }

        public void onChatWriteModeChanged(ChatMode chatMode) {
        }

        public void onInputIntervalChanged(int n) {
        }

        public void onMessageAdded(Message message) {
            ChatroomOutputView.this.e.a(message);
        }

        public void onMessageRemoved(String string2) {
        }

        public void onMessageFlushed() {
        }

        public void onUserJoined(User[] userArray) {
        }

        public void onUserUpdated(User[] userArray) {
        }

        public void onUserLeft(Integer[] integerArray) {
        }

        public void userCount(int n) {
            if (ChatroomOutputView.this.n != null) {
                ChatroomOutputView.this.n.userCount(n);
            }
        }
    };
    private View.OnTouchListener s = new View.OnTouchListener(){

        public boolean onTouch(View view, MotionEvent motionEvent) {
            if (motionEvent.getAction() == 0 && ChatroomOutputView.this.p.isGuest()) {
                if (ChatroomOutputView.this.o.equals((Object)ChatMode.ALL)) {
                    if (ChatroomOutputView.this.b(ChatroomOutputView.this.p)) {
                        ChatroomOutputView.this.b();
                        return true;
                    }
                } else if (ChatroomOutputView.this.o.equals((Object)ChatMode.LOGIN)) {
                    if (ChatroomOutputView.this.m != null) {
                        ChatroomOutputView.this.m.signIn();
                    }
                    return true;
                }
            }
            return view.onTouchEvent(motionEvent);
        }
    };

    public ChatroomOutputView(Context context) {
        this(context, null);
    }

    public ChatroomOutputView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public ChatroomOutputView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.a(context, attributeSet);
    }

    private void a(Context context, AttributeSet attributeSet) {
        ViewGroup viewGroup = (ViewGroup)LayoutInflater.from((Context)new ContextThemeWrapper(context, R.style.ChatroomTheme)).inflate(R.layout.chatroom_main_container, (ViewGroup)this, false);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.Chatroom, 0, R.style.ChatroomTheme);
        this.f = (RecyclerView)iKalaUtils.getView((View)viewGroup, (int)16908298);
        this.g = iKalaUtils.getView((View)viewGroup, (int)R.id.loadingBar);
        this.e = new a(this);
        this.f = (RecyclerView)iKalaUtils.getView((View)viewGroup, (int)16908298);
        this.f.setAdapter((RecyclerView.Adapter)this.e);
        GradientDrawable gradientDrawable = (GradientDrawable)ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.recyclerview_divider);
        gradientDrawable.setColor(typedArray.getColor(R.styleable.Chatroom_msgDividerColor, 0));
        this.f.addItemDecoration((RecyclerView.ItemDecoration)new io.straas.android.sdk.messaging.ui.a((Drawable)gradientDrawable));
        this.f.addOnScrollListener((RecyclerView.OnScrollListener)new b());
        this.q = typedArray.getBoolean(R.styleable.Chatroom_showAvatar, true);
        this.addView((View)viewGroup);
        TypedValue typedValue = new TypedValue();
        this.getContext().getTheme().resolveAttribute(R.attr.dialogPreferredPadding, typedValue, true);
        this.j = this.getResources().getDimensionPixelSize(typedValue.resourceId);
        typedArray.recycle();
    }

    public void setShowAvatar(boolean bl) {
        this.q = bl;
    }

    public void setChatroomInputView(ChatroomInputView chatroomInputView) {
        this.i = (TextView)iKalaUtils.getView((View)chatroomInputView, (int)R.id.inputEditText);
        this.i.setOnTouchListener(this.s);
        this.h = iKalaUtils.getView((View)chatroomInputView, (int)R.id.btnSend);
        this.h.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (ChatroomOutputView.this.d == null) {
                    Log.w((String)a, (String)"Chatroom is not connected. Please call connect function first.");
                    return;
                }
                String string2 = ChatroomOutputView.this.i.getText().toString();
                iKalaUtils.hideKeyboard((Context)view.getContext(), (IBinder)view.getWindowToken());
                ChatroomOutputView.this.i.setText((CharSequence)"");
                ChatroomOutputView.this.d.sendMessage(string2, (OnResultListener)new OnResultListener<Void, MessagingError>(){

                    public void a(Void void_) {
                        ChatroomOutputView.this.a(ChatroomOutputView.this.d.getSendMessageInterval());
                        if (ChatroomOutputView.this.k != null) {
                            ChatroomOutputView.this.k.onSuccess((Object)void_);
                        }
                    }

                    public void a(MessagingError messagingError) {
                        if (ChatroomOutputView.this.k != null) {
                            ChatroomOutputView.this.k.onFailure((Object)messagingError);
                        }
                    }

                    public /* synthetic */ void onFailure(Object object) {
                        this.a((MessagingError)object);
                    }

                    public /* synthetic */ void onSuccess(Object object) {
                        this.a((Void)object);
                    }
                });
            }
        });
        if (this.d != null && this.d.getChatroomState() == ChatroomState.CONNECTED) {
            this.r.onConnected();
        }
    }

    public void connect(final String string2, final Identity identity) {
        this.g.setVisibility(0);
        ChatroomManager.initialize((OnResultListener)new OnResultListener<ChatroomManager, CredentialFailReason>(){

            public void a(ChatroomManager chatroomManager) {
                ChatroomOutputView.this.setChatroomManager(chatroomManager);
                ChatroomOutputView.this.d.connect(string2, identity, true);
                if (ChatroomOutputView.this.l != null) {
                    ChatroomOutputView.this.l.onSuccess(chatroomManager);
                }
            }

            public void a(CredentialFailReason credentialFailReason) {
                if (ChatroomOutputView.this.l != null) {
                    ChatroomOutputView.this.l.onFailure(credentialFailReason);
                }
                ChatroomOutputView.this.g.setVisibility(8);
            }

            public /* synthetic */ void onFailure(Object object) {
                this.a((CredentialFailReason)object);
            }

            public /* synthetic */ void onSuccess(Object object) {
                this.a((ChatroomManager)object);
            }
        });
    }

    public void setChatroomManager(@NonNull ChatroomManager chatroomManager) {
        if (chatroomManager == null) {
            return;
        }
        if (this.d != null) {
            this.e.a();
        }
        this.d = chatroomManager;
        this.d.addEventListener(this.r);
        if (this.n != null) {
            this.d.addEventListener(this.n);
        }
        if (this.d.getChatroomState() == ChatroomState.CONNECTED) {
            this.r.onConnected();
        }
    }

    public void disconnect() {
        if (this.d != null) {
            this.d.disconnect();
        }
    }

    private void a(final boolean bl) {
        this.d.getMessages(this.c + 1, 40, (OnResultListener)new OnResultListener<Message[], MessagingError>(){

            public void a(Message[] messageArray) {
                ChatroomOutputView.this.c++;
                ChatroomOutputView.this.e.a(messageArray.length >= 40);
                ChatroomOutputView.this.e.a(messageArray, bl);
                ChatroomOutputView.this.g.setVisibility(8);
            }

            public void a(MessagingError messagingError) {
                ChatroomOutputView.this.e.a(false);
                ChatroomOutputView.this.g.setVisibility(8);
            }

            public /* synthetic */ void onFailure(Object object) {
                this.a((MessagingError)object);
            }

            public /* synthetic */ void onSuccess(Object object) {
                this.a((Message[])object);
            }
        });
    }

    private String a(User user) {
        if (user.isGuest() && !this.b(user)) {
            return String.format(this.getResources().getString(R.string.input_hint_guest), user.getName());
        }
        return this.getResources().getString(R.string.input_hint);
    }

    private void a(boolean bl, String string2) {
        this.setSendButton(bl);
        this.h.setEnabled(bl);
        this.i.setHint((CharSequence)string2);
        if (!bl) {
            this.i.clearFocus();
        }
    }

    private void setSendButton(boolean bl) {
        this.h.setEnabled(bl);
        this.h.setAlpha(bl ? 1.0f : 0.3f);
    }

    private void setSendBtnVisibility(int n) {
        this.h.setVisibility(n);
    }

    private void a(ChatMode chatMode, boolean bl) {
        if (bl && chatMode.equals((Object)ChatMode.LOGIN)) {
            this.a(false, this.getResources().getString(R.string.plz_signin));
        } else {
            this.a(true, this.a(this.p));
        }
        this.i.setEnabled(true);
    }

    private void a(int n) {
        if (n <= 0) {
            return;
        }
        c c2 = new c((long)n * 1000L, 500L);
        c2.a();
    }

    public ChatroomManager getChatroomManager() {
        return this.d;
    }

    public void setSendMessageListener(OnResultListener<Void, MessagingError> onResultListener) {
        this.k = onResultListener;
    }

    public void setCredentialAuthorizeListener(CredentialAuthorizeListener credentialAuthorizeListener) {
        this.l = credentialAuthorizeListener;
    }

    public void setEventListener(EventListener eventListener) {
        this.n = eventListener;
        if (this.d != null) {
            this.d.addEventListener(eventListener);
        }
    }

    public void setSignInListener(SignInListener signInListener) {
        this.m = signInListener;
    }

    private void b() {
        AlertDialog.Builder builder = new AlertDialog.Builder(this.getContext());
        builder.setTitle((CharSequence)this.getResources().getString(R.string.enter_nickname));
        AppCompatEditText appCompatEditText = new AppCompatEditText(this.getContext());
        InputFilter[] inputFilterArray = new InputFilter[]{new InputFilter.LengthFilter(15)};
        appCompatEditText.setFilters(inputFilterArray);
        appCompatEditText.setMaxLines(1);
        appCompatEditText.setImeOptions(6);
        builder.setPositiveButton((CharSequence)this.getResources().getString(R.string.common_confirm), null);
        builder.setNegativeButton((CharSequence)this.getResources().getString(R.string.common_cancel), null);
        final AlertDialog alertDialog = builder.create();
        iKalaUtils.showKeyboard((Window)alertDialog.getWindow());
        alertDialog.setView((View)appCompatEditText, this.j, this.j, this.j, 0);
        alertDialog.setOnShowListener(new DialogInterface.OnShowListener((EditText)appCompatEditText){
            final /* synthetic */ EditText b;
            {
                this.b = editText;
            }

            public void onShow(DialogInterface dialogInterface) {
                final Button button = alertDialog.getButton(-1);
                Button button2 = alertDialog.getButton(-2);
                button.setEnabled(false);
                this.b.setOnEditorActionListener(new TextView.OnEditorActionListener(){

                    public boolean onEditorAction(TextView textView, int n, KeyEvent keyEvent) {
                        if (n == 6) {
                            ChatroomOutputView.this.a(b.getText().toString());
                            alertDialog.dismiss();
                        }
                        return false;
                    }
                });
                this.b.addTextChangedListener(new TextWatcher(){

                    public void afterTextChanged(Editable editable) {
                        button.setEnabled(editable.length() != 0);
                    }

                    public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
                    }

                    public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
                    }
                });
                button.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        ChatroomOutputView.this.a(b.getText().toString());
                        alertDialog.dismiss();
                    }
                });
                button2.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        alertDialog.dismiss();
                    }
                });
            }
        });
        alertDialog.show();
    }

    private void a(String string2) {
        this.d.updateNickname(string2, (OnResultListener)new OnResultListener<Void, MessagingError>(){

            public void a(Void void_) {
                ChatroomOutputView.this.a(true, ChatroomOutputView.this.a(ChatroomOutputView.this.p));
            }

            public void a(MessagingError messagingError) {
                Toast.makeText((Context)ChatroomOutputView.this.getContext(), (CharSequence)ChatroomOutputView.this.getResources().getString(R.string.update_nickname_fail), (int)1).show();
            }

            public /* synthetic */ void onFailure(Object object) {
                this.a((MessagingError)object);
            }

            public /* synthetic */ void onSuccess(Object object) {
                this.a((Void)object);
            }
        });
    }

    private boolean b(User user) {
        return user.getName().equals("Guest");
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        io.straas.android.sdk.messaging.ui.a.h.a();
    }

    private class c
    extends CountDownTimer {
        private long b;

        public c(long l, long l2) {
            super(l, l2);
            this.b = l;
        }

        public CountDownTimer a() {
            ChatroomOutputView.this.a(false, ChatroomOutputView.this.getResources().getString(R.string.send_msg_time_left_android, new Object[]{this.b / 1000L + 1L}));
            ChatroomOutputView.this.i.setEnabled(false);
            return super.start();
        }

        public void onTick(long l) {
            ChatroomOutputView.this.a(false, ChatroomOutputView.this.getResources().getString(R.string.send_msg_time_left_android, new Object[]{l / 1000L + 1L}));
        }

        public void onFinish() {
            ChatroomOutputView.this.a(true, ChatroomOutputView.this.a(ChatroomOutputView.this.p));
            ChatroomOutputView.this.i.setEnabled(true);
        }
    }

    class b
    extends RecyclerView.OnScrollListener {
        b() {
        }

        public void onScrollStateChanged(RecyclerView recyclerView, int n) {
            super.onScrollStateChanged(recyclerView, n);
            int n2 = ((LinearLayoutManager)recyclerView.getLayoutManager()).findLastCompletelyVisibleItemPosition();
            ChatroomOutputView.this.b = n2 == recyclerView.getAdapter().getItemCount() - 1;
        }
    }

    private static class io.straas.android.sdk.messaging.ui.ChatroomOutputView$a
    extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
        private boolean a = false;
        private List<Message> b = new ArrayList<Message>();
        private ChatroomOutputView c;
        private LayoutInflater d;

        io.straas.android.sdk.messaging.ui.ChatroomOutputView$a(ChatroomOutputView chatroomOutputView) {
            this.c = chatroomOutputView;
        }

        public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup viewGroup, int n) {
            if (this.d == null) {
                this.d = LayoutInflater.from((Context)new ContextThemeWrapper(viewGroup.getContext(), R.style.ChatroomTheme));
            }
            switch (n) {
                case 1: {
                    return new a(this.d.inflate(R.layout.load_more, viewGroup, false));
                }
            }
            return new b(this.d.inflate(R.layout.message_item, viewGroup, false));
        }

        public void onBindViewHolder(RecyclerView.ViewHolder viewHolder, int n) {
            if (viewHolder instanceof a) {
                this.c.a(false);
            } else if (viewHolder instanceof b) {
                b b2 = (b)viewHolder;
                ImageView imageView = b2.a();
                if (this.c.q) {
                    if (imageView.getVisibility() != 0) {
                        imageView.setVisibility(0);
                    }
                } else if (imageView.getVisibility() != 8) {
                    imageView.setVisibility(8);
                }
                Message message = this.b.get(n - (this.a ? 1 : 0));
                io.straas.android.sdk.messaging.ui.b.c(b2.b(), message);
                if (imageView.getVisibility() == 0) {
                    io.straas.android.sdk.messaging.ui.b.a(imageView, message, this.a(R.drawable.common_default_avatar));
                }
                io.straas.android.sdk.messaging.ui.b.a(b2.d(), message);
                io.straas.android.sdk.messaging.ui.b.b(b2.c(), message);
            }
        }

        public int getItemViewType(int n) {
            if (n == 0 && this.a) {
                return 1;
            }
            return 0;
        }

        public int getItemCount() {
            return this.b.size() + (this.a ? 1 : 0);
        }

        void a(Message message) {
            int n = 0;
            for (int i = this.b.size() - 1; i >= 0; --i) {
                if (this.a(message, this.b.get(i)) <= 0) continue;
                n = i + 1;
                break;
            }
            this.b.add(n, message);
            this.notifyItemInserted(n + (this.a ? 1 : 0));
            if (this.c.b) {
                this.b();
            }
        }

        void a(Message[] messageArray, boolean bl) {
            this.b.addAll(0, Arrays.asList(messageArray));
            Collections.sort(this.b, new Comparator<Message>(){

                public int a(Message message, Message message2) {
                    return a.this.a(message, message2);
                }

                @Override
                public /* synthetic */ int compare(Object object, Object object2) {
                    return this.a((Message)object, (Message)object2);
                }
            });
            this.notifyItemRangeInserted(0, messageArray.length);
            if (bl) {
                this.b();
            }
        }

        private int a(Message message, Message message2) {
            long l;
            long l2 = message.getCreatedDate();
            if (l2 > (l = message2.getCreatedDate())) {
                return 1;
            }
            if (l2 < l) {
                return -1;
            }
            return 0;
        }

        private void b() {
            this.c.f.scrollToPosition(this.getItemCount() - 1);
            this.c.b = true;
        }

        void a() {
            int n = this.b.size();
            this.b.clear();
            this.notifyItemRangeRemoved(0, n);
        }

        public boolean a(boolean bl) {
            boolean bl2 = false;
            if (this.a == bl) {
                return false;
            }
            this.a = bl;
            if (bl) {
                this.notifyItemInserted(0);
            } else {
                this.notifyItemRemoved(0);
            }
            return true;
        }

        private Drawable a(@DrawableRes int n) {
            try {
                return VectorDrawableCompat.create((Resources)this.c.getResources(), (int)n, null);
            }
            catch (Resources.NotFoundException notFoundException) {
                return ContextCompat.getDrawable((Context)this.c.getContext(), (int)n);
            }
        }

        private class a
        extends RecyclerView.ViewHolder {
            public a(View view) {
                super(view);
            }
        }

        private class b
        extends RecyclerView.ViewHolder {
            private ImageView b;
            private TextView c;
            private TextView d;
            private TextView e;

            public b(View view) {
                super(view);
                this.b = (ImageView)iKalaUtils.getView((View)view, (int)R.id.avatar);
                this.c = (TextView)iKalaUtils.getView((View)view, (int)R.id.nickName);
                this.d = (TextView)iKalaUtils.getView((View)view, (int)R.id.time);
                this.e = (TextView)iKalaUtils.getView((View)view, (int)R.id.message);
            }

            public ImageView a() {
                return this.b;
            }

            public TextView b() {
                return this.c;
            }

            public TextView c() {
                return this.d;
            }

            public TextView d() {
                return this.e;
            }
        }
    }
}

