/*
 * Decompiled with CFR 0.152.
 */
package com.ikala.android.httptask;

import android.os.Build;
import android.os.StatFs;
import android.util.Log;
import com.ikala.android.httptask.Tls12SocketFactory;
import java.io.File;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Cache;
import okhttp3.ConnectionSpec;
import okhttp3.OkHttpClient;
import okhttp3.TlsVersion;

public class iKalaHttpUtils {
    public static final String PLATFORM = "android";
    public static final String NONE = "none";
    public static final String USER_TOKEN = "userToken";
    public static final String CHAT_ID = "chatId";
    public static final String COUNT = "count";
    public static final String OFFSET = "offset";
    public static final String VIEWER_HASH_CODE = "viewerHashCode";
    public static final String SOURCE_TYPE = "sourceType";
    public static final String MESSAGE_ID = "messageId";
    public static final String VALUE_PLATFORM = "ANDROID";
    private static OkHttpClient a;

    public static void initOkHttpClient(OkHttpClient.Builder builder) {
        a = iKalaHttpUtils.a(builder).build();
    }

    private static OkHttpClient.Builder a(OkHttpClient.Builder builder) {
        if (Build.VERSION.SDK_INT >= 16 && Build.VERSION.SDK_INT < 22) {
            try {
                SSLContext sSLContext = SSLContext.getInstance(TlsVersion.TLS_1_2.javaName());
                sSLContext.init(null, null, null);
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init((KeyStore)null);
                Object[] objectArray = trustManagerFactory.getTrustManagers();
                if (objectArray.length != 1 || !(objectArray[0] instanceof X509TrustManager)) {
                    throw new IllegalStateException("Unexpected default trust managers:" + Arrays.toString(objectArray));
                }
                X509TrustManager x509TrustManager = (X509TrustManager)objectArray[0];
                builder.sslSocketFactory((SSLSocketFactory)new Tls12SocketFactory(sSLContext.getSocketFactory()), x509TrustManager);
                ConnectionSpec connectionSpec = new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS).tlsVersions(new TlsVersion[]{TlsVersion.TLS_1_2}).build();
                ArrayList<ConnectionSpec> arrayList = new ArrayList<ConnectionSpec>();
                arrayList.add(connectionSpec);
                arrayList.add(ConnectionSpec.CLEARTEXT);
                builder.connectionSpecs(arrayList);
            }
            catch (Exception exception) {
                Log.e((String)"OkHttpTLSCompat", (String)"Error while setting TLS 1.2", (Throwable)exception);
            }
        } else if (Build.VERSION.SDK_INT >= 22) {
            builder.connectionSpecs(Collections.unmodifiableList(Arrays.asList(new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS).tlsVersions(new TlsVersion[]{TlsVersion.TLS_1_3, TlsVersion.TLS_1_2}).build(), ConnectionSpec.CLEARTEXT)));
        }
        return builder;
    }

    public static OkHttpClient getOkHttpClient() {
        if (a == null) {
            iKalaHttpUtils.initOkHttpClient(new OkHttpClient.Builder());
        }
        return a;
    }

    public static OkHttpClient.Builder initCache(OkHttpClient.Builder builder, File path, long catchSize) {
        return builder.cache(new Cache(path, catchSize));
    }

    public static long getAvailableSpace(File path) {
        if (path == null || !path.canWrite()) {
            return 0L;
        }
        StatFs statFs = new StatFs(path.getPath());
        if (Build.VERSION.SDK_INT >= 18) {
            return statFs.getBlockSizeLong() * statFs.getBlockCountLong();
        }
        return (long)statFs.getBlockSize() * (long)statFs.getBlockCount();
    }
}

