/*
 * Decompiled with CFR 0.152.
 */
package com.ikala.android.httptask.interceptor;

import java.io.IOException;
import java.util.HashMap;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class CommonHeaderInterceptor
implements Interceptor {
    private final HashMap<String, String> a;

    private CommonHeaderInterceptor(HashMap<String, String> hashMap) {
        this.a = hashMap;
    }

    public int getHeaderCount() {
        if (this.a == null) {
            return 0;
        }
        return this.a.size();
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request.Builder builder = chain.request().newBuilder();
        for (String string : this.a.keySet()) {
            String string2 = this.a.get(string);
            builder.addHeader(string, string2);
        }
        return chain.proceed(builder.build());
    }

    public static class Builder {
        private final HashMap<String, String> a = new HashMap();

        public Builder setUserAgent(String string) {
            this.setHeader("User-Agent", string);
            return this;
        }

        public Builder setAccept(String string) {
            this.setHeader("Accept", string);
            return this;
        }

        public Builder setContentType(String string) {
            this.setHeader("Content-Type", string);
            return this;
        }

        public Builder setHeader(String string, String string2) {
            this.a.put(string, string2);
            return this;
        }

        public CommonHeaderInterceptor build() {
            return new CommonHeaderInterceptor(this.a);
        }
    }
}

