/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.readers.operation;

import io.swagger.annotations.ApiOperation;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.OperationBuilderPlugin;
import springfox.documentation.spi.service.contexts.OperationContext;
import springfox.documentation.spring.web.DescriptionResolver;
import springfox.documentation.swagger.common.SwaggerPluginSupport;

@Component
@Order(value=-2147482648)
public class OperationNotesReader
implements OperationBuilderPlugin {
    private final DescriptionResolver descriptions;

    @Autowired
    public OperationNotesReader(DescriptionResolver descriptions) {
        this.descriptions = descriptions;
    }

    public void apply(OperationContext context) {
        Optional methodAnnotation = context.findAnnotation(ApiOperation.class);
        if (methodAnnotation.isPresent() && StringUtils.hasText((String)((ApiOperation)methodAnnotation.get()).notes())) {
            context.operationBuilder().notes(this.descriptions.resolve(((ApiOperation)methodAnnotation.get()).notes()));
        }
    }

    public boolean supports(DocumentationType delimiter) {
        return SwaggerPluginSupport.pluginDoesApply(delimiter);
    }
}

