/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.web;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;
import springfox.documentation.spring.web.DocumentationCache;
import springfox.documentation.swagger.web.SwaggerResource;

@Controller
@ApiIgnore
public class ApiResourceController {
    @Value(value="${springfox.documentation.swagger.v1.path:/api-docs}")
    private String swagger1Url;
    @Value(value="${springfox.documentation.swagger.v2.path:/v2/api-docs}")
    private String swagger2Url;
    @Autowired
    private DocumentationCache documentationCache;

    @RequestMapping(value={"/swagger-resources"})
    @ResponseBody
    ResponseEntity<List<SwaggerResource>> swaggerResources() {
        Class swagger1Controller = this.classOrNull("springfox.documentation.swagger1.web.Swagger1Controller");
        Class swagger2Controller = this.classOrNull("springfox.documentation.swagger2.web.Swagger2Controller");
        ArrayList<SwaggerResource> resources = new ArrayList<SwaggerResource>();
        for (Map.Entry entry : this.documentationCache.all().entrySet()) {
            SwaggerResource swaggerResource;
            String swaggerGroup = (String)entry.getKey();
            if (swagger1Controller != null) {
                swaggerResource = this.resource(swaggerGroup, this.swagger1Url);
                swaggerResource.setSwaggerVersion("1.2");
                resources.add(swaggerResource);
            }
            if (swagger2Controller == null) continue;
            swaggerResource = this.resource(swaggerGroup, this.swagger2Url);
            swaggerResource.setSwaggerVersion("2.0");
            resources.add(swaggerResource);
        }
        Collections.sort(resources);
        return new ResponseEntity(resources, HttpStatus.OK);
    }

    private SwaggerResource resource(String swaggerGroup, String baseUrl) {
        SwaggerResource swaggerResource = new SwaggerResource();
        swaggerResource.setName(swaggerGroup);
        swaggerResource.setLocation(this.swaggerLocation(baseUrl, swaggerGroup));
        return swaggerResource;
    }

    private String swaggerLocation(String swaggerUrl, String swaggerGroup) {
        String base = (String)Optional.of((Object)swaggerUrl).get();
        if ("default".equals(swaggerGroup)) {
            return base;
        }
        return base + "?group=" + swaggerGroup;
    }

    private Class classOrNull(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

