/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.scanners;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class ComparisonCondition {
    private final String modelFor;
    private final Set<String> modelsTo;
    private final Set<String> conditions;

    public ComparisonCondition(String modelFor, Set<String> modelsTo, Set<String> conditions) {
        this.modelFor = modelFor;
        this.modelsTo = Collections.unmodifiableSet(new HashSet<String>(modelsTo));
        this.conditions = Collections.unmodifiableSet(new HashSet<String>(conditions));
    }

    public String getModelFor() {
        return this.modelFor;
    }

    public Set<String> getModelsTo() {
        return this.modelsTo;
    }

    public Set<String> getConditions() {
        return this.conditions;
    }

    public int hashCode() {
        return Objects.hash(this.modelFor, this.modelsTo, this.conditions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComparisonCondition that = (ComparisonCondition)o;
        return Objects.equals(this.modelFor, that.modelFor) && Objects.equals(this.modelsTo, that.modelsTo) && Objects.equals(this.conditions, that.conditions);
    }
}

