/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.readers.parameter;

import java.lang.annotation.Annotation;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.ParameterBuilderPlugin;
import springfox.documentation.spi.service.contexts.ParameterContext;

@Component
@Order(value=-2147483648)
public class ParameterDefaultReader
implements ParameterBuilderPlugin {
    public void apply(ParameterContext context) {
        MethodParameter methodParameter = context.methodParameter();
        String defaultValue = this.findAnnotatedDefaultValue(methodParameter);
        boolean isSkip = "\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(defaultValue);
        if (!isSkip) {
            context.parameterBuilder().defaultValue(defaultValue);
        }
    }

    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    private String findAnnotatedDefaultValue(MethodParameter methodParameter) {
        Annotation[] methodAnnotations;
        for (Annotation annotation : methodAnnotations = methodParameter.getParameterAnnotations()) {
            if (annotation instanceof RequestParam) {
                return ((RequestParam)annotation).defaultValue();
            }
            if (!(annotation instanceof RequestHeader)) continue;
            return ((RequestHeader)annotation).defaultValue();
        }
        return null;
    }
}

