/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.data.rest;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.google.common.base.CaseFormat;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.Resources;
import org.springframework.web.method.HandlerMethod;
import springfox.documentation.spring.data.rest.SynthesizedAnnotations;

class RequestExtractionUtils {
    private RequestExtractionUtils() {
        throw new UnsupportedOperationException();
    }

    public static String lowerCamelCaseName(String stringValue) {
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, stringValue);
    }

    public static String upperCamelCaseName(String stringValue) {
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, stringValue);
    }

    public static String actionName(PersistentEntity<?, ?> entity, Method method) {
        return String.format("%s%s", method.getName(), entity.getType().getSimpleName());
    }

    public static List<Annotation> pathAnnotations(String name) {
        return RequestExtractionUtils.pathAnnotations(name, null);
    }

    public static List<Annotation> pathAnnotations(String name, HandlerMethod handler) {
        List<Annotation> annotations = RequestExtractionUtils.handlerAnnotations(handler);
        if (name != null) {
            annotations.add((Annotation)SynthesizedAnnotations.pathVariable(name));
        }
        return annotations;
    }

    public static List<Annotation> bodyAnnotations(HandlerMethod handler) {
        List<Annotation> annotations = RequestExtractionUtils.handlerAnnotations(handler);
        annotations.add((Annotation)SynthesizedAnnotations.REQUEST_BODY_ANNOTATION);
        return annotations;
    }

    private static List<Annotation> handlerAnnotations(HandlerMethod handler) {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        if (handler != null) {
            annotations.addAll(Arrays.asList(AnnotationUtils.getAnnotations((Method)handler.getMethod())));
        }
        return annotations;
    }

    public static List<Annotation> bodyAnnotations() {
        List<Annotation> annotations = RequestExtractionUtils.handlerAnnotations(null);
        annotations.add((Annotation)SynthesizedAnnotations.REQUEST_BODY_ANNOTATION);
        return annotations;
    }

    public static String propertyIdentifierName(PersistentProperty<?> property) {
        String propertyName = property.getName();
        if (property.isCollectionLike()) {
            propertyName = property.getComponentType().getSimpleName();
        } else if (property.isMap()) {
            propertyName = property.getMapValueType().getSimpleName();
        }
        return String.format("%sId", propertyName.toLowerCase());
    }

    public static ResolvedType propertyResponse(PersistentProperty<?> property, TypeResolver resolver) {
        if (property.isCollectionLike()) {
            return resolver.resolve(Resources.class, new Type[]{property.getComponentType()});
        }
        if (property.isMap()) {
            return resolver.resolve(Resource.class, new Type[]{resolver.resolve(Map.class, new Type[]{String.class, property.getMapValueType()})});
        }
        return resolver.resolve(Resource.class, new Type[]{property.getType()});
    }

    public static ResolvedType propertyItemResponse(PersistentProperty<?> property, TypeResolver resolver) {
        if (property.isCollectionLike()) {
            return resolver.resolve(Resource.class, new Type[]{property.getComponentType()});
        }
        if (property.isMap()) {
            return resolver.resolve(Resource.class, new Type[]{property.getMapValueType()});
        }
        return resolver.resolve(Resource.class, new Type[]{property.getType()});
    }
}

