/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.auth.impl.persistence;

import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.configuration.ConditionOnEmbeddedStorage;
import com.alibaba.nacos.config.server.model.Page;
import com.alibaba.nacos.config.server.service.repository.PaginationHelper;
import com.alibaba.nacos.config.server.service.repository.embedded.DatabaseOperate;
import com.alibaba.nacos.config.server.service.repository.embedded.EmbeddedStoragePersistServiceImpl;
import com.alibaba.nacos.config.server.service.sql.EmbeddedStorageContextUtils;
import com.alibaba.nacos.plugin.auth.impl.persistence.AuthRowMapperManager;
import com.alibaba.nacos.plugin.auth.impl.persistence.RoleInfo;
import com.alibaba.nacos.plugin.auth.impl.persistence.RolePersistService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;

@Conditional(value={ConditionOnEmbeddedStorage.class})
@Component
public class EmbeddedRolePersistServiceImpl
implements RolePersistService {
    @Autowired
    private DatabaseOperate databaseOperate;
    @Autowired
    private EmbeddedStoragePersistServiceImpl persistService;
    private static final String PATTERN_STR = "*";
    private static final String SQL_DERBY_ESCAPE_BACK_SLASH_FOR_LIKE = " ESCAPE '\\' ";

    @Override
    public Page<RoleInfo> getRoles(int pageNo, int pageSize) {
        PaginationHelper helper = this.persistService.createPaginationHelper();
        String sqlCountRows = "SELECT count(*) FROM (SELECT DISTINCT role FROM roles) roles WHERE ";
        String sqlFetchRows = "SELECT role,username FROM roles WHERE ";
        String where = " 1=1 ";
        Page pageInfo = helper.fetchPage(sqlCountRows + where, sqlFetchRows + where, new ArrayList().toArray(), pageNo, pageSize, (RowMapper)AuthRowMapperManager.ROLE_INFO_ROW_MAPPER);
        if (pageInfo == null) {
            pageInfo = new Page();
            pageInfo.setTotalCount(0);
            pageInfo.setPageItems(new ArrayList());
        }
        return pageInfo;
    }

    @Override
    public Page<RoleInfo> getRolesByUserNameAndRoleName(String username, String role, int pageNo, int pageSize) {
        PaginationHelper helper = this.persistService.createPaginationHelper();
        String sqlCountRows = "SELECT count(*) FROM roles ";
        String sqlFetchRows = "SELECT role,username FROM roles ";
        StringBuilder where = new StringBuilder(" WHERE 1 = 1 ");
        ArrayList<String> params = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)username)) {
            where.append(" AND username = ? ");
            params.add(username);
        }
        if (StringUtils.isNotBlank((String)role)) {
            where.append(" AND role = ? ");
            params.add(role);
        }
        return helper.fetchPage(sqlCountRows + where, sqlFetchRows + where, params.toArray(), pageNo, pageSize, (RowMapper)AuthRowMapperManager.ROLE_INFO_ROW_MAPPER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRole(String role, String userName) {
        String sql = "INSERT INTO roles (role, username) VALUES (?, ?)";
        try {
            EmbeddedStorageContextUtils.addSqlContext((String)sql, (Object[])new Object[]{role, userName});
            this.databaseOperate.update(EmbeddedStorageContextUtils.getCurrentSqlContext());
        }
        finally {
            EmbeddedStorageContextUtils.cleanAllContext();
        }
    }

    @Override
    public void deleteRole(String role) {
        String sql = "DELETE FROM roles WHERE role=?";
        try {
            EmbeddedStorageContextUtils.addSqlContext((String)sql, (Object[])new Object[]{role});
            this.databaseOperate.update(EmbeddedStorageContextUtils.getCurrentSqlContext());
        }
        finally {
            EmbeddedStorageContextUtils.cleanAllContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteRole(String role, String username) {
        String sql = "DELETE FROM roles WHERE role=? AND username=?";
        try {
            EmbeddedStorageContextUtils.addSqlContext((String)sql, (Object[])new Object[]{role, username});
            this.databaseOperate.update(EmbeddedStorageContextUtils.getCurrentSqlContext());
        }
        finally {
            EmbeddedStorageContextUtils.cleanAllContext();
        }
    }

    @Override
    public List<String> findRolesLikeRoleName(String role) {
        String sql = "SELECT role FROM roles WHERE role LIKE ?  ESCAPE '\\' ";
        return this.databaseOperate.queryMany(sql, (Object[])new String[]{"%" + role + "%"}, String.class);
    }

    @Override
    public String generateLikeArgument(String s) {
        String underscore = "_";
        if (s.contains(underscore)) {
            s = s.replaceAll(underscore, "\\\\_");
        }
        String fuzzySearchSign = "\\*";
        String sqlLikePercentSign = "%";
        if (s.contains(PATTERN_STR)) {
            return s.replaceAll(fuzzySearchSign, sqlLikePercentSign);
        }
        return s;
    }

    @Override
    public Page<RoleInfo> findRolesLike4Page(String username, String role, int pageNo, int pageSize) {
        StringBuilder where = new StringBuilder(" WHERE 1 = 1 ");
        ArrayList<String> params = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)username)) {
            where.append(" AND username LIKE ? ");
            params.add(this.generateLikeArgument(username));
        }
        if (StringUtils.isNotBlank((String)role)) {
            where.append(" AND role LIKE ? ");
            params.add(this.generateLikeArgument(role));
        }
        if (CollectionUtils.isNotEmpty(params)) {
            where.append(SQL_DERBY_ESCAPE_BACK_SLASH_FOR_LIKE);
        }
        String sqlCountRows = "SELECT count(*) FROM roles";
        String sqlFetchRows = "SELECT role, username FROM roles";
        PaginationHelper helper = this.persistService.createPaginationHelper();
        return helper.fetchPage(sqlCountRows + where, sqlFetchRows + where, params.toArray(), pageNo, pageSize, (RowMapper)AuthRowMapperManager.ROLE_INFO_ROW_MAPPER);
    }
}

