/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming.remote.gprc.redo.data;

import java.util.Objects;

public abstract class RedoData<T> {
    private final String serviceName;
    private final String groupName;
    private volatile boolean registered;
    private volatile boolean unregistering;
    private T data;

    protected RedoData(String serviceName, String groupName) {
        this.serviceName = serviceName;
        this.groupName = groupName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public void setRegistered(boolean registered) {
        this.registered = registered;
    }

    public boolean isUnregistering() {
        return this.unregistering;
    }

    public void setUnregistering(boolean unregistering) {
        this.unregistering = unregistering;
    }

    public T get() {
        return this.data;
    }

    public void set(T data) {
        this.data = data;
    }

    public RedoType getRedoType() {
        if (this.isRegistered() && !this.isUnregistering()) {
            return RedoType.NONE;
        }
        if (this.isRegistered() && this.isUnregistering()) {
            return RedoType.UNREGISTER;
        }
        if (!this.isRegistered() && !this.isUnregistering()) {
            return RedoType.REGISTER;
        }
        return RedoType.REMOVE;
    }

    public boolean isNeedRedo() {
        return !RedoType.NONE.equals((Object)this.getRedoType());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RedoData redoData = (RedoData)o;
        return this.registered == redoData.registered && this.unregistering == redoData.unregistering && this.serviceName.equals(redoData.serviceName) && this.groupName.equals(redoData.groupName) && this.data.equals(redoData.data);
    }

    public int hashCode() {
        return Objects.hash(this.serviceName, this.groupName, this.registered, this.unregistering, this.data);
    }

    public static enum RedoType {
        REGISTER,
        UNREGISTER,
        NONE,
        REMOVE;

    }
}

