/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.zhipuai;

import org.springframework.ai.autoconfigure.zhipuai.ZhipuAiParentProperties;
import org.springframework.ai.zhipuai.ZhipuAiChatOptions;
import org.springframework.ai.zhipuai.api.ZhipuAiApi;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@ConfigurationProperties(value="spring.ai.zhipuai.chat")
public class ZhipuAiChatProperties
extends ZhipuAiParentProperties {
    public static final String CONFIG_PREFIX = "spring.ai.zhipuai.chat";
    public static final String DEFAULT_CHAT_MODEL = ZhipuAiApi.ChatModel.GLM_4.getValue();
    private static final Double DEFAULT_TEMPERATURE = 0.95;
    private static final Float DEFAULT_TOP_P = Float.valueOf(0.7f);
    private boolean enabled = true;
    @NestedConfigurationProperty
    private ZhipuAiChatOptions options = ZhipuAiChatOptions.builder().withModel(DEFAULT_CHAT_MODEL).withTemperature(Float.valueOf(DEFAULT_TEMPERATURE.floatValue())).withTopP(DEFAULT_TOP_P).build();

    public ZhipuAiChatProperties() {
        super.setBaseUrl("https://open.bigmodel.cn");
    }

    public ZhipuAiChatOptions getOptions() {
        return this.options;
    }

    public void setOptions(ZhipuAiChatOptions options) {
        this.options = options;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

