/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.watsonxai;

import org.springframework.ai.autoconfigure.watsonxai.WatsonxAiChatProperties;
import org.springframework.ai.autoconfigure.watsonxai.WatsonxAiConnectionProperties;
import org.springframework.ai.watsonx.WatsonxAiChatClient;
import org.springframework.ai.watsonx.api.WatsonxAiApi;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.client.RestClientAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.web.client.RestClient;

@AutoConfiguration(after={RestClientAutoConfiguration.class})
@ConditionalOnClass(value={WatsonxAiApi.class})
@EnableConfigurationProperties(value={WatsonxAiConnectionProperties.class, WatsonxAiChatProperties.class})
@ConditionalOnProperty(prefix="spring.ai.watsonx.ai.chat", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class WatsonxAiAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public WatsonxAiApi watsonxApi(WatsonxAiConnectionProperties properties, RestClient.Builder restClientBuilder) {
        return new WatsonxAiApi(properties.getBaseUrl(), properties.getStreamEndpoint(), properties.getTextEndpoint(), properties.getProjectId(), properties.getIAMToken(), restClientBuilder);
    }

    @Bean
    @ConditionalOnMissingBean
    public WatsonxAiChatClient watsonxChatClient(WatsonxAiApi watsonxApi, WatsonxAiChatProperties chatProperties) {
        return new WatsonxAiChatClient(watsonxApi, chatProperties.getOptions());
    }
}

