/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.vectorstore.qdrant;

import org.springframework.ai.autoconfigure.vectorstore.qdrant.QdrantConnectionDetails;
import org.springframework.ai.autoconfigure.vectorstore.qdrant.QdrantVectorStoreProperties;
import org.springframework.ai.embedding.EmbeddingClient;
import org.springframework.ai.vectorstore.qdrant.QdrantVectorStore;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnClass(value={QdrantVectorStore.class, EmbeddingClient.class})
@EnableConfigurationProperties(value={QdrantVectorStoreProperties.class})
public class QdrantVectorStoreAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={QdrantConnectionDetails.class})
    PropertiesQdrantConnectionDetails qdrantConnectionDetails(QdrantVectorStoreProperties properties) {
        return new PropertiesQdrantConnectionDetails(properties);
    }

    @Bean
    @ConditionalOnMissingBean
    public QdrantVectorStore vectorStore(EmbeddingClient embeddingClient, QdrantVectorStoreProperties properties, QdrantConnectionDetails connectionDetails) {
        QdrantVectorStore.QdrantVectorStoreConfig config = QdrantVectorStore.QdrantVectorStoreConfig.builder().withCollectionName(properties.getCollectionName()).withHost(connectionDetails.getHost()).withPort(connectionDetails.getPort()).withTls(properties.isUseTls()).withApiKey(properties.getApiKey()).build();
        return new QdrantVectorStore(config, embeddingClient);
    }

    private static class PropertiesQdrantConnectionDetails
    implements QdrantConnectionDetails {
        private final QdrantVectorStoreProperties properties;

        PropertiesQdrantConnectionDetails(QdrantVectorStoreProperties properties) {
            this.properties = properties;
        }

        @Override
        public String getHost() {
            return this.properties.getHost();
        }

        @Override
        public int getPort() {
            return this.properties.getPort();
        }
    }
}

