/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.vectorstore.neo4j;

import org.neo4j.driver.Driver;
import org.springframework.ai.autoconfigure.vectorstore.neo4j.Neo4jVectorStoreProperties;
import org.springframework.ai.embedding.EmbeddingClient;
import org.springframework.ai.vectorstore.Neo4jVectorStore;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.neo4j.Neo4jAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(after={Neo4jAutoConfiguration.class})
@ConditionalOnClass(value={Neo4jVectorStore.class, EmbeddingClient.class, Driver.class})
@EnableConfigurationProperties(value={Neo4jVectorStoreProperties.class})
public class Neo4jVectorStoreAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public Neo4jVectorStore vectorStore(Driver driver, EmbeddingClient embeddingClient, Neo4jVectorStoreProperties properties) {
        Neo4jVectorStore.Neo4jVectorStoreConfig config = Neo4jVectorStore.Neo4jVectorStoreConfig.builder().withDatabaseName(properties.getDatabaseName()).withEmbeddingDimension(properties.getEmbeddingDimension()).withDistanceType(properties.getDistanceType()).withLabel(properties.getLabel()).withEmbeddingProperty(properties.getEmbeddingProperty()).withIndexName(properties.getIndexName()).withIdProperty(properties.getIdProperty()).withConstraintName(properties.getConstraintName()).build();
        return new Neo4jVectorStore(driver, embeddingClient, config);
    }
}

