/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.vectorstore.cassandra;

import com.google.common.base.Preconditions;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.List;
import org.springframework.ai.autoconfigure.vectorstore.cassandra.CassandraConnectionDetails;
import org.springframework.ai.autoconfigure.vectorstore.cassandra.CassandraVectorStoreProperties;
import org.springframework.ai.embedding.EmbeddingClient;
import org.springframework.ai.vectorstore.CassandraVectorStore;
import org.springframework.ai.vectorstore.CassandraVectorStoreConfig;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnClass(value={CassandraVectorStore.class, EmbeddingClient.class})
@EnableConfigurationProperties(value={CassandraVectorStoreProperties.class})
public class CassandraVectorStoreAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={CassandraConnectionDetails.class})
    public PropertiesCassandraConnectionDetails cassandraConnectionDetails(CassandraVectorStoreProperties properties) {
        return new PropertiesCassandraConnectionDetails(properties);
    }

    @Bean
    @ConditionalOnMissingBean
    public CassandraVectorStore vectorStore(EmbeddingClient embeddingClient, CassandraVectorStoreProperties properties, CassandraConnectionDetails cassandraConnectionDetails) {
        CassandraVectorStoreConfig.Builder builder = CassandraVectorStoreConfig.builder();
        if (cassandraConnectionDetails.hasCassandraContactPoints()) {
            for (InetSocketAddress contactPoint : cassandraConnectionDetails.getCassandraContactPoints()) {
                builder = builder.addContactPoint(contactPoint);
            }
        }
        if (cassandraConnectionDetails.hasCassandraLocalDatacenter()) {
            builder = builder.withLocalDatacenter(cassandraConnectionDetails.getCassandraLocalDatacenter());
        }
        builder = builder.withKeyspaceName(properties.getKeyspace()).withTableName(properties.getTable()).withContentColumnName(properties.getContentFieldName()).withEmbeddingColumnName(properties.getEmbeddingFieldName()).withIndexName(properties.getIndexName());
        if (properties.getDisallowSchemaCreation().booleanValue()) {
            builder = builder.disallowSchemaChanges();
        }
        return new CassandraVectorStore(builder.build(), embeddingClient);
    }

    private static class PropertiesCassandraConnectionDetails
    implements CassandraConnectionDetails {
        private final CassandraVectorStoreProperties properties;

        public PropertiesCassandraConnectionDetails(CassandraVectorStoreProperties properties) {
            this.properties = properties;
        }

        private String[] getCassandraContactPointHosts() {
            return this.properties.getCassandraContactPointHosts().split("(,| )");
        }

        @Override
        public List<InetSocketAddress> getCassandraContactPoints() {
            Preconditions.checkState((boolean)this.hasCassandraContactPoints(), (Object)"cassandraContactPointHosts has not been set");
            int port = this.properties.getCassandraContactPointPort();
            return Arrays.asList(this.getCassandraContactPointHosts()).stream().map(host -> InetSocketAddress.createUnresolved(host, port)).toList();
        }

        @Override
        public String getCassandraLocalDatacenter() {
            Preconditions.checkState((boolean)this.hasCassandraLocalDatacenter(), (Object)"cassandraLocalDatacenter has not been set");
            return this.properties.getCassandraLocalDatacenter();
        }

        @Override
        public boolean hasCassandraContactPoints() {
            return null != this.properties.getCassandraContactPointHosts();
        }

        @Override
        public boolean hasCassandraLocalDatacenter() {
            return null != this.properties.getCassandraLocalDatacenter();
        }
    }
}

