/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.qwen;

import org.springframework.ai.autoconfigure.qwen.QWenAiParentProperties;
import org.springframework.ai.document.MetadataMode;
import org.springframework.ai.qwen.QWenAiEmbeddingOptions;
import org.springframework.ai.qwen.api.QWenAiApi;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@ConfigurationProperties(value="spring.ai.qwen.embedding")
public class QWenAiEmbeddingProperties
extends QWenAiParentProperties {
    public static final String CONFIG_PREFIX = "spring.ai.qwen.embedding";
    public static final String DEFAULT_EMBEDDING_MODEL = QWenAiApi.EmbeddingModel.V2.getValue();
    public static final String DEFAULT_ENCODING_FORMAT = "float";
    private boolean enabled = true;
    public MetadataMode metadataMode = MetadataMode.EMBED;
    @NestedConfigurationProperty
    private QWenAiEmbeddingOptions options = QWenAiEmbeddingOptions.builder().withModel(DEFAULT_EMBEDDING_MODEL).withEncodingFormat("float").build();

    public QWenAiEmbeddingProperties() {
        super.setBaseUrl("https://dashscope.aliyuncs.com");
    }

    public QWenAiEmbeddingOptions getOptions() {
        return this.options;
    }

    public void setOptions(QWenAiEmbeddingOptions options) {
        this.options = options;
    }

    public MetadataMode getMetadataMode() {
        return this.metadataMode;
    }

    public void setMetadataMode(MetadataMode metadataMode) {
        this.metadataMode = metadataMode;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

