/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.mistralai;

import org.springframework.ai.autoconfigure.mistralai.MistralAiParentProperties;
import org.springframework.ai.mistralai.MistralAiChatOptions;
import org.springframework.ai.mistralai.api.MistralAiApi;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@ConfigurationProperties(value="spring.ai.mistralai.chat")
public class MistralAiChatProperties
extends MistralAiParentProperties {
    public static final String CONFIG_PREFIX = "spring.ai.mistralai.chat";
    public static final String DEFAULT_CHAT_MODEL = MistralAiApi.ChatModel.TINY.getValue();
    private static final Double DEFAULT_TEMPERATURE = 0.7;
    private static final Float DEFAULT_TOP_P = Float.valueOf(1.0f);
    private static final Boolean IS_ENABLED = false;
    private boolean enabled = true;
    @NestedConfigurationProperty
    private MistralAiChatOptions options = MistralAiChatOptions.builder().withModel(DEFAULT_CHAT_MODEL).withTemperature(Float.valueOf(DEFAULT_TEMPERATURE.floatValue())).withSafePrompt(Boolean.valueOf(IS_ENABLED == false)).withTopP(DEFAULT_TOP_P).build();

    public MistralAiChatProperties() {
        super.setBaseUrl("https://api.mistral.ai");
    }

    public MistralAiChatOptions getOptions() {
        return this.options;
    }

    public void setOptions(MistralAiChatOptions options) {
        this.options = options;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

