/*
 * Decompiled with CFR 0.152.
 */
package io.spring.nohttp;

import io.spring.nohttp.HttpMatchResult;
import io.spring.nohttp.HttpMatcher;
import io.spring.nohttp.HttpReplaceResult;
import io.spring.nohttp.HttpReplacer;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexHttpMatcher
implements HttpMatcher,
HttpReplacer {
    private Pattern pattern = Pattern.compile("\\b(http\\\\?://[-a-zA-Z0-9+&@/%?=~_|!:,.;]*[-a-zA-Z0-9+&@/%=~_|])");
    private Function<String, String> httpReplacer = httpUrl -> httpUrl.replaceFirst("http", "https");
    private Predicate<String> allow;

    public RegexHttpMatcher(Predicate<String> allow) {
        if (allow == null) {
            throw new IllegalArgumentException("allow cannot be null");
        }
        this.allow = allow;
    }

    public void setPattern(Pattern pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("pattern cannot be null");
        }
        this.pattern = pattern;
    }

    public void setHttpReplacer(Function<String, String> httpReplacer) {
        if (httpReplacer == null) {
            throw new IllegalArgumentException("httpReplacer cannot be null");
        }
        this.httpReplacer = httpReplacer;
    }

    @Override
    public List<HttpMatchResult> findHttp(String text) {
        return this.replaceHttp(text, NoOpWriter.INSTANCE).getMatches();
    }

    @Override
    public HttpReplaceResult replaceHttp(String text) {
        StringWriter writer = new StringWriter();
        return this.replaceHttp(text, writer);
    }

    private HttpReplaceResult replaceHttp(String text, Writer writer) {
        Matcher matcher = this.pattern.matcher(text);
        int currentStart = 0;
        int length = text.length();
        ArrayList<HttpMatchResult> results = new ArrayList<HttpMatchResult>();
        while (matcher.find() && currentStart < length) {
            String replacementUrl;
            String httpUrl = matcher.group();
            if (this.allow.test(httpUrl) || httpUrl.equals(replacementUrl = this.httpReplacer.apply(httpUrl))) continue;
            try {
                writer.append(text, currentStart, matcher.start());
                writer.append(replacementUrl);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            currentStart = matcher.end();
            results.add(new HttpMatchResult(httpUrl, matcher.start()));
        }
        if (currentStart < length) {
            try {
                writer.append(text, currentStart, length);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return new HttpReplaceResult(results, writer.toString());
    }

    public void addHttpAllow(Predicate<String> allow) {
        if (allow == null) {
            throw new IllegalArgumentException("allow cannot be null");
        }
        this.allow = this.allow.or(allow);
    }

    public void addHttpWhitelist(Predicate<String> whitelist) {
        this.addHttpAllow(whitelist);
    }

    private static class NoOpWriter
    extends Writer {
        public static final NoOpWriter INSTANCE = new NoOpWriter();

        private NoOpWriter() {
        }

        @Override
        public Writer append(char c) {
            return this;
        }

        @Override
        public Writer append(CharSequence csq, int start, int end) {
            return this;
        }

        @Override
        public Writer append(CharSequence csq) {
            return this;
        }

        @Override
        public void write(int idx) {
        }

        @Override
        public void write(char[] chr) {
        }

        @Override
        public void write(char[] chr, int st, int end) {
        }

        @Override
        public void write(String str) {
        }

        @Override
        public void write(String str, int st, int end) {
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }
    }
}

