/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.javadoc;

import java.io.File;
import java.util.function.Consumer;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationPublications;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.DocsType;
import org.gradle.api.attributes.Usage;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;

public class JavadocPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPlugins().withType(JavaPlugin.class).all(javaPlugin -> this.withSourcesElements(project));
    }

    private void withSourcesElements(final Project project) {
        project.getConfigurations().create("sourcesElements", (Action)new Action<Configuration>(){

            public void execute(Configuration config) {
                config.setCanBeResolved(false);
                config.setCanBeConsumed(true);
                config.attributes((Action)new Action<AttributeContainer>(){

                    public void execute(AttributeContainer attributes) {
                        ObjectFactory objects = project.getObjects();
                        attributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)objects.named(Usage.class, "java-runtime"));
                        attributes.attribute(Category.CATEGORY_ATTRIBUTE, (Object)objects.named(Category.class, "documentation"));
                        attributes.attribute(DocsType.DOCS_TYPE_ATTRIBUTE, (Object)objects.named(DocsType.class, "sources"));
                        attributes.attribute(Attribute.of((String)"org.gradle.docselements", String.class), (Object)"sources");
                    }
                });
                config.outgoing((Action)new Action<ConfigurationPublications>(){

                    public void execute(final ConfigurationPublications publications) {
                        JavaPluginConvention javaPlugin = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
                        SourceSet mainSrc = (SourceSet)javaPlugin.getSourceSets().getByName("main");
                        mainSrc.getAllJava().getSrcDirs().forEach(new Consumer<File>(){

                            @Override
                            public void accept(File file) {
                                publications.artifact((Object)file);
                            }
                        });
                    }
                });
            }
        });
    }
}

