/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.dependencymanagement.internal;

import io.spring.gradle.dependencymanagement.internal.Exclusion;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class Exclusions {
    private final Map<String, Set<Exclusion>> exclusionsByDependency = new HashMap<String, Set<Exclusion>>();

    Exclusions() {
    }

    void add(String dependency, Collection<Exclusion> exclusionsForDependency) {
        if (exclusionsForDependency.isEmpty()) {
            return;
        }
        this.exclusionsByDependency.computeIfAbsent(dependency, key -> new HashSet()).addAll(exclusionsForDependency);
    }

    void addAll(Exclusions exclusions) {
        exclusions.exclusionsByDependency.forEach(this::add);
    }

    Set<Exclusion> exclusionsForDependency(String dependency) {
        return this.exclusionsByDependency.get(dependency);
    }

    public String toString() {
        return this.exclusionsByDependency.toString();
    }
}

