/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.dependencymanagement.internal;

import io.spring.gradle.dependencymanagement.internal.DependencyManagementContainer;
import io.spring.gradle.dependencymanagement.internal.Versions;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyResolveDetails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class VersionConfiguringAction
implements Action<DependencyResolveDetails> {
    private static final Logger logger = LoggerFactory.getLogger(VersionConfiguringAction.class);
    private final Project project;
    private final DependencyManagementContainer dependencyManagementContainer;
    private final Configuration configuration;
    private Set<String> directDependencies;

    VersionConfiguringAction(Project project, DependencyManagementContainer dependencyManagementContainer, Configuration configuration) {
        this.project = project;
        this.dependencyManagementContainer = dependencyManagementContainer;
        this.configuration = configuration;
    }

    public void execute(DependencyResolveDetails details) {
        logger.debug("Processing dependency '{}'", (Object)details.getRequested());
        if (this.isDependencyOnLocalProject(this.project, details)) {
            logger.debug("'{}' is a local project dependency. Dependency management has not been applied", (Object)details.getRequested());
            return;
        }
        if (this.isDirectDependency(details) && Versions.isDynamic(details.getRequested().getVersion())) {
            logger.debug("'{}' is a direct dependency and has a dynamic version. Dependency management has not been applied", (Object)details.getRequested());
            return;
        }
        String version = this.dependencyManagementContainer.getManagedVersion(this.configuration, details.getRequested().getGroup(), details.getRequested().getName());
        if (version != null) {
            logger.debug("Using version '{}' for dependency '{}'", (Object)version, (Object)details.getRequested());
            details.useVersion(version);
        } else {
            logger.debug("No dependency management for dependency '{}'", (Object)details.getRequested());
        }
    }

    private boolean isDirectDependency(DependencyResolveDetails details) {
        if (this.directDependencies == null) {
            HashSet<String> directDependencies = new HashSet<String>();
            for (Dependency dependency : this.configuration.getDependencies()) {
                directDependencies.add(dependency.getGroup() + ":" + dependency.getName());
            }
            this.directDependencies = directDependencies;
        }
        return this.directDependencies.contains(details.getRequested().getGroup() + ":" + details.getRequested().getName());
    }

    private boolean isDependencyOnLocalProject(Project project, DependencyResolveDetails details) {
        return this.getAllLocalProjectNames(project.getRootProject()).contains(details.getRequested().getGroup() + ":" + details.getRequested().getName());
    }

    private Set<String> getAllLocalProjectNames(Project rootProject) {
        HashSet<String> names = new HashSet<String>();
        for (Project localProject : rootProject.getAllprojects()) {
            names.add(localProject.getGroup() + ":" + localProject.getName());
        }
        return names;
    }
}

