/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.antora;

import io.spring.gradle.antora.GenerateAntoraYmlTask;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.RegularFile;

public class GenerateAntoraYmlPlugin
implements Plugin<Project> {
    public void apply(final Project project) {
        project.getTasks().register("generateAntoraYml", GenerateAntoraYmlTask.class, (Action)new Action<GenerateAntoraYmlTask>(){

            public void execute(GenerateAntoraYmlTask generateAntoraYmlTask) {
                RegularFile defaultBaseAntoraYmlFile;
                String projectVersion;
                generateAntoraYmlTask.setGroup("Documentation");
                generateAntoraYmlTask.setDescription("Generates an antora.yml file with information from the build");
                String name = project.getName();
                generateAntoraYmlTask.getComponentName().convention((Object)name);
                String string = projectVersion = project.getVersion() == null ? null : project.getVersion().toString();
                if (!"unspecified".equals(projectVersion)) {
                    generateAntoraYmlTask.getVersion().convention((Object)projectVersion);
                }
                if ((defaultBaseAntoraYmlFile = project.getLayout().getProjectDirectory().file("antora.yml")).getAsFile().exists()) {
                    generateAntoraYmlTask.getBaseAntoraYmlFile().convention(defaultBaseAntoraYmlFile);
                }
                generateAntoraYmlTask.getOutputFile().convention(project.getLayout().getBuildDirectory().file("generated-antora-resources/antora.yml"));
            }
        });
    }
}

