/*
 * Decompiled with CFR 0.152.
 */
package io.split.client.impressions;

import io.split.client.impressions.Impression;
import io.split.client.utils.MurmurHash3;

public class ImpressionHasher {
    private static final String HASHABLE_FORMAT = "%s:%s:%s:%s:%d";
    private static final String UNKNOWN = "UNKNOWN";

    private static String unknownIfNull(String s2) {
        return s2 == null ? UNKNOWN : s2;
    }

    private static Long zeroIfNull(Long l) {
        return l == null ? 0L : l;
    }

    public static Long process(Impression impression) {
        if (null == impression) {
            return null;
        }
        return MurmurHash3.hash128x64(String.format(HASHABLE_FORMAT, ImpressionHasher.unknownIfNull(impression.key()), ImpressionHasher.unknownIfNull(impression.split()), ImpressionHasher.unknownIfNull(impression.treatment()), ImpressionHasher.unknownIfNull(impression.appliedRule()), ImpressionHasher.zeroIfNull(impression.changeNumber())).getBytes())[0];
    }
}

