/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.plugins.proxy.aspects;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.DefaultRegistry;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.kork.annotations.Metered;
import com.netflix.spinnaker.kork.plugins.SpinnakerPluginDescriptor;
import com.netflix.spinnaker.kork.plugins.api.internal.SpinnakerExtensionPoint;
import com.netflix.spinnaker.kork.plugins.proxy.aspects.InvocationAspect;
import com.netflix.spinnaker.kork.plugins.proxy.aspects.InvocationState;
import com.netflix.spinnaker.kork.plugins.proxy.aspects.MetricInvocationState;
import com.netflix.spinnaker.kork.telemetry.MethodInstrumentation;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\u0018\u0000 32\b\u0012\u0004\u0012\u00020\u00020\u0001:\u000234B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J?\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00102\u0010\u0010\u001b\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0019\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016\u00a2\u0006\u0002\u0010\u001fJ\u0018\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J\u0018\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0014\u001a\u00020\u0002H\u0002J\u0016\u0010&\u001a\u00020'2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020)0(H\u0016J,\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010,\u001a\u00020+2\b\u0010-\u001a\u0004\u0018\u00010+2\u0006\u0010.\u001a\u00020+H\u0002J\u001a\u0010/\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u00100\u001a\u00020+H\u0002J:\u00101\u001a\u0004\u0018\u00010\u0011*\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u0016\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u00102\u001a\u00020\u0005H\u0002R#\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/netflix/spinnaker/kork/plugins/proxy/aspects/MetricInvocationAspect;", "Lcom/netflix/spinnaker/kork/plugins/proxy/aspects/InvocationAspect;", "Lcom/netflix/spinnaker/kork/plugins/proxy/aspects/MetricInvocationState;", "registryProvider", "Lorg/springframework/beans/factory/ObjectProvider;", "Lcom/netflix/spectator/api/Registry;", "(Lorg/springframework/beans/factory/ObjectProvider;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "methodMetricIds", "Lcom/github/benmanes/caffeine/cache/Cache;", "Ljava/lang/reflect/Method;", "Lcom/netflix/spinnaker/kork/plugins/proxy/aspects/MetricInvocationAspect$MetricIds;", "after", "", "invocationState", "before", "target", "Lcom/netflix/spinnaker/kork/plugins/api/internal/SpinnakerExtensionPoint;", "proxy", "", "method", "args", "", "descriptor", "Lcom/netflix/spinnaker/kork/plugins/SpinnakerPluginDescriptor;", "(Lcom/netflix/spinnaker/kork/plugins/api/internal/SpinnakerExtensionPoint;Ljava/lang/Object;Ljava/lang/reflect/Method;[Ljava/lang/Object;Lcom/netflix/spinnaker/kork/plugins/SpinnakerPluginDescriptor;)Lcom/netflix/spinnaker/kork/plugins/proxy/aspects/MetricInvocationState;", "error", "e", "Ljava/lang/reflect/InvocationTargetException;", "recordMetrics", "result", "Lcom/netflix/spinnaker/kork/plugins/proxy/aspects/MetricInvocationAspect$Companion$Result;", "supports", "", "Ljava/lang/Class;", "Lcom/netflix/spinnaker/kork/plugins/proxy/aspects/InvocationState;", "toMetricId", "", "metricNamespace", "annotationMetricId", "metricName", "getOrFallback", "extensionName", "getOrPut", "registry", "Companion", "MetricIds", "kork-plugins"})
public final class MetricInvocationAspect
implements InvocationAspect<MetricInvocationState> {
    private final Lazy log$delegate;
    private final Cache<Method, MetricIds> methodMetricIds;
    private final ObjectProvider<Registry> registryProvider;
    private static final String TIMING = "timing";
    private static final long MAX_CACHE_SIZE = 1000L;
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final Logger getLog() {
        Lazy lazy = this.log$delegate;
        MetricInvocationAspect metricInvocationAspect = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Logger)lazy.getValue();
    }

    private final Registry getOrFallback(ObjectProvider<Registry> $this$getOrFallback, String extensionName) {
        Registry registry = (Registry)$this$getOrFallback.getIfAvailable();
        if (registry == null) {
            this.getLog().warn("Returning fallback registry for extension={}; metrics collected in fallback are discarded.", (Object)extensionName);
            return (Registry)new DefaultRegistry(Clock.SYSTEM);
        }
        return registry;
    }

    @Override
    public boolean supports(@NotNull Class<InvocationState> invocationState) {
        Intrinsics.checkNotNullParameter(invocationState, (String)"invocationState");
        return Intrinsics.areEqual(invocationState, MetricInvocationState.class);
    }

    @Override
    @NotNull
    public MetricInvocationState before(@NotNull SpinnakerExtensionPoint target, @NotNull Object proxy, @NotNull Method method, @Nullable Object[] args, @NotNull SpinnakerPluginDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)((Object)descriptor), (String)"descriptor");
        String extensionName = target.getClass().getSimpleName().toString();
        Registry registry = this.getOrFallback(this.registryProvider, extensionName);
        MetricIds metricIds = this.getOrPut(this.methodMetricIds, target, method, descriptor, registry);
        MetricIds metricIds2 = metricIds;
        return new MetricInvocationState(extensionName, System.currentTimeMillis(), (Id)(metricIds2 != null ? metricIds2.getTimingId() : null));
    }

    @Override
    public void after(@NotNull MetricInvocationState invocationState) {
        Intrinsics.checkNotNullParameter((Object)invocationState, (String)"invocationState");
        this.recordMetrics(Companion.Result.SUCCESS, invocationState);
    }

    @Override
    public void error(@NotNull InvocationTargetException e, @NotNull MetricInvocationState invocationState) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)invocationState, (String)"invocationState");
        this.recordMetrics(Companion.Result.FAILURE, invocationState);
    }

    private final void recordMetrics(Companion.Result result, MetricInvocationState invocationState) {
        if (invocationState.getTimingId$kork_plugins() != null) {
            Registry registry = this.getOrFallback(this.registryProvider, invocationState.getExtensionName$kork_plugins());
            registry.timer(invocationState.getTimingId$kork_plugins().withTag("result", result.toString())).record(System.currentTimeMillis() - invocationState.getStartTimeMs$kork_plugins(), TimeUnit.MILLISECONDS);
        }
    }

    private final MetricIds getOrPut(Cache<Method, MetricIds> $this$getOrPut, Object target, Method method, SpinnakerPluginDescriptor descriptor, Registry registry) {
        Class<?>[] classArray = method.getParameterTypes();
        return (MetricIds)$this$getOrPut.get((Object)target.getClass().getMethod(method.getName(), Arrays.copyOf(classArray, classArray.length)), (Function)new Function<Method, MetricIds>(this, $this$getOrPut, descriptor, target, method, registry){
            final /* synthetic */ MetricInvocationAspect this$0;
            final /* synthetic */ Cache $this_getOrPut;
            final /* synthetic */ SpinnakerPluginDescriptor $descriptor;
            final /* synthetic */ Object $target;
            final /* synthetic */ Method $method;
            final /* synthetic */ Registry $registry;

            public final MetricIds apply(Method m) {
                MetricIds metricIds;
                Annotation annotation;
                boolean bl;
                Annotation[] annotationArray;
                block6: {
                    Method method = m;
                    Intrinsics.checkNotNullExpressionValue((Object)method, (String)"m");
                    Annotation[] annotationArray2 = method.getDeclaredAnnotations();
                    Intrinsics.checkNotNullExpressionValue((Object)annotationArray2, (String)"m.declaredAnnotations");
                    annotationArray = annotationArray2;
                    bl = false;
                    Annotation[] annotationArray3 = annotationArray;
                    boolean bl2 = false;
                    Annotation[] annotationArray4 = annotationArray3;
                    int n = annotationArray4.length;
                    for (int i = 0; i < n; ++i) {
                        Annotation annotation2;
                        Annotation it = annotation2 = annotationArray4[i];
                        boolean bl3 = false;
                        if (!(it instanceof Metered)) continue;
                        annotation = annotation2;
                        break block6;
                    }
                    annotation = null;
                }
                annotationArray = annotation;
                bl = false;
                boolean bl4 = false;
                Annotation[] metered = annotationArray;
                boolean bl5 = false;
                if (metered != null) {
                    Metered cfr_ignored_0 = (Metered)metered;
                    if (((Metered)metered).ignore()) {
                        metricIds = null;
                    } else {
                        Map defaultTags = MapsKt.mapOf((Pair[])new Pair[]{new Pair((Object)"pluginVersion", (Object)this.$descriptor.getVersion()), new Pair((Object)"pluginExtension", (Object)this.$target.getClass().getSimpleName().toString())});
                        Map tags = MethodInstrumentation.coalesceTags((Object)this.$target, (Method)this.$method, (Map)defaultTags, (String[])((Metered)metered).tags());
                        String string = this.$descriptor.getPluginId();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"descriptor.pluginId");
                        Id id = this.$registry.createId(MetricInvocationAspect.access$toMetricId(this.this$0, m, string, ((Metered)metered).metricName(), "timing"), tags);
                        Intrinsics.checkNotNullExpressionValue((Object)id, (String)"registry.createId(toMetr\u2026etricName, TIMING), tags)");
                        MetricIds metricIds2 = new MetricIds(id);
                        ConcurrentMap concurrentMap = this.$this_getOrPut.asMap();
                        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"this.asMap()");
                        Map map = concurrentMap;
                        boolean bl6 = false;
                        for (Map.Entry<K, V> mutableEntry : map.entrySet()) {
                            if (!Intrinsics.areEqual((Object)((MetricIds)mutableEntry.getValue()).getTimingId().name(), (Object)metricIds2.getTimingId().name())) continue;
                            throw (Throwable)new MethodInstrumentation.MetricNameCollisionException(this.$target, metricIds2.getTimingId().name(), (Method)mutableEntry.getKey(), m);
                        }
                        metricIds = metricIds2;
                    }
                } else {
                    metricIds = null;
                }
                return metricIds;
            }
            {
                this.this$0 = metricInvocationAspect;
                this.$this_getOrPut = cache;
                this.$descriptor = spinnakerPluginDescriptor;
                this.$target = object;
                this.$method = method;
                this.$registry = registry;
            }
        });
    }

    private final String toMetricId(Method method, String metricNamespace, String annotationMetricId, String metricName) {
        Object object;
        String string;
        if (method.getParameterCount() == 0) {
            string = method.getName();
        } else {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            object = Locale.US;
            String string2 = "%s%d";
            Object[] objectArray = new Object[]{method.getName(), method.getParameterCount()};
            boolean bl = false;
            String string3 = String.format((Locale)object, string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(locale, format, *args)");
        }
        String methodMetricId = string;
        object = annotationMetricId;
        boolean bl = false;
        boolean bl2 = false;
        String metricId = object == null || object.length() == 0 ? methodMetricId : annotationMetricId;
        return MethodInstrumentation.toMetricId((String)metricNamespace, (String)metricId, (String)metricName);
    }

    public MetricInvocationAspect(@NotNull ObjectProvider<Registry> registryProvider) {
        Intrinsics.checkNotNullParameter(registryProvider, (String)"registryProvider");
        this.registryProvider = registryProvider;
        this.log$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Logger>(this){
            final /* synthetic */ MetricInvocationAspect this$0;

            public final Logger invoke() {
                return LoggerFactory.getLogger(this.this$0.getClass());
            }
            {
                this.this$0 = metricInvocationAspect;
                super(0);
            }
        }));
        Cache cache = Caffeine.newBuilder().maximumSize(1000L).expireAfterWrite(1L, TimeUnit.HOURS).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"Caffeine.newBuilder()\n  \u2026uild<Method, MetricIds>()");
        this.methodMetricIds = cache;
    }

    @Override
    public void finally(@NotNull MetricInvocationState invocationState) {
        Intrinsics.checkNotNullParameter((Object)invocationState, (String)"invocationState");
        InvocationAspect.DefaultImpls.finally(this, (InvocationState)invocationState);
    }

    public static final /* synthetic */ String access$toMetricId(MetricInvocationAspect $this, Method method, String metricNamespace, String annotationMetricId, String metricName) {
        return $this.toMetricId(method, metricNamespace, annotationMetricId, metricName);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/netflix/spinnaker/kork/plugins/proxy/aspects/MetricInvocationAspect$MetricIds;", "", "timingId", "Lcom/netflix/spectator/api/Id;", "(Lcom/netflix/spectator/api/Id;)V", "getTimingId", "()Lcom/netflix/spectator/api/Id;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kork-plugins"})
    private static final class MetricIds {
        @NotNull
        private final Id timingId;

        @NotNull
        public final Id getTimingId() {
            return this.timingId;
        }

        public MetricIds(@NotNull Id timingId) {
            Intrinsics.checkNotNullParameter((Object)timingId, (String)"timingId");
            this.timingId = timingId;
        }

        @NotNull
        public final Id component1() {
            return this.timingId;
        }

        @NotNull
        public final MetricIds copy(@NotNull Id timingId) {
            Intrinsics.checkNotNullParameter((Object)timingId, (String)"timingId");
            return new MetricIds(timingId);
        }

        public static /* synthetic */ MetricIds copy$default(MetricIds metricIds, Id id, int n, Object object) {
            if ((n & 1) != 0) {
                id = metricIds.timingId;
            }
            return metricIds.copy(id);
        }

        @NotNull
        public String toString() {
            return "MetricIds(timingId=" + this.timingId + ")";
        }

        public int hashCode() {
            Id id = this.timingId;
            return id != null ? id.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof MetricIds)) break block3;
                    MetricIds metricIds = (MetricIds)object;
                    if (!Intrinsics.areEqual((Object)this.timingId, (Object)metricIds.timingId)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0007B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/netflix/spinnaker/kork/plugins/proxy/aspects/MetricInvocationAspect$Companion;", "", "()V", "MAX_CACHE_SIZE", "", "TIMING", "", "Result", "kork-plugins"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/netflix/spinnaker/kork/plugins/proxy/aspects/MetricInvocationAspect$Companion$Result;", "", "(Ljava/lang/String;I)V", "toString", "", "SUCCESS", "FAILURE", "kork-plugins"})
        public static final class Result
        extends Enum<Result> {
            public static final /* enum */ Result SUCCESS;
            public static final /* enum */ Result FAILURE;
            private static final /* synthetic */ Result[] $VALUES;

            static {
                Result[] resultArray = new Result[2];
                Result[] resultArray2 = resultArray;
                resultArray[0] = SUCCESS = new Result();
                resultArray[1] = FAILURE = new Result();
                $VALUES = resultArray;
            }

            @NotNull
            public String toString() {
                String string = this.name();
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
                return string3;
            }

            public static Result[] values() {
                return (Result[])$VALUES.clone();
            }

            public static Result valueOf(String string) {
                return Enum.valueOf(Result.class, string);
            }
        }
    }
}

