/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.plugins.actuator;

import com.netflix.spinnaker.kork.plugins.SpinnakerPluginManager;
import com.netflix.spinnaker.kork.plugins.actuator.InstalledPluginsEndpoint;
import com.netflix.spinnaker.kork.web.exceptions.NotFoundException;
import java.util.List;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.pf4j.PluginDescriptor;
import org.pf4j.PluginWrapper;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;

@Endpoint(id="installedPlugins")
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0007J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/netflix/spinnaker/kork/plugins/actuator/InstalledPluginsEndpoint;", "", "pluginManager", "Lcom/netflix/spinnaker/kork/plugins/SpinnakerPluginManager;", "(Lcom/netflix/spinnaker/kork/plugins/SpinnakerPluginManager;)V", "pluginById", "Lorg/pf4j/PluginDescriptor;", "pluginId", "", "plugins", "", "kork-plugins"})
public final class InstalledPluginsEndpoint {
    private final SpinnakerPluginManager pluginManager;

    @ReadOperation
    @NotNull
    public final List<PluginDescriptor> plugins() {
        List<PluginDescriptor> list = this.pluginManager.getPlugins().stream().map(plugins.1.INSTANCE).collect(Collectors.toList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"pluginManager.plugins.st\u2026lect(Collectors.toList())");
        return list;
    }

    @ReadOperation
    @NotNull
    public final PluginDescriptor pluginById(@Selector @NotNull String pluginId) {
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        PluginWrapper pluginWrapper = this.pluginManager.getPlugin(pluginId);
        if (pluginWrapper == null) {
            throw (Throwable)new NotFoundException("Plugin not found: " + pluginId);
        }
        PluginWrapper pluginWrapper2 = pluginWrapper;
        PluginDescriptor pluginDescriptor = pluginWrapper2.getDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)pluginDescriptor, (String)"pluginWrapper.descriptor");
        return pluginDescriptor;
    }

    public InstalledPluginsEndpoint(@NotNull SpinnakerPluginManager pluginManager) {
        Intrinsics.checkNotNullParameter((Object)((Object)pluginManager), (String)"pluginManager");
        this.pluginManager = pluginManager;
    }
}

