/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.plugins;

import com.netflix.spinnaker.kork.exceptions.IntegrationException;
import com.netflix.spinnaker.kork.plugins.DslKt;
import com.netflix.spinnaker.kork.plugins.SpinnakerPluginDescriptor;
import com.netflix.spinnaker.kork.plugins.SpinnakerPluginManager;
import com.netflix.spinnaker.kork.plugins.SpringPluginStatusProvider;
import com.netflix.spinnaker.kork.plugins.api.internal.SpinnakerExtensionPoint;
import com.netflix.spinnaker.kork.plugins.api.spring.PrivilegedSpringPlugin;
import com.netflix.spinnaker.kork.plugins.events.ExtensionLoaded;
import com.netflix.spinnaker.kork.plugins.proxy.ExtensionInvocationProxy;
import com.netflix.spinnaker.kork.plugins.proxy.aspects.InvocationAspect;
import com.netflix.spinnaker.kork.plugins.update.SpinnakerUpdateManager;
import com.netflix.spinnaker.kork.plugins.update.internal.SpinnakerPluginInfo;
import com.netflix.spinnaker.kork.plugins.update.release.PluginInfoRelease;
import com.netflix.spinnaker.kork.plugins.update.release.provider.PluginInfoReleaseProvider;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.pf4j.Plugin;
import org.pf4j.PluginDescriptor;
import org.pf4j.PluginWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0010\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\r\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/netflix/spinnaker/kork/plugins/ExtensionBeanDefinitionRegistryPostProcessor;", "Lorg/springframework/beans/factory/support/BeanDefinitionRegistryPostProcessor;", "pluginManager", "Lcom/netflix/spinnaker/kork/plugins/SpinnakerPluginManager;", "updateManager", "Lcom/netflix/spinnaker/kork/plugins/update/SpinnakerUpdateManager;", "pluginInfoReleaseProvider", "Lcom/netflix/spinnaker/kork/plugins/update/release/provider/PluginInfoReleaseProvider;", "springPluginStatusProvider", "Lcom/netflix/spinnaker/kork/plugins/SpringPluginStatusProvider;", "applicationEventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "invocationAspects", "", "Lcom/netflix/spinnaker/kork/plugins/proxy/aspects/InvocationAspect;", "(Lcom/netflix/spinnaker/kork/plugins/SpinnakerPluginManager;Lcom/netflix/spinnaker/kork/plugins/update/SpinnakerUpdateManager;Lcom/netflix/spinnaker/kork/plugins/update/release/provider/PluginInfoReleaseProvider;Lcom/netflix/spinnaker/kork/plugins/SpringPluginStatusProvider;Lorg/springframework/context/ApplicationEventPublisher;Ljava/util/List;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "postProcessBeanDefinitionRegistry", "", "registry", "Lorg/springframework/beans/factory/support/BeanDefinitionRegistry;", "postProcessBeanFactory", "beanFactory", "Lorg/springframework/beans/factory/config/ConfigurableListableBeanFactory;", "kork-plugins"})
public final class ExtensionBeanDefinitionRegistryPostProcessor
implements BeanDefinitionRegistryPostProcessor {
    private final Lazy log$delegate;
    private final SpinnakerPluginManager pluginManager;
    private final SpinnakerUpdateManager updateManager;
    private final PluginInfoReleaseProvider pluginInfoReleaseProvider;
    private final SpringPluginStatusProvider springPluginStatusProvider;
    private final ApplicationEventPublisher applicationEventPublisher;
    private final List<InvocationAspect<?>> invocationAspects;

    private final Logger getLog() {
        Lazy lazy = this.log$delegate;
        ExtensionBeanDefinitionRegistryPostProcessor extensionBeanDefinitionRegistryPostProcessor = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Logger)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public void postProcessBeanDefinitionRegistry(@NotNull BeanDefinitionRegistry registry) {
        void $this$filterTo$iv$iv;
        List $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        long start = System.currentTimeMillis();
        this.getLog().debug("Preparing plugins");
        this.pluginManager.loadPlugins();
        Iterable iterable = this.updateManager.getPlugins();
        boolean $i$f$filter = false;
        void var7_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SpinnakerPluginInfo it = (SpinnakerPluginInfo)((Object)element$iv$iv);
            boolean bl = false;
            String string = it.id;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.id");
            if (!this.springPluginStatusProvider.isPluginEnabled(string)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        boolean bl = false;
        List enabledPlugins = $this$filter$iv;
        boolean bl2 = false;
        Set<PluginInfoRelease> releases = this.pluginInfoReleaseProvider.getReleases(enabledPlugins);
        Iterable $this$forEach$iv = this.updateManager.downloadPluginReleases$kork_plugins(releases);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Path pluginPath = (Path)element$iv;
            boolean bl3 = false;
            this.pluginManager.loadPlugin(pluginPath);
        }
        this.pluginManager.startPlugins();
        List list = this.pluginManager.getStartedPlugins();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"pluginManager.startedPlugins");
        $this$forEach$iv = list;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PluginWrapper pluginWrapper = (PluginWrapper)element$iv;
            boolean bl4 = false;
            PluginWrapper pluginWrapper2 = pluginWrapper;
            Intrinsics.checkNotNullExpressionValue((Object)pluginWrapper2, (String)"pluginWrapper");
            Plugin p = pluginWrapper2.getPlugin();
            if (!(p instanceof PrivilegedSpringPlugin)) continue;
            ((PrivilegedSpringPlugin)p).registerBeanDefinitions(registry);
        }
        this.getLog().debug("Finished preparing plugins in {}ms", (Object)(System.currentTimeMillis() - start));
    }

    public void postProcessBeanFactory(@NotNull ConfigurableListableBeanFactory beanFactory) {
        Object beanName;
        Intrinsics.checkNotNullParameter((Object)beanFactory, (String)"beanFactory");
        Set set = this.pluginManager.getExtensionClassNames(null);
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"pluginManager.getExtensionClassNames(null)");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Class<?> clazz;
            String it = (String)element$iv;
            boolean bl = false;
            this.getLog().debug("Creating extension '{}'", (Object)it);
            try {
                clazz = this.getClass().getClassLoader().loadClass(it);
            }
            catch (ClassNotFoundException e) {
                throw (Throwable)new IntegrationException("Could not find system extension class '" + it + '\'', (Throwable)e);
            }
            Class<?> extensionClass = clazz;
            Object bean = this.pluginManager.getExtensionFactory().create(extensionClass);
            StringBuilder stringBuilder = new StringBuilder();
            Class<?> clazz2 = extensionClass;
            Intrinsics.checkNotNullExpressionValue(clazz2, (String)"extensionClass");
            String string = clazz2.getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"extensionClass.simpleName");
            beanName = stringBuilder.append(StringsKt.decapitalize((String)string)).append("SystemExtension").toString();
            beanFactory.registerSingleton((String)beanName, bean);
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new ExtensionLoaded(this, (String)beanName, extensionClass, null, 8, null));
        }
        List list = this.pluginManager.getStartedPlugins();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"pluginManager.startedPlugins");
        $this$forEach$iv = list;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PluginWrapper plugin = (PluginWrapper)element$iv;
            boolean bl = false;
            PluginWrapper pluginWrapper = plugin;
            Intrinsics.checkNotNullExpressionValue((Object)pluginWrapper, (String)"plugin");
            if (DslKt.isUnsafe(pluginWrapper)) continue;
            this.getLog().debug("Creating extensions for plugin '{}'", (Object)plugin.getPluginId());
            Set pluginExtensions = this.pluginManager.getExtensionClassNames(plugin.getPluginId());
            beanName = pluginExtensions;
            boolean extensionClass = false;
            boolean bl2 = false;
            if (beanName == null || beanName.isEmpty()) {
                this.getLog().warn("No extensions found for plugin '{}'", (Object)plugin.getPluginId());
            }
            Set set2 = pluginExtensions;
            Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"pluginExtensions");
            Iterable $this$forEach$iv2 = set2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Object object;
                Class<?> clazz;
                String it = (String)element$iv2;
                boolean bl3 = false;
                this.getLog().debug("Creating extension '{}' for plugin '{}'", (Object)it, (Object)plugin.getPluginId());
                try {
                    clazz = plugin.getPluginClassLoader().loadClass(it);
                }
                catch (ClassNotFoundException e) {
                    throw (Throwable)new IntegrationException("Could not find extension class '" + it + "' for plugin '" + plugin.getPluginId() + '\'', (Throwable)e);
                }
                Class<?> extensionClass2 = clazz;
                Object extensionClassInstance = this.pluginManager.getExtensionFactory().create(extensionClass2);
                if (extensionClassInstance instanceof SpinnakerExtensionPoint) {
                    List<InvocationAspect<?>> list2 = this.invocationAspects;
                    if (list2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<com.netflix.spinnaker.kork.plugins.proxy.aspects.InvocationAspect<com.netflix.spinnaker.kork.plugins.proxy.aspects.InvocationState>>");
                    }
                    PluginDescriptor pluginDescriptor = plugin.getDescriptor();
                    if (pluginDescriptor == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.netflix.spinnaker.kork.plugins.SpinnakerPluginDescriptor");
                    }
                    object = ExtensionInvocationProxy.Companion.proxy((SpinnakerExtensionPoint)extensionClassInstance, list2, (SpinnakerPluginDescriptor)pluginDescriptor);
                } else {
                    object = extensionClassInstance;
                }
                Object bean = object;
                StringBuilder stringBuilder = new StringBuilder();
                String string = plugin.getPluginId();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"plugin.pluginId");
                StringBuilder stringBuilder2 = stringBuilder.append(StringsKt.replace$default((String)string, (String)".", (String)"", (boolean)false, (int)4, null));
                Class<?> clazz3 = extensionClass2;
                Intrinsics.checkNotNullExpressionValue(clazz3, (String)"extensionClass");
                String string2 = clazz3.getSimpleName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"extensionClass.simpleName");
                String beanName2 = stringBuilder2.append(StringsKt.capitalize((String)string2)).toString();
                beanFactory.registerSingleton(beanName2, bean);
                PluginDescriptor pluginDescriptor = plugin.getDescriptor();
                if (pluginDescriptor == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.netflix.spinnaker.kork.plugins.SpinnakerPluginDescriptor");
                }
                this.applicationEventPublisher.publishEvent((ApplicationEvent)new ExtensionLoaded(this, beanName2, extensionClass2, (SpinnakerPluginDescriptor)pluginDescriptor));
            }
        }
    }

    public ExtensionBeanDefinitionRegistryPostProcessor(@NotNull SpinnakerPluginManager pluginManager, @NotNull SpinnakerUpdateManager updateManager, @NotNull PluginInfoReleaseProvider pluginInfoReleaseProvider, @NotNull SpringPluginStatusProvider springPluginStatusProvider, @NotNull ApplicationEventPublisher applicationEventPublisher, @NotNull List<? extends InvocationAspect<?>> invocationAspects) {
        Intrinsics.checkNotNullParameter((Object)((Object)pluginManager), (String)"pluginManager");
        Intrinsics.checkNotNullParameter((Object)((Object)updateManager), (String)"updateManager");
        Intrinsics.checkNotNullParameter((Object)pluginInfoReleaseProvider, (String)"pluginInfoReleaseProvider");
        Intrinsics.checkNotNullParameter((Object)springPluginStatusProvider, (String)"springPluginStatusProvider");
        Intrinsics.checkNotNullParameter((Object)applicationEventPublisher, (String)"applicationEventPublisher");
        Intrinsics.checkNotNullParameter(invocationAspects, (String)"invocationAspects");
        this.pluginManager = pluginManager;
        this.updateManager = updateManager;
        this.pluginInfoReleaseProvider = pluginInfoReleaseProvider;
        this.springPluginStatusProvider = springPluginStatusProvider;
        this.applicationEventPublisher = applicationEventPublisher;
        this.invocationAspects = invocationAspects;
        this.log$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Logger>(this){
            final /* synthetic */ ExtensionBeanDefinitionRegistryPostProcessor this$0;

            public final Logger invoke() {
                return LoggerFactory.getLogger(this.this$0.getClass());
            }
            {
                this.this$0 = extensionBeanDefinitionRegistryPostProcessor;
                super(0);
            }
        }));
    }
}

