/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.plugins.v2;

import com.netflix.spinnaker.kork.plugins.ClassKind;
import com.netflix.spinnaker.kork.plugins.DslKt;
import com.netflix.spinnaker.kork.plugins.api.spring.PrivilegedSpringPlugin;
import com.netflix.spinnaker.kork.plugins.config.ConfigFactory;
import com.netflix.spinnaker.kork.plugins.sdk.SdkFactory;
import com.netflix.spinnaker.kork.plugins.v2.PluginContainer;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pf4j.Plugin;
import org.pf4j.PluginDescriptor;
import org.pf4j.PluginFactory;
import org.pf4j.PluginWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.GenericApplicationContext;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/netflix/spinnaker/kork/plugins/v2/SpringPluginFactory;", "Lorg/pf4j/PluginFactory;", "sdkFactories", "", "Lcom/netflix/spinnaker/kork/plugins/sdk/SdkFactory;", "configFactory", "Lcom/netflix/spinnaker/kork/plugins/config/ConfigFactory;", "serviceApplicationContext", "Lorg/springframework/context/support/GenericApplicationContext;", "(Ljava/util/List;Lcom/netflix/spinnaker/kork/plugins/config/ConfigFactory;Lorg/springframework/context/support/GenericApplicationContext;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "create", "Lorg/pf4j/Plugin;", "pluginWrapper", "Lorg/pf4j/PluginWrapper;", "kork-plugins"})
public final class SpringPluginFactory
implements PluginFactory {
    private final Logger log;
    private final List<SdkFactory> sdkFactories;
    private final ConfigFactory configFactory;
    private final GenericApplicationContext serviceApplicationContext;

    @Nullable
    public Plugin create(@NotNull PluginWrapper pluginWrapper) {
        Class<?> pluginClass;
        Class<?> clazz;
        Intrinsics.checkNotNullParameter((Object)pluginWrapper, (String)"pluginWrapper");
        PluginDescriptor pluginDescriptor = pluginWrapper.getDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)pluginDescriptor, (String)"pluginWrapper.descriptor");
        String pluginClassName = pluginDescriptor.getPluginClass();
        this.log.debug("Creating plugin '" + pluginClassName + '\'');
        try {
            clazz = pluginWrapper.getPluginClassLoader().loadClass(pluginClassName);
        }
        catch (ClassNotFoundException e) {
            this.log.error("Failed to load plugin class for '" + pluginWrapper.getPluginId() + '\'', (Throwable)e);
            return null;
        }
        Class<?> clazz2 = pluginClass = clazz;
        Intrinsics.checkNotNullExpressionValue(clazz2, (String)"pluginClass");
        Object object = DslKt.createWithConstructor(clazz2, ClassKind.PLUGIN, this.sdkFactories, this.configFactory, pluginWrapper);
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.pf4j.Plugin");
        }
        Plugin actualPlugin = (Plugin)object;
        return !(actualPlugin instanceof PrivilegedSpringPlugin) ? (Plugin)new PluginContainer(actualPlugin, this.serviceApplicationContext) : actualPlugin;
    }

    public SpringPluginFactory(@NotNull List<? extends SdkFactory> sdkFactories, @NotNull ConfigFactory configFactory, @NotNull GenericApplicationContext serviceApplicationContext) {
        Intrinsics.checkNotNullParameter(sdkFactories, (String)"sdkFactories");
        Intrinsics.checkNotNullParameter((Object)configFactory, (String)"configFactory");
        Intrinsics.checkNotNullParameter((Object)serviceApplicationContext, (String)"serviceApplicationContext");
        this.sdkFactories = sdkFactories;
        this.configFactory = configFactory;
        this.serviceApplicationContext = serviceApplicationContext;
        this.log = LoggerFactory.getLogger(this.getClass());
    }
}

