/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.plugins.update.release.source;

import com.netflix.spinnaker.kork.plugins.SpringPluginStatusProvider;
import com.netflix.spinnaker.kork.plugins.update.internal.SpinnakerPluginInfo;
import com.netflix.spinnaker.kork.plugins.update.release.PluginInfoRelease;
import com.netflix.spinnaker.kork.plugins.update.release.source.PluginInfoReleaseSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\f\u001a\u00020\rH\u0016J\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0013H\u0002R#\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/netflix/spinnaker/kork/plugins/update/release/source/SpringPluginInfoReleaseSource;", "Lcom/netflix/spinnaker/kork/plugins/update/release/source/PluginInfoReleaseSource;", "pluginStatusProvider", "Lcom/netflix/spinnaker/kork/plugins/SpringPluginStatusProvider;", "(Lcom/netflix/spinnaker/kork/plugins/SpringPluginStatusProvider;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "getOrder", "", "getReleases", "", "Lcom/netflix/spinnaker/kork/plugins/update/release/PluginInfoRelease;", "pluginInfo", "", "Lcom/netflix/spinnaker/kork/plugins/update/internal/SpinnakerPluginInfo;", "pluginInfoRelease", "kork-plugins"})
public final class SpringPluginInfoReleaseSource
implements PluginInfoReleaseSource {
    private final Lazy log$delegate;
    private final SpringPluginStatusProvider pluginStatusProvider;

    private final Logger getLog() {
        Lazy lazy = this.log$delegate;
        SpringPluginInfoReleaseSource springPluginInfoReleaseSource = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Logger)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<PluginInfoRelease> getReleases(@NotNull List<SpinnakerPluginInfo> pluginInfo) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(pluginInfo, (String)"pluginInfo");
        Iterable $this$mapNotNull$iv = pluginInfo;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            PluginInfoRelease pluginInfoRelease;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            SpinnakerPluginInfo it = (SpinnakerPluginInfo)((Object)element$iv$iv);
            boolean bl2 = false;
            if (this.pluginInfoRelease(it) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            PluginInfoRelease it$iv$iv = pluginInfoRelease;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private final PluginInfoRelease pluginInfoRelease(SpinnakerPluginInfo pluginInfo) {
        PluginInfoRelease pluginInfoRelease;
        Object v1;
        block5: {
            String pluginVersion = null;
            try {
                String string = pluginInfo.id;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pluginInfo.id");
                pluginVersion = this.pluginStatusProvider.pluginVersion(string);
            }
            catch (IllegalArgumentException e) {
                this.getLog().error("Unable to read configured plugin version from Spring property due to: {}", (Object)e.getMessage());
                return null;
            }
            Iterable $this$firstOrNull$iv = pluginInfo.getReleases();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                SpinnakerPluginInfo.SpinnakerPluginRelease it = (SpinnakerPluginInfo.SpinnakerPluginRelease)((Object)element$iv);
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.version, (Object)pluginVersion)) continue;
                v1 = element$iv;
                break block5;
            }
            v1 = null;
        }
        SpinnakerPluginInfo.SpinnakerPluginRelease release = v1;
        if (release != null) {
            this.getLog().debug("Spring configured release version '{}' for plugin '{}'", (Object)release.version, (Object)pluginInfo.id);
            String string = pluginInfo.id;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pluginInfo.id");
            pluginInfoRelease = new PluginInfoRelease(string, release);
        } else {
            this.getLog().debug("Spring configured release version not found for plugin '{}'", (Object)pluginInfo.id);
            pluginInfoRelease = null;
        }
        return pluginInfoRelease;
    }

    public int getOrder() {
        return 100;
    }

    public SpringPluginInfoReleaseSource(@NotNull SpringPluginStatusProvider pluginStatusProvider) {
        Intrinsics.checkNotNullParameter((Object)pluginStatusProvider, (String)"pluginStatusProvider");
        this.pluginStatusProvider = pluginStatusProvider;
        this.log$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Logger>(this){
            final /* synthetic */ SpringPluginInfoReleaseSource this$0;

            public final Logger invoke() {
                return LoggerFactory.getLogger(this.this$0.getClass());
            }
            {
                this.this$0 = springPluginInfoReleaseSource;
                super(0);
            }
        }));
    }

    @Override
    public void processReleases(@NotNull Set<PluginInfoRelease> pluginInfoReleases) {
        Intrinsics.checkNotNullParameter(pluginInfoReleases, (String)"pluginInfoReleases");
        PluginInfoReleaseSource.DefaultImpls.processReleases(this, pluginInfoReleases);
    }
}

