/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.keel.sql;

import com.netflix.spinnaker.keel.api.Resource;
import com.netflix.spinnaker.keel.persistence.UnhealthyRepository;
import com.netflix.spinnaker.keel.persistence.metamodel.Tables;
import com.netflix.spinnaker.keel.persistence.metamodel.tables.Unhealthy;
import com.netflix.spinnaker.keel.sql.RetryCategory;
import com.netflix.spinnaker.keel.sql.SqlRetry;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record1;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\u0016\u001a\u00020\u00172\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0016J\u0014\u0010\u0019\u001a\u00020\u001a2\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0016J\u0014\u0010\u001b\u001a\u00020\u001a2\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR(\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u0010*\u0006\u0012\u0002\b\u00030\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001c"}, d2={"Lcom/netflix/spinnaker/keel/sql/SqlUnhealthyRepository;", "Lcom/netflix/spinnaker/keel/persistence/UnhealthyRepository;", "clock", "Ljava/time/Clock;", "jooq", "Lorg/jooq/DSLContext;", "sqlRetry", "Lcom/netflix/spinnaker/keel/sql/SqlRetry;", "(Ljava/time/Clock;Lorg/jooq/DSLContext;Lcom/netflix/spinnaker/keel/sql/SqlRetry;)V", "getClock", "()Ljava/time/Clock;", "getJooq", "()Lorg/jooq/DSLContext;", "getSqlRetry", "()Lcom/netflix/spinnaker/keel/sql/SqlRetry;", "uid", "Lorg/jooq/Select;", "Lorg/jooq/Record1;", "", "Lcom/netflix/spinnaker/keel/api/Resource;", "getUid", "(Lcom/netflix/spinnaker/keel/api/Resource;)Lorg/jooq/Select;", "durationUnhealthy", "Ljava/time/Duration;", "resource", "markHealthy", "", "markUnhealthy", "keel-sql"})
public final class SqlUnhealthyRepository
extends UnhealthyRepository {
    @NotNull
    private final Clock clock;
    @NotNull
    private final DSLContext jooq;
    @NotNull
    private final SqlRetry sqlRetry;

    public void markUnhealthy(@NotNull Resource<?> resource) {
        Intrinsics.checkNotNullParameter(resource, (String)"resource");
        this.sqlRetry.withRetry(RetryCategory.WRITE, (Function0)new Function0<Integer>(this, resource){
            final /* synthetic */ SqlUnhealthyRepository this$0;
            final /* synthetic */ Resource $resource;

            public final int invoke() {
                return this.this$0.getJooq().insertInto((Table)Unhealthy.UNHEALTHY).set((Field)Unhealthy.UNHEALTHY.RESOURCE_UID, SqlUnhealthyRepository.access$getUid$p(this.this$0, this.$resource)).set((Field)Unhealthy.UNHEALTHY.TIME_DETECTED, (Object)this.this$0.getClock().instant()).onDuplicateKeyIgnore().execute();
            }
            {
                this.this$0 = sqlUnhealthyRepository;
                this.$resource = resource;
                super(0);
            }
        });
    }

    public void markHealthy(@NotNull Resource<?> resource) {
        Intrinsics.checkNotNullParameter(resource, (String)"resource");
        this.sqlRetry.withRetry(RetryCategory.WRITE, (Function0)new Function0<Integer>(this, resource){
            final /* synthetic */ SqlUnhealthyRepository this$0;
            final /* synthetic */ Resource $resource;

            public final int invoke() {
                return this.this$0.getJooq().deleteFrom((Table)Unhealthy.UNHEALTHY).where(Unhealthy.UNHEALTHY.RESOURCE_UID.eq(SqlUnhealthyRepository.access$getUid$p(this.this$0, this.$resource))).execute();
            }
            {
                this.this$0 = sqlUnhealthyRepository;
                this.$resource = resource;
                super(0);
            }
        });
    }

    @NotNull
    public Duration durationUnhealthy(@NotNull Resource<?> resource) {
        Intrinsics.checkNotNullParameter(resource, (String)"resource");
        Instant instant = (Instant)this.sqlRetry.withRetry(RetryCategory.READ, (Function0)new Function0<Instant>(this, resource){
            final /* synthetic */ SqlUnhealthyRepository this$0;
            final /* synthetic */ Resource $resource;

            public final Instant invoke() {
                return (Instant)this.this$0.getJooq().select((SelectField)Unhealthy.UNHEALTHY.TIME_DETECTED).from((TableLike)Unhealthy.UNHEALTHY).where(Unhealthy.UNHEALTHY.RESOURCE_UID.eq(SqlUnhealthyRepository.access$getUid$p(this.this$0, this.$resource))).fetchOne((Field)Unhealthy.UNHEALTHY.TIME_DETECTED);
            }
            {
                this.this$0 = sqlUnhealthyRepository;
                this.$resource = resource;
                super(0);
            }
        });
        if (instant == null) {
            Duration duration = Duration.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"Duration.ZERO");
            return duration;
        }
        Instant detectedTime2 = instant;
        Duration duration = Duration.between(detectedTime2, this.clock.instant());
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"Duration.between(detectedTime, clock.instant())");
        return duration;
    }

    private final Select<Record1<String>> getUid(Resource<?> $this$uid) {
        SelectConditionStep selectConditionStep = this.jooq.select((SelectField)Tables.RESOURCE.UID).from((TableLike)Tables.RESOURCE).where(Tables.RESOURCE.ID.eq((Object)$this$uid.getId()));
        Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep, (String)"jooq\n      .select(RESOU\u2026where(RESOURCE.ID.eq(id))");
        return (Select)selectConditionStep;
    }

    @NotNull
    public final Clock getClock() {
        return this.clock;
    }

    @NotNull
    public final DSLContext getJooq() {
        return this.jooq;
    }

    @NotNull
    public final SqlRetry getSqlRetry() {
        return this.sqlRetry;
    }

    public SqlUnhealthyRepository(@NotNull Clock clock, @NotNull DSLContext jooq, @NotNull SqlRetry sqlRetry) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)jooq, (String)"jooq");
        Intrinsics.checkNotNullParameter((Object)sqlRetry, (String)"sqlRetry");
        this.clock = clock;
        this.jooq = jooq;
        this.sqlRetry = sqlRetry;
    }

    public static final /* synthetic */ Select access$getUid$p(SqlUnhealthyRepository $this, Resource $this$access_u24uid_u24p) {
        return $this.getUid($this$access_u24uid_u24p);
    }
}

