/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.keel.sql;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.histogram.PercentileTimer;
import com.netflix.spinnaker.keel.api.DeliveryConfig;
import com.netflix.spinnaker.keel.api.Environment;
import com.netflix.spinnaker.keel.core.api.UIDKt;
import com.netflix.spinnaker.keel.exceptions.ActiveLeaseExists;
import com.netflix.spinnaker.keel.persistence.EnvironmentLeaseRepository;
import com.netflix.spinnaker.keel.persistence.Lease;
import com.netflix.spinnaker.keel.persistence.metamodel.Tables;
import com.netflix.spinnaker.keel.persistence.metamodel.tables.records.EnvironmentLeaseRecord;
import com.netflix.spinnaker.keel.sql.JooqKt;
import de.huxhorn.sulky.ulid.ULID;
import java.net.InetAddress;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.ResultQuery;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.exception.DataAccessException;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001:\u00012B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J,\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00032\n\u0010\u0019\u001a\u00060\u001aj\u0002`\u001b2\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u0011H\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020\u0011H\u0002J\u0018\u0010#\u001a\u00020\u00172\u0006\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020\u0011H\u0002J\u000e\u0010&\u001a\u00020\u00172\u0006\u0010'\u001a\u00020(J \u0010)\u001a\u00020*2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010%\u001a\u00020\u0011H\u0016J,\u0010+\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00032\n\u0010\u0019\u001a\u00060\u001aj\u0002`\u001b2\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u0011H\u0002J4\u0010,\u001a\u00020\u0017*\u00020\f2\u0006\u0010-\u001a\u00020\u00112\u0006\u0010.\u001a\u00020\u00112\u0006\u0010%\u001a\u00020\u00112\u0006\u0010/\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0011H\u0002J$\u00100\u001a\u00020\u0017*\u00020\f2\u0006\u0010%\u001a\u00020\u00112\u0006\u0010/\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0011H\u0002J,\u00101\u001a\u00020\u0017*\u00020\f2\u0006\u0010.\u001a\u00020\u00112\u0006\u0010%\u001a\u00020\u00112\u0006\u0010/\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0011H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \r*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/netflix/spinnaker/keel/sql/SqlEnvironmentLeaseRepository;", "Lcom/netflix/spinnaker/keel/persistence/EnvironmentLeaseRepository;", "jooq", "Lorg/jooq/DSLContext;", "clock", "Ljava/time/Clock;", "spectator", "Lcom/netflix/spectator/api/Registry;", "leaseDuration", "Ljava/time/Duration;", "(Lorg/jooq/DSLContext;Ljava/time/Clock;Lcom/netflix/spectator/api/Registry;Ljava/time/Duration;)V", "leaseCountId", "Lcom/netflix/spectator/api/Id;", "kotlin.jvm.PlatformType", "timerBuilder", "Lcom/netflix/spectator/api/histogram/PercentileTimer$Builder;", "getEnvironmentUid", "", "deliveryConfig", "Lcom/netflix/spinnaker/keel/api/DeliveryConfig;", "environment", "Lcom/netflix/spinnaker/keel/api/Environment;", "insertRecord", "", "ctx", "uid", "Lde/huxhorn/sulky/ulid/ULID$Value;", "Lcom/netflix/spinnaker/keel/core/api/UID;", "environmentUid", "comment", "isExpired", "", "leasedAt", "Ljava/time/Instant;", "lesseeIdentifier", "recordDeniedLeaseTime", "startTime", "actionType", "release", "lease", "Lcom/netflix/spinnaker/keel/sql/SqlEnvironmentLeaseRepository$SqlLease;", "tryAcquireLease", "Lcom/netflix/spinnaker/keel/persistence/Lease;", "updateRecord", "increment", "outcome", "status", "application", "incrementDenied", "incrementGranted", "SqlLease", "keel-sql"})
public final class SqlEnvironmentLeaseRepository
implements EnvironmentLeaseRepository {
    private final Id leaseCountId;
    private final PercentileTimer.Builder timerBuilder;
    private final DSLContext jooq;
    private final Clock clock;
    private final Registry spectator;
    private final Duration leaseDuration;

    @NotNull
    public Lease tryAcquireLease(@NotNull DeliveryConfig deliveryConfig, @NotNull Environment environment, @NotNull String actionType) {
        Intrinsics.checkNotNullParameter((Object)deliveryConfig, (String)"deliveryConfig");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)actionType, (String)"actionType");
        Instant startTime = this.clock.instant();
        try {
            String environmentUid = this.getEnvironmentUid(deliveryConfig, environment);
            ULID.Value leaseUid = UIDKt.randomUID();
            JooqKt.inTransaction(this.jooq, (Function1)new Function1<DSLContext, Unit>(this, environmentUid, leaseUid, actionType, deliveryConfig, environment){
                final /* synthetic */ SqlEnvironmentLeaseRepository this$0;
                final /* synthetic */ String $environmentUid;
                final /* synthetic */ ULID.Value $leaseUid;
                final /* synthetic */ String $actionType;
                final /* synthetic */ DeliveryConfig $deliveryConfig;
                final /* synthetic */ Environment $environment;

                public final void invoke(@NotNull DSLContext $this$inTransaction) {
                    Intrinsics.checkNotNullParameter((Object)$this$inTransaction, (String)"$receiver");
                    EnvironmentLeaseRecord record2 = (EnvironmentLeaseRecord)$this$inTransaction.selectFrom((Table)Tables.ENVIRONMENT_LEASE).where(Tables.ENVIRONMENT_LEASE.ENVIRONMENT_UID.eq((Object)this.$environmentUid)).forShare().fetchOne();
                    if (record2 == null) {
                        SqlEnvironmentLeaseRepository.access$insertRecord(this.this$0, $this$inTransaction, this.$leaseUid, this.$environmentUid, this.$actionType);
                        Unit unit = Unit.INSTANCE;
                        boolean bl = false;
                        boolean bl2 = false;
                        Unit it = unit;
                        boolean bl3 = false;
                        Id id2 = SqlEnvironmentLeaseRepository.access$getLeaseCountId$p(this.this$0);
                        Intrinsics.checkNotNullExpressionValue((Object)id2, (String)"leaseCountId");
                        SqlEnvironmentLeaseRepository.access$incrementGranted(this.this$0, id2, "free", this.$actionType, this.$deliveryConfig.getApplication(), this.$environment.getName());
                    } else {
                        Instant instant = record2.getLeasedAt();
                        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"record.leasedAt");
                        if (SqlEnvironmentLeaseRepository.access$isExpired(this.this$0, instant)) {
                            SqlEnvironmentLeaseRepository.access$updateRecord(this.this$0, $this$inTransaction, this.$leaseUid, this.$environmentUid, this.$actionType);
                            Unit unit = Unit.INSTANCE;
                            boolean bl = false;
                            boolean bl4 = false;
                            Unit it = unit;
                            boolean bl5 = false;
                            Id id3 = SqlEnvironmentLeaseRepository.access$getLeaseCountId$p(this.this$0);
                            Intrinsics.checkNotNullExpressionValue((Object)id3, (String)"leaseCountId");
                            SqlEnvironmentLeaseRepository.access$incrementGranted(this.this$0, id3, "expired", this.$actionType, this.$deliveryConfig.getApplication(), this.$environment.getName());
                        } else {
                            String string = record2.getLeasedBy();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"record.leasedBy");
                            Instant instant2 = record2.getLeasedAt();
                            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"record.leasedAt");
                            ActiveLeaseExists activeLeaseExists = new ActiveLeaseExists(this.$environment, string, instant2);
                            boolean bl = false;
                            boolean bl6 = false;
                            ActiveLeaseExists it = activeLeaseExists;
                            boolean bl7 = false;
                            Id id4 = SqlEnvironmentLeaseRepository.access$getLeaseCountId$p(this.this$0);
                            Intrinsics.checkNotNullExpressionValue((Object)id4, (String)"leaseCountId");
                            SqlEnvironmentLeaseRepository.access$incrementDenied(this.this$0, id4, this.$actionType, this.$deliveryConfig.getApplication(), this.$environment.getName());
                            throw (Throwable)activeLeaseExists;
                        }
                    }
                }
                {
                    this.this$0 = sqlEnvironmentLeaseRepository;
                    this.$environmentUid = string;
                    this.$leaseUid = value;
                    this.$actionType = string2;
                    this.$deliveryConfig = deliveryConfig;
                    this.$environment = environment;
                    super(1);
                }
            });
            Instant instant = startTime;
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"startTime");
            PercentileTimer.Builder builder = this.timerBuilder;
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"timerBuilder");
            return new SqlLease(this, leaseUid, instant, actionType, builder, this.clock);
        }
        catch (DataAccessException e) {
            Instant instant = startTime;
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"startTime");
            this.recordDeniedLeaseTime(instant, actionType);
            Throwable throwable = e.getCause();
            if (!(throwable instanceof ActiveLeaseExists)) {
                throwable = null;
            }
            ActiveLeaseExists activeLeaseExists = (ActiveLeaseExists)throwable;
            if (activeLeaseExists != null) {
                ActiveLeaseExists activeLeaseExists2 = activeLeaseExists;
                boolean bl = false;
                boolean bl2 = false;
                ActiveLeaseExists it = activeLeaseExists2;
                boolean bl3 = false;
                throw (Throwable)it;
            }
            throw (Throwable)e;
        }
        catch (Exception e) {
            Instant instant = startTime;
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"startTime");
            this.recordDeniedLeaseTime(instant, actionType);
            throw (Throwable)e;
        }
    }

    private final void recordDeniedLeaseTime(Instant startTime, String actionType) {
        ((PercentileTimer.Builder)((PercentileTimer.Builder)this.timerBuilder.withTag("action", actionType)).withTag("outcome", "denied")).build().record(Duration.between(startTime, this.clock.instant()));
    }

    private final boolean isExpired(Instant leasedAt) {
        Instant now;
        Instant expirationDate = leasedAt.plus(this.leaseDuration);
        return expirationDate.compareTo(now = this.clock.instant()) < 0;
    }

    private final void insertRecord(DSLContext ctx, ULID.Value uid2, String environmentUid, String comment) {
        ctx.insertInto((Table)Tables.ENVIRONMENT_LEASE).set((Field)Tables.ENVIRONMENT_LEASE.UID, (Object)uid2.toString()).set((Field)Tables.ENVIRONMENT_LEASE.ENVIRONMENT_UID, (Object)environmentUid).set((Field)Tables.ENVIRONMENT_LEASE.LEASED_BY, (Object)this.lesseeIdentifier()).set((Field)Tables.ENVIRONMENT_LEASE.LEASED_AT, (Object)this.clock.instant()).set((Field)Tables.ENVIRONMENT_LEASE.COMMENT, (Object)comment).execute();
    }

    private final void updateRecord(DSLContext ctx, ULID.Value uid2, String environmentUid, String comment) {
        ctx.update((Table)Tables.ENVIRONMENT_LEASE).set((Field)Tables.ENVIRONMENT_LEASE.UID, (Object)uid2.toString()).set((Field)Tables.ENVIRONMENT_LEASE.LEASED_BY, (Object)this.lesseeIdentifier()).set((Field)Tables.ENVIRONMENT_LEASE.LEASED_AT, (Object)this.clock.instant()).set((Field)Tables.ENVIRONMENT_LEASE.COMMENT, (Object)comment).where(Tables.ENVIRONMENT_LEASE.ENVIRONMENT_UID.eq((Object)environmentUid)).execute();
    }

    public final void release(@NotNull SqlLease lease) {
        Intrinsics.checkNotNullParameter((Object)lease, (String)"lease");
        this.jooq.deleteFrom((Table)Tables.ENVIRONMENT_LEASE).where(Tables.ENVIRONMENT_LEASE.UID.eq((Object)lease.getUid().toString())).execute();
    }

    private final String getEnvironmentUid(DeliveryConfig deliveryConfig, Environment environment) {
        SelectConditionStep selectConditionStep = this.jooq.select((SelectField)Tables.LATEST_ENVIRONMENT.UID).from((TableLike)Tables.DELIVERY_CONFIG).join((TableLike)Tables.LATEST_ENVIRONMENT).on(Tables.LATEST_ENVIRONMENT.DELIVERY_CONFIG_UID.eq((Field)Tables.DELIVERY_CONFIG.UID)).where(Tables.DELIVERY_CONFIG.NAME.eq((Object)deliveryConfig.getName())).and(Tables.LATEST_ENVIRONMENT.NAME.eq((Object)environment.getName()));
        Intrinsics.checkNotNullExpressionValue((Object)selectConditionStep, (String)"jooq.select(LATEST_ENVIR\u2026AME.eq(environment.name))");
        ResultQuery $this$fetchOneInto$iv = (ResultQuery)selectConditionStep;
        boolean $i$f$fetchOneInto = false;
        Object object = $this$fetchOneInto$iv.fetchOneInto(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"jooq.select(LATEST_ENVIR\u2026  .fetchOneInto<String>()");
        return (String)object;
    }

    private final String lesseeIdentifier() {
        InetAddress inetAddress = InetAddress.getLocalHost();
        Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"InetAddress.getLocalHost()");
        String string = inetAddress.getHostName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"InetAddress.getLocalHost().hostName");
        return string;
    }

    private final void incrementGranted(Id $this$incrementGranted, String status, String actionType, String application2, String environment) {
        this.increment($this$incrementGranted, "granted", status, actionType, application2, environment);
    }

    private final void incrementDenied(Id $this$incrementDenied, String actionType, String application2, String environment) {
        this.increment($this$incrementDenied, "denied", "active", actionType, application2, environment);
    }

    private final void increment(Id $this$increment, String outcome, String status, String actionType, String application2, String environment) {
        Id id2 = $this$increment.withTags(new String[]{"outcome", outcome, "status", status, "action", actionType, "application", application2, "environment", environment});
        this.spectator.counter(id2).increment();
    }

    public SqlEnvironmentLeaseRepository(@NotNull DSLContext jooq, @NotNull Clock clock, @NotNull Registry spectator, @NotNull Duration leaseDuration) {
        Intrinsics.checkNotNullParameter((Object)jooq, (String)"jooq");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)spectator, (String)"spectator");
        Intrinsics.checkNotNullParameter((Object)leaseDuration, (String)"leaseDuration");
        this.jooq = jooq;
        this.clock = clock;
        this.spectator = spectator;
        this.leaseDuration = leaseDuration;
        this.leaseCountId = this.spectator.createId("lease.env.count");
        this.timerBuilder = (PercentileTimer.Builder)PercentileTimer.builder((Registry)this.spectator).withName("lease.env.duration");
    }

    public static final /* synthetic */ void access$insertRecord(SqlEnvironmentLeaseRepository $this, DSLContext ctx, ULID.Value uid2, String environmentUid, String comment) {
        $this.insertRecord(ctx, uid2, environmentUid, comment);
    }

    public static final /* synthetic */ void access$incrementGranted(SqlEnvironmentLeaseRepository $this, Id $this$access_u24incrementGranted, String status, String actionType, String application2, String environment) {
        $this.incrementGranted($this$access_u24incrementGranted, status, actionType, application2, environment);
    }

    public static final /* synthetic */ Id access$getLeaseCountId$p(SqlEnvironmentLeaseRepository $this) {
        return $this.leaseCountId;
    }

    public static final /* synthetic */ boolean access$isExpired(SqlEnvironmentLeaseRepository $this, Instant leasedAt) {
        return $this.isExpired(leasedAt);
    }

    public static final /* synthetic */ void access$updateRecord(SqlEnvironmentLeaseRepository $this, DSLContext ctx, ULID.Value uid2, String environmentUid, String comment) {
        $this.updateRecord(ctx, uid2, environmentUid, comment);
    }

    public static final /* synthetic */ void access$incrementDenied(SqlEnvironmentLeaseRepository $this, Id $this$access_u24incrementDenied, String actionType, String application2, String environment) {
        $this.incrementDenied($this$access_u24incrementDenied, actionType, application2, environment);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0016"}, d2={"Lcom/netflix/spinnaker/keel/sql/SqlEnvironmentLeaseRepository$SqlLease;", "Lcom/netflix/spinnaker/keel/persistence/Lease;", "repository", "Lcom/netflix/spinnaker/keel/sql/SqlEnvironmentLeaseRepository;", "uid", "Lde/huxhorn/sulky/ulid/ULID$Value;", "Lcom/netflix/spinnaker/keel/core/api/UID;", "startTime", "Ljava/time/Instant;", "actionType", "", "timerBuilder", "Lcom/netflix/spectator/api/histogram/PercentileTimer$Builder;", "clock", "Ljava/time/Clock;", "(Lcom/netflix/spinnaker/keel/sql/SqlEnvironmentLeaseRepository;Lde/huxhorn/sulky/ulid/ULID$Value;Ljava/time/Instant;Ljava/lang/String;Lcom/netflix/spectator/api/histogram/PercentileTimer$Builder;Ljava/time/Clock;)V", "getRepository", "()Lcom/netflix/spinnaker/keel/sql/SqlEnvironmentLeaseRepository;", "getUid", "()Lde/huxhorn/sulky/ulid/ULID$Value;", "close", "", "keel-sql"})
    public static final class SqlLease
    implements Lease {
        @NotNull
        private final SqlEnvironmentLeaseRepository repository;
        @NotNull
        private final ULID.Value uid;
        private final Instant startTime;
        private final String actionType;
        private final PercentileTimer.Builder timerBuilder;
        private final Clock clock;

        public void close() {
            this.repository.release(this);
            ((PercentileTimer.Builder)((PercentileTimer.Builder)this.timerBuilder.withTag("action", this.actionType)).withTag("outcome", "granted")).build().record(Duration.between(this.startTime, this.clock.instant()));
        }

        @NotNull
        public final SqlEnvironmentLeaseRepository getRepository() {
            return this.repository;
        }

        @NotNull
        public final ULID.Value getUid() {
            return this.uid;
        }

        public SqlLease(@NotNull SqlEnvironmentLeaseRepository repository, @NotNull ULID.Value uid2, @NotNull Instant startTime, @NotNull String actionType, @NotNull PercentileTimer.Builder timerBuilder, @NotNull Clock clock) {
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)uid2, (String)"uid");
            Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
            Intrinsics.checkNotNullParameter((Object)actionType, (String)"actionType");
            Intrinsics.checkNotNullParameter((Object)timerBuilder, (String)"timerBuilder");
            Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
            this.repository = repository;
            this.uid = uid2;
            this.startTime = startTime;
            this.actionType = actionType;
            this.timerBuilder = timerBuilder;
            this.clock = clock;
        }
    }
}

