/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.keel.sql;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.exceptions.ArtifactParsingException;
import com.netflix.spinnaker.keel.api.artifacts.ArtifactStatus;
import com.netflix.spinnaker.keel.api.artifacts.BuildMetadata;
import com.netflix.spinnaker.keel.api.artifacts.DeliveryArtifact;
import com.netflix.spinnaker.keel.api.artifacts.GitMetadata;
import com.netflix.spinnaker.keel.api.artifacts.PublishedArtifact;
import com.netflix.spinnaker.keel.api.artifacts.TagVersionStrategy;
import com.netflix.spinnaker.keel.api.plugins.ArtifactSupplier;
import com.netflix.spinnaker.keel.artifacts.DockerArtifact;
import com.netflix.spinnaker.keel.artifacts.TagComparator;
import com.netflix.spinnaker.keel.exceptions.InvalidRegexException;
import com.netflix.spinnaker.keel.persistence.metamodel.Tables;
import com.netflix.spinnaker.keel.persistence.metamodel.tables.records.ArtifactVersionsRecord;
import com.netflix.spinnaker.keel.serialization.ObjectMappersKt;
import com.netflix.spinnaker.keel.sql.ArtifactUtilsKt;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record7;
import org.jooq.RecordMapper;
import org.jooq.ResultQuery;
import org.jooq.SelectConditionStep;
import org.jooq.TableField;
import org.jooq.impl.DSL;
import org.slf4j.Logger;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000\u0080\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\u001a\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u001a$\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002\u001aB\u0010\u001a\u001a\u00020\u001b2\u000e\u0010\u001c\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001d2\u0006\u0010\u001e\u001a\u00020\u00022\n\u0010\u001f\u001a\u00060\u0002j\u0002` 2\u0006\u0010!\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020\u00022\u0006\u0010#\u001a\u00020\u0002\u001ad\u0010$\u001a&\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00180\u0018 \n*\u0012\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00180\u0018\u0018\u00010\u00170%*6\u0012.\u0012,\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020+0'0&j\u0002`,H\u0000\u001a_\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017*6\u0012.\u0012,\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020+0'0.j\u0002`/2\u0006\u0010\u0014\u001a\u00020\u001b2\n\b\u0002\u00100\u001a\u0004\u0018\u000101H\u0002\u00a2\u0006\u0002\u00102\u001a_\u00103\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017*6\u0012.\u0012,\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020+0'0.j\u0002`/2\u0006\u0010\u0014\u001a\u00020\u001b2\n\b\u0002\u00100\u001a\u0004\u0018\u000101H\u0002\u00a2\u0006\u0002\u00102\u001a_\u00104\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017*6\u0012.\u0012,\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020+0'0.j\u0002`/2\u0006\u0010\u0014\u001a\u00020\u001b2\n\b\u0002\u00100\u001a\u0004\u0018\u000101H\u0000\u00a2\u0006\u0002\u00102\"\u001c\u0010\u0000\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u001c\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0004\"\u000e\u0010\u0007\u001a\u00020\u0002X\u0080T\u00a2\u0006\u0002\n\u0000\"#\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\f\"\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000*j\u00105\"2\u0012.\u0012,\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020+0'0&22\u0012.\u0012,\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020+0'0&*j\u00106\"2\u0012.\u0012,\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020+0'0.22\u0012.\u0012,\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020+0'0.\u00a8\u00067"}, d2={"ARTIFACT_VERSIONS_BRANCH", "Lorg/jooq/Field;", "", "getARTIFACT_VERSIONS_BRANCH", "()Lorg/jooq/Field;", "ARTIFACT_VERSIONS_PR_NUMBER", "getARTIFACT_VERSIONS_PR_NUMBER", "EMPTY_PR_NUMBER", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "filterDockerTag", "", "tag", "artifact", "Lcom/netflix/spinnaker/keel/artifacts/DockerArtifact;", "filterDockerVersions", "", "Lcom/netflix/spinnaker/keel/api/artifacts/PublishedArtifact;", "versions", "mapToArtifact", "Lcom/netflix/spinnaker/keel/api/artifacts/DeliveryArtifact;", "artifactSupplier", "Lcom/netflix/spinnaker/keel/api/plugins/ArtifactSupplier;", "name", "type", "Lcom/netflix/spinnaker/keel/api/artifacts/ArtifactType;", "json", "reference", "deliveryConfigName", "fetchArtifactVersions", "", "Lorg/jooq/ResultQuery;", "Lorg/jooq/Record7;", "Lcom/netflix/spinnaker/keel/api/artifacts/ArtifactStatus;", "Ljava/time/Instant;", "Lcom/netflix/spinnaker/keel/api/artifacts/GitMetadata;", "Lcom/netflix/spinnaker/keel/api/artifacts/BuildMetadata;", "Lcom/netflix/spinnaker/keel/sql/ArtifactVersionRow;", "fetchArtifactVersionsSortedWithComparator", "Lorg/jooq/SelectConditionStep;", "Lcom/netflix/spinnaker/keel/sql/ArtifactVersionSelectStep;", "limit", "", "(Lorg/jooq/SelectConditionStep;Lcom/netflix/spinnaker/keel/api/artifacts/DeliveryArtifact;Ljava/lang/Integer;)Ljava/util/List;", "fetchArtifactVersionsSortedWithQuery", "fetchSortedArtifactVersions", "ArtifactVersionRow", "ArtifactVersionSelectStep", "keel-sql"})
public final class ArtifactUtilsKt {
    private static final ObjectMapper objectMapper = ObjectMappersKt.configuredObjectMapper();
    private static final Lazy log$delegate = LazyKt.lazy((Function0)log.2.INSTANCE);
    @NotNull
    private static final Field<String> ARTIFACT_VERSIONS_BRANCH;
    @NotNull
    private static final Field<String> ARTIFACT_VERSIONS_PR_NUMBER;
    @NotNull
    public static final String EMPTY_PR_NUMBER = "\"\"";

    private static final Logger getLog() {
        Lazy lazy = log$delegate;
        Object var1_1 = null;
        Object var2_2 = null;
        boolean bl = false;
        return (Logger)lazy.getValue();
    }

    @NotNull
    public static final Field<String> getARTIFACT_VERSIONS_BRANCH() {
        return ARTIFACT_VERSIONS_BRANCH;
    }

    @NotNull
    public static final Field<String> getARTIFACT_VERSIONS_PR_NUMBER() {
        return ARTIFACT_VERSIONS_PR_NUMBER;
    }

    @NotNull
    public static final DeliveryArtifact mapToArtifact(@NotNull ArtifactSupplier<?, ?> artifactSupplier, @NotNull String name, @NotNull String type, @NotNull String json, @NotNull String reference, @NotNull String deliveryConfigName) {
        Intrinsics.checkNotNullParameter(artifactSupplier, (String)"artifactSupplier");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Intrinsics.checkNotNullParameter((Object)deliveryConfigName, (String)"deliveryConfigName");
        try {
            ObjectMapper $this$readValue$iv = objectMapper;
            boolean $i$f$readValue = false;
            String string = json;
            ObjectMapper objectMapper = $this$readValue$iv;
            boolean $i$f$jacksonTypeRef = false;
            TypeReference typeReference = (TypeReference)new TypeReference<Map<String, ? extends Object>>(){};
            Map map = MapsKt.toMutableMap((Map)((Map)objectMapper.readValue(string, typeReference)));
            boolean bl = false;
            boolean bl2 = false;
            Map it = map;
            boolean bl3 = false;
            it.put("name", name);
            it.put("type", type);
            it.put("reference", reference);
            it.put("deliveryConfigName", deliveryConfigName);
            Map artifactAsMap = map;
            Object object = ArtifactUtilsKt.objectMapper.convertValue((Object)artifactAsMap, artifactSupplier.getSupportedArtifact().getArtifactClass());
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"objectMapper.convertValu\u2026edArtifact.artifactClass)");
            return (DeliveryArtifact)object;
        }
        catch (JsonMappingException e) {
            throw (Throwable)((Object)new ArtifactParsingException(name, type, json, (Exception)((Object)e)));
        }
    }

    public static final List<PublishedArtifact> fetchArtifactVersions(@NotNull ResultQuery<Record7<String, String, String, ArtifactStatus, Instant, GitMetadata, BuildMetadata>> $this$fetchArtifactVersions) {
        Intrinsics.checkNotNullParameter($this$fetchArtifactVersions, (String)"$this$fetchArtifactVersions");
        return $this$fetchArtifactVersions.fetch((RecordMapper)fetchArtifactVersions.1.INSTANCE);
    }

    private static final List<PublishedArtifact> fetchArtifactVersionsSortedWithQuery(SelectConditionStep<Record7<String, String, String, ArtifactStatus, Instant, GitMetadata, BuildMetadata>> $this$fetchArtifactVersionsSortedWithQuery, DeliveryArtifact artifact, Integer limit) {
        if (artifact.getFilteredByPullRequest()) {
            $this$fetchArtifactVersionsSortedWithQuery.and(ARTIFACT_VERSIONS_PR_NUMBER.isNotNull()).and(ARTIFACT_VERSIONS_PR_NUMBER.ne((Object)EMPTY_PR_NUMBER));
        }
        if (artifact.getFilteredByBranch()) {
            Object object;
            Object object2;
            Object it;
            boolean bl;
            boolean bl2;
            Object object3;
            Object object4 = artifact.getFrom();
            if (object4 != null && (object4 = object4.getBranch()) != null && (object4 = object4.getName()) != null) {
                object3 = object4;
                bl2 = false;
                bl = false;
                it = object3;
                boolean bl3 = false;
                $this$fetchArtifactVersionsSortedWithQuery.and(ARTIFACT_VERSIONS_BRANCH.eq(it));
            }
            if ((object2 = artifact.getFrom()) != null && (object2 = object2.getBranch()) != null && (object2 = object2.getStartsWith()) != null) {
                object3 = object2;
                bl2 = false;
                bl = false;
                it = object3;
                boolean bl4 = false;
                $this$fetchArtifactVersionsSortedWithQuery.and(ARTIFACT_VERSIONS_BRANCH.startsWith(it));
            }
            if ((object = artifact.getFrom()) != null && (object = object.getBranch()) != null && (object = object.getRegex()) != null) {
                object3 = object;
                bl2 = false;
                bl = false;
                it = object3;
                boolean bl5 = false;
                $this$fetchArtifactVersionsSortedWithQuery.and(ARTIFACT_VERSIONS_BRANCH.likeRegex((String)it));
            }
        }
        TableField<ArtifactVersionsRecord, Instant> tableField = Tables.ARTIFACT_VERSIONS.CREATED_AT;
        Intrinsics.checkNotNullExpressionValue(tableField, (String)"ARTIFACT_VERSIONS.CREATED_AT");
        $this$fetchArtifactVersionsSortedWithQuery.and(tableField.isNotNull()).orderBy((OrderField)Tables.ARTIFACT_VERSIONS.CREATED_AT.desc());
        if (limit != null) {
            $this$fetchArtifactVersionsSortedWithQuery.limit(limit.intValue());
        }
        List<PublishedArtifact> list = ArtifactUtilsKt.fetchArtifactVersions((ResultQuery<Record7<String, String, String, ArtifactStatus, Instant, GitMetadata, BuildMetadata>>)((ResultQuery)$this$fetchArtifactVersionsSortedWithQuery));
        Intrinsics.checkNotNullExpressionValue(list, (String)"fetchArtifactVersions()");
        return list;
    }

    static /* synthetic */ List fetchArtifactVersionsSortedWithQuery$default(SelectConditionStep selectConditionStep, DeliveryArtifact deliveryArtifact, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        return ArtifactUtilsKt.fetchArtifactVersionsSortedWithQuery((SelectConditionStep<Record7<String, String, String, ArtifactStatus, Instant, GitMetadata, BuildMetadata>>)selectConditionStep, deliveryArtifact, n);
    }

    private static final List<PublishedArtifact> fetchArtifactVersionsSortedWithComparator(SelectConditionStep<Record7<String, String, String, ArtifactStatus, Instant, GitMetadata, BuildMetadata>> $this$fetchArtifactVersionsSortedWithComparator, DeliveryArtifact artifact, Integer limit) {
        List<PublishedArtifact> list = (List<PublishedArtifact>)((Object)artifact.getStatuses());
        boolean bl = false;
        if (!list.isEmpty()) {
            Collection $this$toTypedArray$iv = artifact.getStatuses();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            ArtifactStatus[] artifactStatusArray = thisCollection$iv.toArray(new ArtifactStatus[0]);
            if (artifactStatusArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            $this$fetchArtifactVersionsSortedWithComparator.and(Tables.ARTIFACT_VERSIONS.RELEASE_STATUS.in((Object[])Arrays.copyOf(artifactStatusArray, artifactStatusArray.length)));
        }
        List<PublishedArtifact> list2 = ArtifactUtilsKt.fetchArtifactVersions((ResultQuery<Record7<String, String, String, ArtifactStatus, Instant, GitMetadata, BuildMetadata>>)((ResultQuery)$this$fetchArtifactVersionsSortedWithComparator));
        Intrinsics.checkNotNullExpressionValue(list2, (String)"fetchArtifactVersions()");
        list = CollectionsKt.sortedWith((Iterable)list2, (Comparator)artifact.getSortingStrategy().getComparator());
        bl = false;
        boolean bl2 = false;
        List<PublishedArtifact> it = list;
        boolean bl3 = false;
        list = artifact instanceof DockerArtifact ? ArtifactUtilsKt.filterDockerVersions((DockerArtifact)artifact, it) : it;
        bl = false;
        bl2 = false;
        it = list;
        boolean bl4 = false;
        return limit != null ? it.subList(0, RangesKt.coerceAtMost((int)it.size(), (int)limit)) : it;
    }

    static /* synthetic */ List fetchArtifactVersionsSortedWithComparator$default(SelectConditionStep selectConditionStep, DeliveryArtifact deliveryArtifact, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        return ArtifactUtilsKt.fetchArtifactVersionsSortedWithComparator((SelectConditionStep<Record7<String, String, String, ArtifactStatus, Instant, GitMetadata, BuildMetadata>>)selectConditionStep, deliveryArtifact, n);
    }

    @NotNull
    public static final List<PublishedArtifact> fetchSortedArtifactVersions(@NotNull SelectConditionStep<Record7<String, String, String, ArtifactStatus, Instant, GitMetadata, BuildMetadata>> $this$fetchSortedArtifactVersions, @NotNull DeliveryArtifact artifact, @Nullable Integer limit) {
        Intrinsics.checkNotNullParameter($this$fetchSortedArtifactVersions, (String)"$this$fetchSortedArtifactVersions");
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        return artifact.getFilteredBySource() ? ArtifactUtilsKt.fetchArtifactVersionsSortedWithQuery($this$fetchSortedArtifactVersions, artifact, limit) : ArtifactUtilsKt.fetchArtifactVersionsSortedWithComparator($this$fetchSortedArtifactVersions, artifact, limit);
    }

    public static /* synthetic */ List fetchSortedArtifactVersions$default(SelectConditionStep selectConditionStep, DeliveryArtifact deliveryArtifact, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        return ArtifactUtilsKt.fetchSortedArtifactVersions((SelectConditionStep<Record7<String, String, String, ArtifactStatus, Instant, GitMetadata, BuildMetadata>>)selectConditionStep, deliveryArtifact, n);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<PublishedArtifact> filterDockerVersions(DockerArtifact artifact, List<PublishedArtifact> versions2) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = versions2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PublishedArtifact it = (PublishedArtifact)element$iv$iv;
            boolean bl = false;
            if (!ArtifactUtilsKt.filterDockerTag(it.getVersion(), artifact)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static final boolean filterDockerTag(@NotNull String tag, @NotNull DockerArtifact artifact) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        if (artifact.getFilteredBySource()) {
            ArtifactUtilsKt.getLog().debug("Ignoring Docker tag filter for " + artifact + ", tag " + tag + " since it's filtered by source.");
            bl = true;
        } else {
            boolean bl2;
            try {
                TagVersionStrategy tagVersionStrategy = artifact.getTagVersionStrategy();
                Intrinsics.checkNotNull((Object)tagVersionStrategy);
                bl2 = TagComparator.Companion.parseWithRegex(tag, tagVersionStrategy, artifact.getCaptureGroupRegex()) != null;
            }
            catch (InvalidRegexException e) {
                ArtifactUtilsKt.getLog().warn("Version " + tag + " produced more than one capture group based on artifact " + artifact + ". Excluding.");
                bl2 = false;
            }
            bl = bl2;
        }
        return bl;
    }

    static {
        String sql$iv = "json_unquote(keel.artifact_versions.git_metadata->'$.branch')";
        boolean $i$f$field = false;
        Field field = DSL.field((String)sql$iv, String.class);
        Intrinsics.checkNotNullExpressionValue((Object)field, (String)"DSL.field(sql, T::class.java)");
        ARTIFACT_VERSIONS_BRANCH = field;
        sql$iv = "json_unquote(keel.artifact_versions.git_metadata->'$.pullRequest.number')";
        $i$f$field = false;
        Field field2 = DSL.field((String)sql$iv, String.class);
        Intrinsics.checkNotNullExpressionValue((Object)field2, (String)"DSL.field(sql, T::class.java)");
        ARTIFACT_VERSIONS_PR_NUMBER = field2;
    }
}

