/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.keel.persistence.metamodel.tables;

import com.netflix.spinnaker.keel.persistence.metamodel.Keel;
import com.netflix.spinnaker.keel.persistence.metamodel.tables.records.ResourceWithMetadataRecord;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Row6;
import org.jooq.Schema;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableOptions;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.TableImpl;

public class ResourceWithMetadata
extends TableImpl<ResourceWithMetadataRecord> {
    private static final long serialVersionUID = -1801364995L;
    public static final ResourceWithMetadata RESOURCE_WITH_METADATA = new ResourceWithMetadata();
    public final TableField<ResourceWithMetadataRecord, String> UID = ResourceWithMetadata.createField((Name)DSL.name((String)"uid"), (DataType)SQLDataType.CHAR((int)26).nullable(false), (Table)this, (String)"");
    public final TableField<ResourceWithMetadataRecord, String> ID = ResourceWithMetadata.createField((Name)DSL.name((String)"id"), (DataType)SQLDataType.VARCHAR((int)255), (Table)this, (String)"");
    public final TableField<ResourceWithMetadataRecord, String> APPLICATION = ResourceWithMetadata.createField((Name)DSL.name((String)"application"), (DataType)SQLDataType.VARCHAR((int)255).nullable(false), (Table)this, (String)"");
    public final TableField<ResourceWithMetadataRecord, String> KIND = ResourceWithMetadata.createField((Name)DSL.name((String)"kind"), (DataType)SQLDataType.VARCHAR((int)255).nullable(false), (Table)this, (String)"");
    public final TableField<ResourceWithMetadataRecord, String> METADATA = ResourceWithMetadata.createField((Name)DSL.name((String)"metadata"), (DataType)SQLDataType.LONGVARCHAR, (Table)this, (String)"");
    public final TableField<ResourceWithMetadataRecord, String> SPEC = ResourceWithMetadata.createField((Name)DSL.name((String)"spec"), (DataType)SQLDataType.LONGVARCHAR.nullable(false), (Table)this, (String)"");

    public Class<ResourceWithMetadataRecord> getRecordType() {
        return ResourceWithMetadataRecord.class;
    }

    public ResourceWithMetadata() {
        this(DSL.name((String)"resource_with_metadata"), null);
    }

    public ResourceWithMetadata(String alias) {
        this(DSL.name((String)alias), (Table<ResourceWithMetadataRecord>)RESOURCE_WITH_METADATA);
    }

    public ResourceWithMetadata(Name alias) {
        this(alias, (Table<ResourceWithMetadataRecord>)RESOURCE_WITH_METADATA);
    }

    private ResourceWithMetadata(Name alias, Table<ResourceWithMetadataRecord> aliased) {
        this(alias, aliased, null);
    }

    private ResourceWithMetadata(Name alias, Table<ResourceWithMetadataRecord> aliased, Field<?>[] parameters) {
        super(alias, null, aliased, parameters, DSL.comment((String)"VIEW"), TableOptions.view((String)"create view `resource_with_metadata` as select `keel`.`resource`.`uid` AS `uid`,`keel`.`resource`.`id` AS `id`,`keel`.`resource`.`application` AS `application`,`keel`.`resource`.`kind` AS `kind`,json_object('uid',`keel`.`resource`.`uid`,'id',`keel`.`resource`.`id`,'version',`keel`.`resource_version`.`version`,'application',`keel`.`resource`.`application`,'environment',`latest_environment`.`uid`,'environmentName',`latest_environment`.`name`,'deliveryConfig',`keel`.`delivery_config`.`uid`,'serviceAccount',`keel`.`delivery_config`.`service_account`) AS `metadata`,`keel`.`resource_version`.`spec` AS `spec` from ((((`keel`.`resource` join `keel`.`resource_version` on(((`keel`.`resource`.`uid` = `keel`.`resource_version`.`resource_uid`) and (`keel`.`resource_version`.`version` = (select max(`rv2`.`version`) from `keel`.`resource_version` `rv2` where (`keel`.`resource`.`uid` = `rv2`.`resource_uid`)))))) left join `keel`.`environment_resource` on((`keel`.`resource`.`uid` = `keel`.`environment_resource`.`resource_uid`))) join `keel`.`latest_environment` on(((`latest_environment`.`uid` = `keel`.`environment_resource`.`environment_uid`) and (`latest_environment`.`version` = `keel`.`environment_resource`.`environment_version`)))) left join `keel`.`delivery_config` on((`keel`.`delivery_config`.`uid` = `latest_environment`.`delivery_config_uid`)))"));
    }

    public <O extends Record> ResourceWithMetadata(Table<O> child, ForeignKey<O, ResourceWithMetadataRecord> key) {
        super(child, key, (Table)RESOURCE_WITH_METADATA);
    }

    public Schema getSchema() {
        return Keel.KEEL;
    }

    public ResourceWithMetadata as(String alias) {
        return new ResourceWithMetadata(DSL.name((String)alias), (Table<ResourceWithMetadataRecord>)this);
    }

    public ResourceWithMetadata as(Name alias) {
        return new ResourceWithMetadata(alias, (Table<ResourceWithMetadataRecord>)this);
    }

    public ResourceWithMetadata rename(String name) {
        return new ResourceWithMetadata(DSL.name((String)name), null);
    }

    public ResourceWithMetadata rename(Name name) {
        return new ResourceWithMetadata(name, null);
    }

    public Row6<String, String, String, String, String, String> fieldsRow() {
        return (Row6)super.fieldsRow();
    }
}

