/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.keel.persistence.metamodel.tables;

import com.netflix.spinnaker.jooq.LocalDateTimeToInstantConverter;
import com.netflix.spinnaker.keel.lifecycle.LifecycleEventType;
import com.netflix.spinnaker.keel.persistence.metamodel.Indexes;
import com.netflix.spinnaker.keel.persistence.metamodel.Keel;
import com.netflix.spinnaker.keel.persistence.metamodel.Keys;
import com.netflix.spinnaker.keel.persistence.metamodel.tables.LifecycleEvent;
import com.netflix.spinnaker.keel.persistence.metamodel.tables.records.LifecycleMonitorRecord;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import org.jooq.Converter;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Index;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Row7;
import org.jooq.Schema;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableOptions;
import org.jooq.UniqueKey;
import org.jooq.impl.DSL;
import org.jooq.impl.EnumConverter;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.TableImpl;

public class LifecycleMonitor
extends TableImpl<LifecycleMonitorRecord> {
    private static final long serialVersionUID = -25509058L;
    public static final LifecycleMonitor LIFECYCLE_MONITOR = new LifecycleMonitor();
    public final TableField<LifecycleMonitorRecord, String> UID = LifecycleMonitor.createField((Name)DSL.name((String)"uid"), (DataType)SQLDataType.CHAR((int)26).nullable(false), (Table)this, (String)"");
    public final TableField<LifecycleMonitorRecord, LifecycleEventType> TYPE = LifecycleMonitor.createField((Name)DSL.name((String)"type"), (DataType)SQLDataType.VARCHAR((int)50).nullable(false), (Table)this, (String)"", (Converter)new EnumConverter(String.class, LifecycleEventType.class));
    public final TableField<LifecycleMonitorRecord, String> LINK = LifecycleMonitor.createField((Name)DSL.name((String)"link"), (DataType)SQLDataType.VARCHAR((int)255).nullable(false), (Table)this, (String)"");
    public final TableField<LifecycleMonitorRecord, Instant> LAST_CHECKED = LifecycleMonitor.createField((Name)DSL.name((String)"last_checked"), (DataType)SQLDataType.LOCALDATETIME.nullable(false).defaultValue(DSL.field((String)"CURRENT_TIMESTAMP(3)", (DataType)SQLDataType.LOCALDATETIME)), (Table)this, (String)"", (Converter)new LocalDateTimeToInstantConverter());
    public final TableField<LifecycleMonitorRecord, String> TRIGGERING_EVENT_UID = LifecycleMonitor.createField((Name)DSL.name((String)"triggering_event_uid"), (DataType)SQLDataType.CHAR((int)26).nullable(false), (Table)this, (String)"");
    public final TableField<LifecycleMonitorRecord, Boolean> IGNORE = LifecycleMonitor.createField((Name)DSL.name((String)"ignore"), (DataType)SQLDataType.BIT.nullable(false).defaultValue((Field)DSL.inline((Object)"b'0'", (DataType)SQLDataType.BIT)), (Table)this, (String)"");
    public final TableField<LifecycleMonitorRecord, Integer> NUM_FAILURES = LifecycleMonitor.createField((Name)DSL.name((String)"num_failures"), (DataType)SQLDataType.INTEGER.nullable(false).defaultValue((Field)DSL.inline((Object)"0", (DataType)SQLDataType.INTEGER)), (Table)this, (String)"");

    public Class<LifecycleMonitorRecord> getRecordType() {
        return LifecycleMonitorRecord.class;
    }

    public LifecycleMonitor() {
        this(DSL.name((String)"lifecycle_monitor"), null);
    }

    public LifecycleMonitor(String alias) {
        this(DSL.name((String)alias), (Table<LifecycleMonitorRecord>)LIFECYCLE_MONITOR);
    }

    public LifecycleMonitor(Name alias) {
        this(alias, (Table<LifecycleMonitorRecord>)LIFECYCLE_MONITOR);
    }

    private LifecycleMonitor(Name alias, Table<LifecycleMonitorRecord> aliased) {
        this(alias, aliased, null);
    }

    private LifecycleMonitor(Name alias, Table<LifecycleMonitorRecord> aliased, Field<?>[] parameters) {
        super(alias, null, aliased, parameters, DSL.comment((String)""), TableOptions.table());
    }

    public <O extends Record> LifecycleMonitor(Table<O> child, ForeignKey<O, LifecycleMonitorRecord> key) {
        super(child, key, (Table)LIFECYCLE_MONITOR);
    }

    public Schema getSchema() {
        return Keel.KEEL;
    }

    public List<Index> getIndexes() {
        return Arrays.asList(Indexes.LIFECYCLE_MONITOR_LIFECYCLE_MONITOR_TYPE_LAST_CHECKED_IDX);
    }

    public UniqueKey<LifecycleMonitorRecord> getPrimaryKey() {
        return Keys.KEY_LIFECYCLE_MONITOR_PRIMARY;
    }

    public List<UniqueKey<LifecycleMonitorRecord>> getKeys() {
        return Arrays.asList(Keys.KEY_LIFECYCLE_MONITOR_PRIMARY);
    }

    public List<ForeignKey<LifecycleMonitorRecord, ?>> getReferences() {
        return Arrays.asList(Keys.FK_TRIGGERING_EVENT_UID);
    }

    public LifecycleEvent lifecycleEvent() {
        return new LifecycleEvent(this, Keys.FK_TRIGGERING_EVENT_UID);
    }

    public LifecycleMonitor as(String alias) {
        return new LifecycleMonitor(DSL.name((String)alias), (Table<LifecycleMonitorRecord>)this);
    }

    public LifecycleMonitor as(Name alias) {
        return new LifecycleMonitor(alias, (Table<LifecycleMonitorRecord>)this);
    }

    public LifecycleMonitor rename(String name) {
        return new LifecycleMonitor(DSL.name((String)name), null);
    }

    public LifecycleMonitor rename(Name name) {
        return new LifecycleMonitor(name, null);
    }

    public Row7<String, LifecycleEventType, String, Instant, String, Boolean, Integer> fieldsRow() {
        return (Row7)super.fieldsRow();
    }
}

