/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.keel.persistence.metamodel.tables;

import com.netflix.spinnaker.keel.persistence.metamodel.Keel;
import com.netflix.spinnaker.keel.persistence.metamodel.Keys;
import com.netflix.spinnaker.keel.persistence.metamodel.tables.EnvironmentVersion;
import com.netflix.spinnaker.keel.persistence.metamodel.tables.ResourceVersion;
import com.netflix.spinnaker.keel.persistence.metamodel.tables.records.EnvironmentResourceRecord;
import java.util.Arrays;
import java.util.List;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Row4;
import org.jooq.Schema;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableOptions;
import org.jooq.UniqueKey;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.TableImpl;

public class EnvironmentResource
extends TableImpl<EnvironmentResourceRecord> {
    private static final long serialVersionUID = 395311235L;
    public static final EnvironmentResource ENVIRONMENT_RESOURCE = new EnvironmentResource();
    public final TableField<EnvironmentResourceRecord, String> ENVIRONMENT_UID = EnvironmentResource.createField((Name)DSL.name((String)"environment_uid"), (DataType)SQLDataType.CHAR((int)26).nullable(false), (Table)this, (String)"");
    public final TableField<EnvironmentResourceRecord, Integer> ENVIRONMENT_VERSION = EnvironmentResource.createField((Name)DSL.name((String)"environment_version"), (DataType)SQLDataType.INTEGER.nullable(false), (Table)this, (String)"");
    public final TableField<EnvironmentResourceRecord, String> RESOURCE_UID = EnvironmentResource.createField((Name)DSL.name((String)"resource_uid"), (DataType)SQLDataType.CHAR((int)26).nullable(false), (Table)this, (String)"");
    public final TableField<EnvironmentResourceRecord, Integer> RESOURCE_VERSION = EnvironmentResource.createField((Name)DSL.name((String)"resource_version"), (DataType)SQLDataType.INTEGER.nullable(false), (Table)this, (String)"");

    public Class<EnvironmentResourceRecord> getRecordType() {
        return EnvironmentResourceRecord.class;
    }

    public EnvironmentResource() {
        this(DSL.name((String)"environment_resource"), null);
    }

    public EnvironmentResource(String alias) {
        this(DSL.name((String)alias), (Table<EnvironmentResourceRecord>)ENVIRONMENT_RESOURCE);
    }

    public EnvironmentResource(Name alias) {
        this(alias, (Table<EnvironmentResourceRecord>)ENVIRONMENT_RESOURCE);
    }

    private EnvironmentResource(Name alias, Table<EnvironmentResourceRecord> aliased) {
        this(alias, aliased, null);
    }

    private EnvironmentResource(Name alias, Table<EnvironmentResourceRecord> aliased, Field<?>[] parameters) {
        super(alias, null, aliased, parameters, DSL.comment((String)""), TableOptions.table());
    }

    public <O extends Record> EnvironmentResource(Table<O> child, ForeignKey<O, EnvironmentResourceRecord> key) {
        super(child, key, (Table)ENVIRONMENT_RESOURCE);
    }

    public Schema getSchema() {
        return Keel.KEEL;
    }

    public UniqueKey<EnvironmentResourceRecord> getPrimaryKey() {
        return Keys.KEY_ENVIRONMENT_RESOURCE_PRIMARY;
    }

    public List<UniqueKey<EnvironmentResourceRecord>> getKeys() {
        return Arrays.asList(Keys.KEY_ENVIRONMENT_RESOURCE_PRIMARY);
    }

    public List<ForeignKey<EnvironmentResourceRecord, ?>> getReferences() {
        return Arrays.asList(Keys.FK_ENVIRONMENT_RESOURCE_ENVIRONMENT_VERSION, Keys.FK_ENVIRONMENT_RESOURCE_RESOURCE_VERSION);
    }

    public EnvironmentVersion environmentVersion() {
        return new EnvironmentVersion(this, Keys.FK_ENVIRONMENT_RESOURCE_ENVIRONMENT_VERSION);
    }

    public ResourceVersion resourceVersion() {
        return new ResourceVersion(this, Keys.FK_ENVIRONMENT_RESOURCE_RESOURCE_VERSION);
    }

    public EnvironmentResource as(String alias) {
        return new EnvironmentResource(DSL.name((String)alias), (Table<EnvironmentResourceRecord>)this);
    }

    public EnvironmentResource as(Name alias) {
        return new EnvironmentResource(alias, (Table<EnvironmentResourceRecord>)this);
    }

    public EnvironmentResource rename(String name) {
        return new EnvironmentResource(DSL.name((String)name), null);
    }

    public EnvironmentResource rename(Name name) {
        return new EnvironmentResource(name, null);
    }

    public Row4<String, Integer, String, Integer> fieldsRow() {
        return (Row4)super.fieldsRow();
    }
}

